/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.interior;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.builders.utility.FractalFence;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISBannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISHeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISPotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISSignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Art;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;
import org.bukkit.plugin.Plugin;

public class TARDISBuilderPreview
implements Runnable {
    private final TARDIS plugin;
    private final Schematic schm;
    private final World world;
    private final int tips;
    private final HashMap<Block, BlockData> postBedBlocks = new HashMap();
    private final HashMap<Block, BlockData> postCarpetBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDoorBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDripstoneBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLanternBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLeverBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLichenBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonExtensionBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRepeaterBlocks = new HashMap();
    private final HashMap<Block, BlockData> postSculkVeinBlocks = new HashMap();
    private final HashMap<Block, BlockData> postStickyPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postTorchBlocks = new HashMap();
    private final HashMap<Block, JsonObject> postSignBlocks = new HashMap();
    private final List<Block> fractalBlocks = new ArrayList<Block>();
    private final List<Block> iceBlocks = new ArrayList<Block>();
    private final List<Block> postLightBlocks = new ArrayList<Block>();
    private final HashMap<Block, TARDISBannerData> postBannerBlocks = new HashMap();
    private Block postBedrock = null;
    private int task;
    private int level = 0;
    private int row = 0;
    private int startx;
    private int starty;
    private int startz;
    private int resetx;
    private int resetz;
    private int h;
    private int w;
    private int d;
    private int j = 2;
    private JsonArray arr;
    private JsonObject obj;
    private Location location;
    private boolean running = false;
    private Location ender = null;
    private int counter = 0;
    private double div = 1.0;

    public TARDISBuilderPreview(TARDIS plugin, Schematic schm, World world) {
        this.plugin = plugin;
        this.schm = schm;
        this.world = world;
        this.tips = schm.getPreview();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (!this.running) {
            this.starty = this.schm.getStartY();
            this.obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", this.schm.getPermission(), this.schm.isCustom());
            if (this.obj != null) {
                JsonObject dimensions = this.obj.get("dimensions").getAsJsonObject();
                this.h = dimensions.get("height").getAsInt() - 1;
                this.w = dimensions.get("width").getAsInt();
                this.d = dimensions.get("length").getAsInt() - 1;
                this.div = ((double)this.h + 1.0) * (double)this.w * ((double)this.d + 1.0);
                TARDISInteriorPostioning tARDISInteriorPostioning = new TARDISInteriorPostioning(this.plugin);
                TARDISTIPSData pos = tARDISInteriorPostioning.getTIPSData(this.tips);
                this.startx = pos.getCentreX();
                this.resetx = pos.getCentreX();
                this.startz = pos.getCentreZ();
                this.resetz = pos.getCentreZ();
                Location cl = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                Chunk c = this.world.getChunkAt(cl);
                while (!c.isLoaded()) {
                    c.load(true);
                }
                this.location = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                this.arr = this.obj.get("input").getAsJsonArray();
                this.running = true;
            }
        }
        if (this.level == this.h && this.row == this.w - 1) {
            this.postBedBlocks.forEach(Block::setBlockData);
            this.postDoorBlocks.forEach(Block::setBlockData);
            this.postRedstoneTorchBlocks.forEach(Block::setBlockData);
            this.postTorchBlocks.forEach(Block::setBlockData);
            this.postLanternBlocks.forEach(Block::setBlockData);
            this.postRepeaterBlocks.forEach(Block::setBlockData);
            this.postStickyPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonExtensionBlocks.forEach(Block::setBlockData);
            this.postLeverBlocks.forEach(Block::setBlockData);
            this.postDripstoneBlocks.forEach(Block::setBlockData);
            this.postLichenBlocks.forEach(Block::setBlockData);
            this.postSculkVeinBlocks.forEach(Block::setBlockData);
            TARDISSignSetter.setSigns(this.postSignBlocks, this.plugin, -1);
            for (Map.Entry entry : this.postCarpetBlocks.entrySet()) {
                Block pcb = (Block)entry.getKey();
                pcb.setBlockData((BlockData)entry.getValue());
            }
            if (this.postBedrock != null) {
                this.postBedrock.setBlockData(TARDISConstants.POWER);
            }
            this.postLightBlocks.forEach(block -> {
                if (block.getType().isAir()) {
                    Levelled levelled = TARDISConstants.LIGHT;
                    levelled.setLevel(15);
                    block.setBlockData((BlockData)levelled);
                }
            });
            if (this.schm.getPermission().equals("cave")) {
                this.iceBlocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                this.iceBlocks.clear();
            }
            for (int f = 0; f < this.fractalBlocks.size(); ++f) {
                FractalFence.grow(this.fractalBlocks.get(f), f);
            }
            TARDISBannerSetter.setBanners(this.postBannerBlocks);
            if (this.ender != null) {
                Entity ender_crystal = this.world.spawnEntity(this.ender, EntityType.END_CRYSTAL);
                ((EnderCrystal)ender_crystal).setShowingBottom(false);
            }
            if (this.obj.has("paintings")) {
                void var2_11;
                JsonArray paintings = (JsonArray)this.obj.get("paintings");
                boolean bl = false;
                while (var2_11 < paintings.size()) {
                    Location pl;
                    JsonObject painting = paintings.get((int)var2_11).getAsJsonObject();
                    JsonObject rel = painting.get("rel_location").getAsJsonObject();
                    int px = rel.get("x").getAsInt();
                    int py = rel.get("y").getAsInt();
                    int pz = rel.get("z").getAsInt();
                    BlockFace facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
                    String which = painting.get("art").getAsString();
                    Art art = null;
                    if (which.contains(":")) {
                        pl = TARDISPainting.calculatePosition(which.split(":")[1], facing, new Location(this.world, (double)(this.resetx + px), (double)(this.starty + py), (double)(this.resetz + pz)));
                    } else {
                        art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey("minecraft", which.toLowerCase(Locale.ROOT)));
                        pl = TARDISPainting.calculatePosition(art, facing, new Location(this.world, (double)(this.resetx + px), (double)(this.starty + py), (double)(this.resetz + pz)));
                    }
                    try {
                        Painting ent = (Painting)this.world.spawnEntity(pl, EntityType.PAINTING);
                        ent.teleport(pl);
                        ent.setFacingDirection(facing, true);
                        if (art != null) {
                            ent.setArt(art, true);
                        } else {
                            DataPackPainting.setCustomVariant(ent, which);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.debug("Invalid painting location!" + String.valueOf(pl));
                    }
                    ++var2_11;
                }
            }
            if (this.obj.has("item_frames")) {
                void var2_13;
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                boolean bl = false;
                while (var2_13 < frames.size()) {
                    TARDISItemFrameSetter.curate(frames.get((int)var2_13).getAsJsonObject(), this.location, -1);
                    ++var2_13;
                }
            }
            if (this.obj.has("item_displays")) {
                void var2_15;
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                boolean bl = false;
                while (var2_15 < displays.size()) {
                    TARDISItemDisplaySetter.fakeBlock(displays.get((int)var2_15).getAsJsonObject(), this.location, this.tips);
                    ++var2_15;
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
        }
        JsonArray floor = this.arr.get(this.level).getAsJsonArray();
        JsonArray jsonArray = (JsonArray)floor.get(this.row);
        for (int col = 0; col <= this.d; ++col) {
            Object bisected;
            ++this.counter;
            JsonObject c = jsonArray.get(col).getAsJsonObject();
            int x = this.startx + this.row;
            int y = this.starty + this.level;
            int z = this.startz + col;
            BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
            Material type = data.getMaterial();
            if (type.equals((Object)Material.LIGHT_GRAY_CONCRETE) && (this.schm.getPermission().equals("bone") || this.schm.getPermission().equals("rustic"))) {
                Block block2 = new Location(this.world, (double)x, (double)y, (double)z).getBlock();
                String ct = this.schm.getPermission().equals("bone") ? "console_light_gray" : "console_rustic";
                new ConsoleBuilder(this.plugin).create(block2, ct, -1, UUID.randomUUID().toString());
            }
            if (type.equals((Object)Material.NOTE_BLOCK)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.DISK_STORAGE, this.world, x, y, z);
            }
            if (type.equals((Object)Material.ORANGE_WOOL)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.HEXAGON, this.world, x, y, z);
            }
            if (type.equals((Object)Material.BLUE_WOOL)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.BLUE_BOX, this.world, x, y, z);
            }
            if ((type.equals((Object)Material.WARPED_FENCE) || type.equals((Object)Material.CRIMSON_FENCE)) && this.schm.getPermission().equals("delta")) {
                this.fractalBlocks.add(this.world.getBlockAt(x, y, z));
            }
            if (this.level == 0 && type.equals((Object)Material.PINK_STAINED_GLASS) && this.schm.getPermission().equals("division")) {
                this.postLightBlocks.add(this.world.getBlockAt(x, y - 1, z));
            }
            if (type.equals((Object)Material.DEEPSLATE_REDSTONE_ORE) && (this.schm.getPermission().equals("division") || this.schm.getPermission().equals("hospital"))) {
                BlockData blockData = data = this.schm.getPermission().equals("division") ? Material.GRAY_CONCRETE.createBlockData() : Material.LIGHT_GRAY_CONCRETE.createBlockData();
            }
            if (type.equals((Object)Material.WHITE_STAINED_GLASS) && this.schm.getPermission().equals("war")) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.ROUNDEL, this.world, x, y, z);
            }
            if (type.equals((Object)Material.WHITE_TERRACOTTA) && this.schm.getPermission().equals("war")) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.ROUNDEL_OFFSET, this.world, x, y, z);
            }
            if (type.equals((Object)Material.IRON_DOOR) && (bisected = (Bisected)data).getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", this.tips);
                set.put("name", this.schm.getPermission());
                set.put("world", this.world.getName());
                set.put("x", (double)x + 0.5);
                set.put("y", y);
                set.put("z", z + 1);
                this.plugin.getQueryFactory().doInsert("transmats", set);
            }
            if (type.equals((Object)Material.JUKEBOX)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISDisplayItem.ADVANCED_CONSOLE, this.world, x, y, z);
            }
            if ((type.equals((Object)Material.COMMAND_BLOCK) || (this.schm.getPermission().equals("bigger") || this.schm.getPermission().equals("coral") || this.schm.getPermission().equals("deluxe") || this.schm.getPermission().equals("twelfth")) && type.equals((Object)Material.BEACON)) && type.equals((Object)Material.COMMAND_BLOCK)) {
                switch (this.schm.getPermission()) {
                    case "ender": {
                        BlockData blockData = Material.END_STONE_BRICKS.createBlockData();
                        break;
                    }
                    case "delta": 
                    case "cursed": {
                        BlockData blockData = Material.BLACKSTONE.createBlockData();
                        break;
                    }
                    case "ancient": 
                    case "bone": 
                    case "fugitive": {
                        BlockData blockData = Material.GRAY_WOOL.createBlockData();
                        break;
                    }
                    case "hospital": {
                        BlockData blockData = Material.LIGHT_GRAY_WOOL.createBlockData();
                        break;
                    }
                    default: {
                        BlockData blockData = data = Material.STONE_BRICKS.createBlockData();
                    }
                }
            }
            if (type.equals((Object)Material.BEACON) && this.schm.getPermission().equals("ender")) {
                this.ender = this.world.getBlockAt(x, y, z).getLocation().add(0.5, 4.0, 0.5);
            }
            if (type.equals((Object)Material.ICE) && this.schm.getPermission().equals("cave")) {
                this.iceBlocks.add(this.world.getBlockAt(x, y, z));
            } else if (Tag.BEDS.isTagged((Keyed)type)) {
                this.postBedBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.IRON_DOOR)) {
                this.postDoorBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.REDSTONE_WALL_TORCH)) {
                this.postRedstoneTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.TORCH) || type.equals((Object)Material.WALL_TORCH) || type.equals((Object)Material.SOUL_TORCH) || type.equals((Object)Material.SOUL_WALL_TORCH)) {
                this.postTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.STICKY_PISTON)) {
                this.postStickyPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON)) {
                this.postPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON_HEAD)) {
                this.postPistonExtensionBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LEVER)) {
                this.postLeverBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (Tag.ALL_SIGNS.isTagged((Keyed)type)) {
                this.postSignBlocks.put(this.world.getBlockAt(x, y, z), c);
            } else if (type.equals((Object)Material.POINTED_DRIPSTONE)) {
                this.postDripstoneBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.GLOW_LICHEN)) {
                this.postLichenBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.SCULK_VEIN)) {
                this.postSculkVeinBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LANTERN) || type.equals((Object)Material.SOUL_LANTERN)) {
                this.postLanternBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (TARDISStaticUtils.isBanner(type)) {
                JsonObject state;
                JsonObject jsonObject = state = c.has("banner") ? c.get("banner").getAsJsonObject() : null;
                if (state != null) {
                    TARDISBannerData tbd = new TARDISBannerData(data, state);
                    this.postBannerBlocks.put(this.world.getBlockAt(x, y, z), tbd);
                }
            } else if (type.equals((Object)Material.PLAYER_HEAD) || type.equals((Object)Material.PLAYER_WALL_HEAD)) {
                JsonObject head;
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                if (c.has("head") && (head = c.get("head").getAsJsonObject()).has("uuid")) {
                    try {
                        UUID uuid = UUID.fromString(head.get("uuid").getAsString());
                        TARDISHeadSetter.textureSkull(this.plugin, uuid, head, this.world.getBlockAt(x, y, z));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else if (type.equals((Object)Material.DECORATED_POT)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (c.has("pot")) {
                        JsonObject pot = c.get("pot").getAsJsonObject();
                        TARDISPotSetter.decorate(this.plugin, pot, this.world.getBlockAt(x, y, z));
                    }
                }, 1L);
            } else if (TARDISStaticUtils.isInfested(type)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.MUSHROOM_STEM)) {
                if (this.j < 6) {
                    data = Material.REPEATER.createBlockData();
                    Directional directional = (Directional)data;
                    switch (this.j) {
                        case 2: {
                            directional.setFacing(BlockFace.WEST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        case 3: {
                            directional.setFacing(BlockFace.NORTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        case 4: {
                            directional.setFacing(BlockFace.SOUTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        default: {
                            directional.setFacing(BlockFace.EAST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                        }
                    }
                    ++this.j;
                }
            } else if (type.equals((Object)Material.SPONGE)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.BEDROCK)) {
                this.postBedrock = this.world.getBlockAt(x, y, z);
            } else if (type.equals((Object)Material.BROWN_MUSHROOM) && this.schm.getPermission().equals("master")) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
                this.plugin.setTardisSpawn(true);
                this.world.spawnEntity(new Location(this.world, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5), EntityType.VILLAGER);
            } else if (type.equals((Object)Material.BLACK_CARPET) && this.schm.getPermission().equals("master")) {
                this.postCarpetBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
            }
            if (col == this.d && this.row < this.w) {
                ++this.row;
            }
            if (col != this.d || this.row != this.w || this.level >= this.h) continue;
            this.row = 0;
            ++this.level;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

