/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Room;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ItemDisplay;

public class TARDISDevTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"add_regions", (Object)"advancements", (Object)"armour", (Object)"biome", (Object)"box", (Object)"brushable", (Object)"chunks", (Object)"chunky", (Object)"circuit", (Object)"component", (Object)"dalek", (Object)"debug", (Object[])new String[]{"dialog", "dismount", "displayitem", "effect", "empty", "frame", "furnace", "gravity", "give", "happy", "head", "interaction", "label", "leather", "list", "monster", "ntc", "nms", "plurals", "recipe", "regen", "registry", "rooms", "screen", "skin", "snapshot", "stats", "systree", "tis", "tips", "tree", "trim", "zero"});
    private final ImmutableList<String> LIST_SUBS = ImmutableList.of((Object)"preset_perms", (Object)"perms", (Object)"recipes", (Object)"blueprints", (Object)"commands", (Object)"block_colours", (Object)"change", (Object)"consoles");
    private final ImmutableList<String> SNAPSHOT_SUBS = ImmutableList.of((Object)"in", (Object)"out", (Object)"c");
    private final ImmutableList<String> STATE_SUBS = ImmutableList.of((Object)"closed", (Object)"open", (Object)"stained", (Object)"glass", (Object)"fly");
    private final ImmutableList<String> FRAME_SUBS = ImmutableList.of((Object)"lock", (Object)"unlock");
    private final ImmutableList<String> SCREEN_SUBS = ImmutableList.of((Object)"forward", (Object)"backward", (Object)"left", (Object)"right");
    private final ImmutableList<String> COMPONENT_SUBS = ImmutableList.of((Object)"ars", (Object)"repeater", (Object)"key", (Object)"pack", (Object)"extra");
    private final ImmutableList<String> DEBUG_SUBS = ImmutableList.of((Object)"create", (Object)"update", (Object)"enter", (Object)"exit");
    private final ImmutableList<String> DISPLAY_SUBS = ImmutableList.of((Object)"add", (Object)"animate", (Object)"remove", (Object)"place", (Object)"break", (Object)"convert", (Object)"chunk", (Object)"console");
    private final List<String> STONE_SUBS = new ArrayList<String>();
    private final List<String> MAT_SUBS = new ArrayList<String>();
    private final List<String> TRANSFORM_SUBS = new ArrayList<String>();
    private final List<String> ITEM_SUBS = new ArrayList<String>();
    private final List<String> PRESET_SUBS = new ArrayList<String>();
    private final List<String> MONSTER_SUBS = new ArrayList<String>();
    private final List<String> EFFECT_SUBS = new ArrayList<String>();
    private final List<String> ROOM_SUBS = new ArrayList<String>();
    private final List<String> SHAPE_SUBS = new ArrayList<String>();
    private final ImmutableList<String> RECIPE_SUBS = ImmutableList.of((Object)"shaped", (Object)"shapeless", (Object)"chest", (Object)"chemistry", (Object)"custom");

    public TARDISDevTabComplete(TARDIS plugin) {
        plugin.getTardisHelper().getTreeMaterials().forEach(m -> this.MAT_SUBS.add(m.toString()));
        for (TARDISDisplayItem tARDISDisplayItem : TARDISDisplayItem.values()) {
            this.STONE_SUBS.add(tARDISDisplayItem.getName());
        }
        for (TARDISDisplayItem tARDISDisplayItem : ItemDisplay.ItemDisplayTransform.values()) {
            this.TRANSFORM_SUBS.add(tARDISDisplayItem.toString());
        }
        for (TARDISDisplayItem tARDISDisplayItem : Material.values()) {
            if (!tARDISDisplayItem.isItem()) continue;
            this.ITEM_SUBS.add(tARDISDisplayItem.toString());
        }
        for (Enum enum_ : ChameleonPreset.values()) {
            if (!((ChameleonPreset)enum_).usesArmourStand()) continue;
            this.PRESET_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : Monster.values()) {
            this.MONSTER_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : ParticleEffect.values()) {
            this.EFFECT_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : ParticleShape.values()) {
            this.SHAPE_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : Room.values()) {
            this.ROOM_SUBS.add(enum_.toString());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        String sub = args[0];
        switch (args.length) {
            case 1: {
                return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
            }
            case 2: {
                return switch (sub) {
                    case "list" -> this.partial(lastArg, (Collection<String>)this.LIST_SUBS);
                    case "box" -> this.partial(lastArg, this.PRESET_SUBS);
                    case "debug" -> this.partial(lastArg, (Collection<String>)this.DEBUG_SUBS);
                    case "nms", "trim" -> this.partial(lastArg, this.MONSTER_SUBS);
                    case "tree" -> this.partial(lastArg, this.MAT_SUBS);
                    case "snapshot" -> this.partial(lastArg, (Collection<String>)this.SNAPSHOT_SUBS);
                    case "displayitem" -> this.partial(lastArg, (Collection<String>)this.DISPLAY_SUBS);
                    case "frame" -> this.partial(lastArg, (Collection<String>)this.FRAME_SUBS);
                    case "recipe" -> this.partial(lastArg, (Collection<String>)this.RECIPE_SUBS);
                    case "rooms" -> this.partial(lastArg, this.ROOM_SUBS);
                    case "effect" -> this.partial(lastArg, this.SHAPE_SUBS);
                    case "screen" -> this.partial(lastArg, (Collection<String>)this.SCREEN_SUBS);
                    case "component" -> this.partial(lastArg, (Collection<String>)this.COMPONENT_SUBS);
                    default -> ImmutableList.of();
                };
            }
            case 3: {
                return switch (sub) {
                    case "box" -> this.partial(lastArg, (Collection<String>)this.STATE_SUBS);
                    case "effect" -> this.partial(lastArg, this.EFFECT_SUBS);
                    case "rooms" -> this.partial(lastArg, this.ROOM_SUBS);
                    default -> ImmutableList.of();
                };
            }
            case 4: {
                if (sub.equals("displayitem")) {
                    return this.partial(lastArg, this.TRANSFORM_SUBS);
                }
                if (!sub.equals("rooms")) break;
                return this.partial(lastArg, this.ROOM_SUBS);
            }
            default: {
                if (sub.equals("rooms")) {
                    return this.partial(lastArg, this.ROOM_SUBS);
                }
                return switch (args[1]) {
                    case "place" -> this.partial(lastArg, this.STONE_SUBS);
                    case "add" -> this.partial(lastArg, this.ITEM_SUBS);
                    default -> this.partial(lastArg, this.MAT_SUBS);
                };
            }
        }
        return ImmutableList.of();
    }
}

