/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.google.gson.JsonObject;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISChunkUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISLampsCommand {
    private final TARDIS plugin;

    TARDISLampsCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean addLampBlocks(Player owner) {
        if (!TARDISPermission.hasPermission(owner, "tardis.update")) {
            this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "NO_PERMS");
            return false;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", owner.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            ResultSetLamps rsl = new ResultSetLamps(this.plugin, wherel, false);
            if (rsl.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "LAMP_DELETE");
                HashMap<String, Object> wheredel = new HashMap<String, Object>();
                wheredel.put("tardis_id", id);
                this.plugin.getQueryFactory().doDelete("lamps", wheredel);
            }
            String[] tc = tardis.getChunk().split(":");
            int cx = TARDISNumberParsers.parseInt(tc[1]);
            int cz = TARDISNumberParsers.parseInt(tc[2]);
            World world = TARDISAliasResolver.getWorldFromAlias(tc[0]);
            Chunk startChunk = world.getChunkAt(cx, cz);
            Schematic schm = tardis.getSchematic();
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", schm.getPermission(), schm.isCustom());
            if (obj != null) {
                JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                int h = dimensions.get("height").getAsInt();
                int starty = schm.getStartY();
                int endy = starty + h;
                String w = world.getName();
                for (Chunk chunk : TARDISChunkUtils.getConsoleChunks(startChunk, tardis.getSchematic())) {
                    int bx = chunk.getX() << 4;
                    int bz = chunk.getZ() << 4;
                    for (int xx = bx; xx < bx + 16; ++xx) {
                        for (int zz = bz; zz < bz + 16; ++zz) {
                            for (int yy = starty; yy < endy; ++yy) {
                                Material mat = world.getBlockAt(xx, yy, zz).getType();
                                if (!mat.equals((Object)Material.LIGHT)) continue;
                                String lamp = w + ":" + xx + ":" + yy + ":" + zz;
                                HashMap<String, Object> set = new HashMap<String, Object>();
                                set.put("tardis_id", id);
                                set.put("location", lamp);
                                this.plugin.getQueryFactory().doInsert("lamps", set);
                                this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "LAMP_ADD", xx + ":" + yy + ":" + zz);
                            }
                        }
                    }
                }
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "NOT_A_TIMELORD");
        return false;
    }
}

