/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISSetDestinationCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    TARDISSetDestinationCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean doSetDestination(Player player, String[] args) {
        if (TARDISPermission.hasPermission(player, "tardis.save")) {
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            String uuid = player.getUniqueId().toString();
            if (!rs.fromUUID(uuid)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid, SystemTree.SAVES)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            if (!LETTERS_NUMBERS.matcher(args[1]).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_NAME_NOT_VALID");
                return false;
            }
            if (args[1].equalsIgnoreCase("hide") || args[1].equalsIgnoreCase("rebuild") || args[1].equalsIgnoreCase("home")) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_RESERVED", "/tardis home", this.plugin);
                return false;
            }
            int id = rs.getTardisId();
            TARDISCircuitChecker tcc = null;
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
                tcc = new TARDISCircuitChecker(this.plugin, id);
                tcc.getCircuits();
            }
            if (tcc != null && !tcc.hasMemory()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                return true;
            }
            HashMap<String, Object> wherettrav = new HashMap<String, Object>();
            wherettrav.put("uuid", uuid);
            wherettrav.put("tardis_id", id);
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherettrav, false);
            if (rst.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_TARDIS");
                return true;
            }
            Block b = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50);
            Location l = b.getLocation();
            if (this.plugin.getTardisArea().isInExistingArea(l)) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_SETDEST", "/tardistravel area [area name]", this.plugin);
                return true;
            }
            String world = l.getWorld().getName();
            if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && world.equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                return true;
            }
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_WORLD");
                return true;
            }
            if (!this.plugin.getPluginRespect().getRespect(l, new Parameters(player, Flag.getDefaultFlags()))) {
                return true;
            }
            if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
                String areaPerm = this.plugin.getTardisArea().getExileArea(player);
                if (this.plugin.getTardisArea().areaCheckInExile(areaPerm, l)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXILE_NO_TRAVEL");
                    return false;
                }
            }
            String dw = l.getWorld().getName();
            int dx = l.getBlockX();
            int dy = l.getBlockY() + 1;
            int dz = l.getBlockZ();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", id);
            set.put("dest_name", args[1]);
            set.put("world", dw);
            set.put("x", dx);
            set.put("y", dy);
            set.put("z", dz);
            if (this.plugin.getQueryFactory().doSyncInsert("destinations", set) < 0) {
                return false;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_SAVED", args[1]);
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

