/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.customblocks.ArtronFurnaceUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.BlockBreak;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDeadlock;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.doors.DoorAnimator;
import me.eccentric_nz.TARDIS.doors.DoorLockAction;
import me.eccentric_nz.TARDIS.doors.DoorUtility;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorExtra;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorMover;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorAction;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.sonic.actions.TARDISSonicLight;
import me.eccentric_nz.TARDIS.update.UpdateDoor;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TARDISDisplayBlockListener
implements Listener {
    private final TARDIS plugin;

    public TARDISDisplayBlockListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDisplayBlockPlace(BlockPlaceEvent event) {
        ResultSetTardisID rst;
        Block furnace;
        Levelled data;
        Player player = event.getPlayer();
        ItemStack is = player.getInventory().getItemInMainHand();
        ItemStack single = is.clone();
        single.setAmount(1);
        if (!is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (!im.hasDisplayName() || !im.getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.STRING)) {
            return;
        }
        if (ComponentUtils.endsWith(im.displayName(), "TARDIS Seed Block") || ComponentUtils.endsWith(im.displayName(), "Console")) {
            return;
        }
        String key = (String)im.getPersistentDataContainer().get(this.plugin.getCustomBlockKey(), PersistentDataType.STRING);
        NamespacedKey model = new NamespacedKey((Plugin)this.plugin, key);
        TARDISDisplayItem which = TARDISDisplayItem.getByModel(model);
        if (which == null) {
            return;
        }
        Location location = event.getBlock().getLocation();
        event.setCancelled(true);
        if (which.isLight() || which == TARDISDisplayItem.DOOR || which == TARDISDisplayItem.CLASSIC_DOOR || which == TARDISDisplayItem.BONE_DOOR || which == TARDISDisplayItem.CONSOLE_LAMP) {
            if (which.isLight() || which == TARDISDisplayItem.CONSOLE_LAMP) {
                Levelled light = TARDISConstants.LIGHT;
                light.setLevel(which.isLit() ? 15 : 0);
                data = light;
            } else {
                data = null;
            }
            TARDISDisplayItemUtils.set(location, model.getKey(), which == TARDISDisplayItem.DOOR || which == TARDISDisplayItem.CLASSIC_DOOR || which == TARDISDisplayItem.BONE_DOOR);
        } else {
            data = TARDISConstants.BARRIER;
        }
        if (data != null) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> TARDISDisplayBlockListener.lambda$onDisplayBlockPlace$0(location, (BlockData)data), 1L);
        }
        double ay = which == TARDISDisplayItem.DOOR || which == TARDISDisplayItem.CLASSIC_DOOR || which == TARDISDisplayItem.BONE_DOOR ? 0.0 : 0.5;
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.add(0.5, ay, 0.5), EntityType.ITEM_DISPLAY);
        display.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)which.getCustomModel().getKey());
        display.setItemStack(single);
        display.setPersistent(true);
        display.setInvulnerable(true);
        if (which == TARDISDisplayItem.DOOR || which == TARDISDisplayItem.CLASSIC_DOOR || which == TARDISDisplayItem.BONE_DOOR || which == TARDISDisplayItem.TELEVISION) {
            if (which != TARDISDisplayItem.TELEVISION) {
                display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
            }
            float yaw = DoorUtility.getLookAtYaw(player);
            display.setRotation(yaw, 0.0f);
        }
        if (which == TARDISDisplayItem.ARTRON_CAPACITOR_STORAGE && (furnace = ArtronFurnaceUtils.find(event.getBlock(), this.plugin)) != null) {
            ArtronFurnaceUtils.register(furnace.getLocation().toString(), player, this.plugin);
        }
        if (which == TARDISDisplayItem.CONSOLE_LAMP && (rst = new ResultSetTardisID(this.plugin)).fromUUID(player.getUniqueId().toString())) {
            this.plugin.getQueryFactory().insertSyncControl(rst.getTardisId(), 56, event.getBlockPlaced().getLocation().toString(), 0);
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            int amount = is.getAmount() - 1;
            if (amount < 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                is.setAmount(amount);
                player.getInventory().setItemInMainHand(is);
            }
        }
    }

    @EventHandler
    public void onDisplayBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.LIGHT && block.getType() != Material.BARRIER) {
            return;
        }
        if (this.plugin.getArtronConfig().getBoolean("artron_furnace.tardis_powered")) {
            ArtronFurnaceUtils.removeFromCapacitor(block, event.getPlayer(), this.plugin);
        }
        TARDISDisplayItemUtils.remove(block);
    }

    @EventHandler
    public void onDisplayBlockInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            Player player = event.getPlayer();
            if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && block.getType().equals((Object)Material.BARRIER) && Tag.ITEMS_PICKAXES.isTagged((Keyed)player.getInventory().getItemInMainHand().getType())) {
                Location l = block.getLocation();
                ItemDisplay breaking = null;
                ItemDisplay fake = null;
                for (Entity e : l.getWorld().getNearbyEntities(block.getBoundingBox().expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
                    ItemDisplay display;
                    ItemStack is;
                    if (!(e instanceof ItemDisplay) || (is = (display = (ItemDisplay)e).getItemStack()) == null || !is.hasItemMeta()) continue;
                    if (is.getItemMeta().getPersistentDataContainer().has(this.plugin.getDestroyKey(), PersistentDataType.INTEGER)) {
                        breaking = display;
                    }
                    if (!is.getItemMeta().getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.STRING)) continue;
                    fake = display;
                }
                this.processInteraction(fake, breaking, player, l, block, null);
            }
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)player.getInventory().getItemInMainHand().getType())) {
                ItemStack dis = player.getInventory().getItemInMainHand();
                if (!dis.hasItemMeta()) {
                    return;
                }
                ItemMeta dim = dis.getItemMeta();
                if (!dim.hasItemModel() || !dim.getItemModel().getKey().contains("_closed")) {
                    return;
                }
                event.setCancelled(true);
                Location location = event.getClickedBlock().getRelative(BlockFace.UP).getLocation();
                DoorUtility.set(this.plugin, player, location);
                if (player.getGameMode() != GameMode.CREATIVE) {
                    int amount = dis.getAmount() - 1;
                    if (amount < 1) {
                        player.getInventory().setItemInMainHand(null);
                    } else {
                        dis.setAmount(amount);
                        player.getInventory().setItemInMainHand(dis);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInteractionClick(PlayerInteractAtEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            if (interaction.getPersistentDataContainer().has(this.plugin.getStandUuidKey(), this.plugin.getPersistentDataTypeUUID())) {
                Player player = event.getPlayer();
                UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getStandUuidKey(), this.plugin.getPersistentDataTypeUUID());
                if (uuid == null) {
                    return;
                }
                ArmorStand stand = (ArmorStand)this.plugin.getServer().getEntity(uuid);
                if (stand == null) {
                    return;
                }
                if (stand.getEquipment() == null) {
                    return;
                }
                int id = (Integer)interaction.getPersistentDataContainer().get(this.plugin.getTardisIdKey(), PersistentDataType.INTEGER);
                new OuterDisplayDoorAction(this.plugin).processClick(id, player, stand);
            } else {
                ItemDisplay display = TARDISDisplayItemUtils.get(interaction);
                if (display == null) {
                    return;
                }
                event.setCancelled(true);
                Player player = event.getPlayer();
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (this.isRedstoneSonic(inHand)) {
                    TARDISSonicLight tsl = new TARDISSonicLight(this.plugin);
                    if (player.isSneaking() && this.plugin.getConfig().getBoolean("allow.add_lights")) {
                        tsl.addLamp(interaction.getLocation().getBlock(), player);
                    } else {
                        tsl.toggle(display, interaction.getLocation().getBlock());
                    }
                } else if (Tag.ITEMS_PICKAXES.isTagged((Keyed)inHand.getType())) {
                    Location l = interaction.getLocation();
                    ItemDisplay breaking = null;
                    for (Entity e : l.getWorld().getNearbyEntities(l, 0.55, 0.55, 0.55, d -> d.getType() == EntityType.ITEM_DISPLAY)) {
                        ItemDisplay item;
                        ItemStack stack;
                        if (!(e instanceof ItemDisplay) || (stack = (item = (ItemDisplay)e).getItemStack()) == null || !stack.hasItemMeta() || !stack.getItemMeta().getPersistentDataContainer().has(this.plugin.getDestroyKey(), PersistentDataType.INTEGER)) continue;
                        breaking = item;
                    }
                    this.processInteraction(display, breaking, player, l, l.getBlock(), interaction);
                } else {
                    TARDISDisplayItem tdi = TARDISDisplayItemUtils.get(display);
                    if (tdi != null) {
                        Block block;
                        Material toPlace;
                        if (tdi == TARDISDisplayItem.CUSTOM_DOOR || tdi == TARDISDisplayItem.DOOR_BOTH_OPEN || tdi == TARDISDisplayItem.DOOR || tdi == TARDISDisplayItem.DOOR_OPEN || tdi == TARDISDisplayItem.CLASSIC_DOOR || tdi == TARDISDisplayItem.CLASSIC_DOOR_OPEN || tdi == TARDISDisplayItem.BONE_DOOR || tdi == TARDISDisplayItem.BONE_DOOR_OPEN) {
                            if (!player.isOp() && !this.plugin.getUtils().inTARDISWorld(player)) {
                                return;
                            }
                            Block block2 = interaction.getLocation().getBlock();
                            UUID playerUUID = player.getUniqueId();
                            UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
                            HashMap<String, Object> where = new HashMap<String, Object>();
                            where.put("uuid", uuid);
                            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                            if (!rs.resultSet()) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                                this.plugin.getTrackerKeeper().getUpdatePlayers().remove(playerUUID);
                                return;
                            }
                            Tardis tardis = rs.getTardis();
                            int id = tardis.getTardisId();
                            if (this.plugin.getTrackerKeeper().getUpdatePlayers().containsKey(playerUUID)) {
                                new UpdateDoor(this.plugin).process(Updateable.DOOR, block2, false, id, player);
                                this.plugin.getTrackerKeeper().getUpdatePlayers().remove(playerUUID);
                                TARDISSudoTracker.SUDOERS.remove(playerUUID);
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_SET", "double door");
                                return;
                            }
                            if (player.isSneaking()) {
                                ItemStack itemStack;
                                if (tdi == TARDISDisplayItem.DOOR || tdi == TARDISDisplayItem.CLASSIC_DOOR || tdi == TARDISDisplayItem.BONE_DOOR || tdi == TARDISDisplayItem.CUSTOM_DOOR && this.isCustomClosed(display)) {
                                    new InnerDisplayDoorMover(this.plugin).exit(player, block2);
                                    return;
                                }
                                if ((tdi == TARDISDisplayItem.DOOR_OPEN || tdi == TARDISDisplayItem.CUSTOM_DOOR && !this.isCustomClosed(display)) && (itemStack = display.getItemStack()) != null) {
                                    NamespacedKey cmd;
                                    ItemMeta im = itemStack.getItemMeta();
                                    NamespacedKey namespacedKey = cmd = tdi == TARDISDisplayItem.DOOR_OPEN ? TardisDoorVariant.TARDIS_DOOR_OPEN.getKey() : Door.getExtraModel(itemStack.getType());
                                    if (cmd != null) {
                                        im.setItemModel(cmd);
                                        itemStack.setItemMeta(im);
                                        display.setItemStack(itemStack);
                                        new InnerDisplayDoorExtra(this.plugin).deactivate(block2, id, playerUUID);
                                    }
                                }
                            } else {
                                boolean outerDisplayDoor = tardis.getPreset().usesArmourStand();
                                ResultSetDeadlock rsd = new ResultSetDeadlock(this.plugin, display.getLocation());
                                if (rsd.resultSet() && rsd.isLocked()) {
                                    this.plugin.getMessenger().sendStatus(player, "DOOR_DEADLOCKED");
                                    return;
                                }
                                ItemStack itemStack = display.getItemStack();
                                if (itemStack != null) {
                                    ItemMeta im = itemStack.getItemMeta();
                                    boolean open = !im.getItemModel().getKey().contains("_closed");
                                    new DoorAnimator(this.plugin, display).animate(open);
                                    if (open) {
                                        new InnerDisplayDoorCloser(this.plugin).close(block2, id, playerUUID, false);
                                        if (outerDisplayDoor) {
                                            new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID);
                                        } else if (tardis.getPreset().hasDoor()) {
                                            new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                                        }
                                    } else {
                                        new InnerDisplayDoorOpener(this.plugin).open(block2, id, false);
                                        if (outerDisplayDoor) {
                                            new OuterDisplayDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getDisplay(), id);
                                        } else if (tardis.getPreset().hasDoor()) {
                                            new OuterMinecraftDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getMinecraft(), id, player);
                                        }
                                    }
                                }
                            }
                        } else if (player.isSneaking() && tdi.isLight() && this.isPlaceable(toPlace = inHand.getType()) && (block = interaction.getLocation().getBlock().getRelative(BlockFace.UP)).getType().isAir()) {
                            block.setType(toPlace);
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                BlockData data = block.getBlockData();
                                if (data instanceof Directional) {
                                    Directional directional = (Directional)data;
                                    directional.setFacing(data instanceof Stairs ? player.getFacing() : player.getFacing().getOppositeFace());
                                    block.setBlockData(data);
                                }
                                if (data instanceof Rotatable) {
                                    Rotatable rotatable = (Rotatable)data;
                                    rotatable.setRotation(player.getFacing().getOppositeFace());
                                    block.setBlockData(data);
                                }
                            }, 1L);
                            if (player.getGameMode() == GameMode.SURVIVAL) {
                                int amount = inHand.getAmount() - 1;
                                if (amount > 0) {
                                    player.getInventory().getItemInMainHand().setAmount(amount);
                                } else {
                                    player.getInventory().setItemInMainHand(null);
                                }
                                player.updateInventory();
                            }
                        }
                    } else if (this.plugin.getTrackerKeeper().getUpdatePlayers().containsKey(player.getUniqueId())) {
                        ItemStack is = display.getItemStack();
                        if (!is.hasItemMeta()) {
                            return;
                        }
                        ItemMeta im = is.getItemMeta();
                        if (!im.hasItemModel()) {
                            return;
                        }
                        String model = im.getItemModel().getKey();
                        String[] split = model.split("_");
                        String last = split[split.length - 1];
                        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, model.replace(last, "closed"));
                        im.setItemModel(key);
                        is.setItemMeta(im);
                        display.setItemStack(is);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_DOUBLE_DOOR");
                        this.plugin.getTrackerKeeper().getUpdatePlayers().remove(player.getUniqueId());
                    }
                }
            }
        }
    }

    private boolean isCustomClosed(ItemDisplay display) {
        if (display == null) {
            return false;
        }
        ItemStack is = display.getItemStack();
        if (is == null) {
            return false;
        }
        ItemMeta im = is.getItemMeta();
        String cmd = im.hasItemModel() ? im.getItemModel().getKey() : "null";
        return cmd.endsWith("_open");
    }

    private boolean isPlaceable(Material material) {
        return material.isSolid() && !Tag.DOORS.isTagged((Keyed)material) && !material.hasGravity() && !Tag.PRESSURE_PLATES.isTagged((Keyed)material);
    }

    private boolean isRedstoneSonic(ItemStack is) {
        ItemMeta im;
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Sonic Screwdriver")) {
            List lore = im.lore();
            return lore != null && lore.contains(Component.text((String)"Redstone Upgrade"));
        }
        return false;
    }

    private void processInteraction(ItemDisplay fake, ItemDisplay breaking, Player player, Location l, Block block, Interaction interaction) {
        if (fake != null && player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            fake.remove();
            if (interaction != null) {
                interaction.remove();
            }
            block.setType(Material.AIR);
            TARDISDisplayItem tdi = TARDISDisplayItemUtils.get(fake);
            if (tdi != null) {
                if (tdi.isLight()) {
                    new TARDISSonicLight(this.plugin).removeLamp(block, player);
                }
                if (tdi.isVariable()) {
                    TARDISDisplayItemUtils.remove(l.getBlock());
                }
            }
            return;
        }
        if (breaking != null && fake != null) {
            ItemStack is = breaking.getItemStack();
            if (is != null) {
                int destroy = (Integer)is.getItemMeta().getPersistentDataContainer().get(this.plugin.getDestroyKey(), PersistentDataType.INTEGER);
                if (destroy == 9) {
                    TARDISDisplayItem tdi = TARDISDisplayItemUtils.get(fake);
                    if (player.getGameMode().equals((Object)GameMode.SURVIVAL) && fake.getItemStack() != null) {
                        if (tdi != null && tdi.isVariable()) {
                            for (Entity e : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.55, 0.55, 0.55, d -> d.getType() == EntityType.ITEM_DISPLAY)) {
                                ItemDisplay vd;
                                ItemStack vis;
                                if (e == fake || e == breaking || (vis = (vd = (ItemDisplay)e).getItemStack()) == null) continue;
                                Material variable = vis.getType();
                                ItemStack ret = ItemStack.of((Material)Material.GLASS, (int)1);
                                ItemMeta im = ret.getItemMeta();
                                im.displayName((Component)ComponentUtils.toWhite("Variable Light"));
                                im.lore(List.of(Component.text((String)variable.toString())));
                                im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)1003);
                                ret.setItemMeta(im);
                                l.getWorld().dropItemNaturally(l, ret);
                            }
                        } else {
                            l.getWorld().dropItemNaturally(l, fake.getItemStack());
                        }
                    }
                    breaking.remove();
                    fake.remove();
                    if (interaction != null) {
                        interaction.remove();
                    }
                    block.setType(Material.AIR);
                    if (tdi != null) {
                        if (tdi.isLight()) {
                            new TARDISSonicLight(this.plugin).removeLamp(block, player);
                        }
                        if (tdi.isVariable()) {
                            TARDISDisplayItemUtils.remove(l.getBlock());
                        }
                    }
                    if (this.plugin.getArtronConfig().getBoolean("artron_furnace.tardis_powered")) {
                        ArtronFurnaceUtils.removeFromCapacitor(block, player, this.plugin);
                    }
                } else {
                    ItemMeta im = is.getItemMeta();
                    NamespacedKey model = new NamespacedKey((Plugin)this.plugin, "destroy_" + (destroy + 1));
                    im.getPersistentDataContainer().set(this.plugin.getDestroyKey(), PersistentDataType.INTEGER, (Object)(destroy + 1));
                    im.setItemModel(model);
                    is.setItemMeta(im);
                    breaking.setItemStack(is);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((ItemDisplay)breaking).remove(), 60L);
                }
            }
        } else if (breaking == null) {
            ItemStack destroy = ItemStack.of((Material)Material.GRAVEL);
            ItemMeta dim = destroy.getItemMeta();
            dim.getPersistentDataContainer().set(this.plugin.getDestroyKey(), PersistentDataType.INTEGER, (Object)0);
            dim.setItemModel(BlockBreak.DESTROY_0.getKey());
            destroy.setItemMeta(dim);
            Vector v = interaction != null ? new Vector(0.0, 0.5, 0.0) : new Vector(0.5, 0.5, 0.5);
            ItemDisplay display = (ItemDisplay)l.getWorld().spawnEntity(l.clone().add(v), EntityType.ITEM_DISPLAY);
            display.setItemStack(destroy);
            display.setPersistent(true);
            display.setInvulnerable(true);
        }
    }

    @EventHandler
    public void onDoorInteract(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Interaction interaction;
            Player player = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Interaction && (interaction = (Interaction)entity).getPersistentDataContainer().has(this.plugin.getTardisIdKey(), PersistentDataType.INTEGER)) {
                int id = (Integer)interaction.getPersistentDataContainer().get(this.plugin.getTardisIdKey(), PersistentDataType.INTEGER);
                if (this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LOST_IN_VORTEX");
                    return;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                where.put("door_type", !this.plugin.getUtils().inTARDISWorld(player) ? 0 : 1);
                ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
                if (rsd.resultSet()) {
                    event.setCancelled(true);
                    ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                    String key = rsp.resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key");
                    Material m = Material.getMaterial((String)key);
                    new DoorLockAction(this.plugin).lockUnlock(player, m, id, rsd.isLocked(), !this.plugin.getConfig().getBoolean("preferences.open_door_policy"));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onDisplayBlockPlace$0(Location location, BlockData data) {
        location.getBlock().setBlockData(data);
    }
}

