/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyTypeTable;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;

public class TARDISRoomMap {
    private final TARDIS plugin;

    public TARDISRoomMap(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false).forEach(r -> {
            boolean success;
            if (this.plugin.getRoomsConfig().getBoolean("rooms." + r + ".enabled") && !(success = this.makeRoomMap(r.toLowerCase(Locale.ROOT), (String)r, this.plugin.getRoomsConfig().getBoolean("rooms." + r + ".user")))) {
                this.plugin.getRoomsConfig().set("rooms." + r + ".enabled", (Object)false);
                try {
                    this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean makeRoomMap(String fileName, String s, boolean user) {
        HashMap<String, Integer> blockTypes = new HashMap<String, Integer>();
        JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "rooms", fileName, user);
        if (obj == null) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "The supplied file [" + fileName + ".tschm] is not a TARDIS JSON schematic!");
            return false;
        }
        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
        int h = dimensions.get("height").getAsInt();
        int w = dimensions.get("width").getAsInt();
        int l = dimensions.get("length").getAsInt();
        JsonArray arr = obj.get("input").getAsJsonArray();
        for (int level = 0; level < h; ++level) {
            JsonArray floor = arr.get(level).getAsJsonArray();
            for (int row = 0; row < w; ++row) {
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col < l; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    if (!c.get("data").getAsString().contains("minecraft")) {
                        this.plugin.getMessenger().sendWithColour((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "The supplied file [" + fileName + ".tschm] needs updating to a TARDIS v4 schematic and was disabled!", "#FF5555");
                        this.plugin.getRoomsConfig().set("rooms." + s + ".enabled", (Object)false);
                        try {
                            this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return false;
                    }
                    String bid = this.getMaterialAsString(c.get("data").getAsString(), fileName);
                    if (this.plugin.getBuildKeeper().getIgnoreBlocks().contains(bid)) continue;
                    if (blockTypes.containsKey(bid)) {
                        Integer count = (Integer)blockTypes.get(bid) + 1;
                        blockTypes.put(bid, count);
                        continue;
                    }
                    blockTypes.put(bid, 1);
                }
                this.plugin.getBuildKeeper().getRoomBlockCounts().put(s, blockTypes);
            }
        }
        return true;
    }

    private String getMaterialAsString(String data, String fileName) {
        String bid;
        block4: {
            bid = "STONE";
            try {
                BlockData block = this.plugin.getServer().createBlockData(data);
                bid = block.getMaterial().toString();
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SEVERE, "The supplied file [" + fileName + ".tschm] contains invalid block data!");
                this.plugin.getMessenger().sendWithColours((CommandSender)this.plugin.getConsole(), TardisModule.SEVERE, "The invalid data was: ", "#FFFFFF", data, "#00AAAA");
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SEVERE, "Please remake the room schematic!");
                if (data.contains("cauldron[level")) {
                    bid = "WATER_CAULDRON";
                }
                Pattern regex = Pattern.compile(":([a-z_])+");
                Matcher matcher = regex.matcher(data);
                if (!matcher.matches()) break block4;
                String mat = matcher.group(0).toUpperCase(Locale.ROOT);
                bid = LegacyTypeTable.LOOKUP.getOrDefault(mat, "STONE");
            }
        }
        if (this.plugin.getBuildKeeper().getBlockConversion().containsKey(bid)) {
            bid = this.plugin.getBuildKeeper().getBlockConversion().get(bid);
        }
        return bid;
    }
}

