/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

class TARDISFlightAdjustment {
    private final TARDIS plugin;
    private final List<Integer> angles;

    TARDISFlightAdjustment(TARDIS plugin) {
        this.plugin = plugin;
        this.angles = new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(45), Integer.valueOf(90), Integer.valueOf(135), Integer.valueOf(180), Integer.valueOf(225), Integer.valueOf(270), Integer.valueOf(315)));
    }

    public Location getLocation(BuildData bd, int r) {
        TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
        Location adjusted_location = bd.getLocation().clone();
        Collections.shuffle(this.angles);
        for (Integer a : this.angles) {
            Location final_location;
            boolean safe;
            int wx = (int)(adjusted_location.getX() + (double)r * Math.cos(a.intValue()));
            int wz = (int)(adjusted_location.getZ() + (double)r * Math.sin(a.intValue()));
            adjusted_location.setX((double)wx);
            adjusted_location.setZ((double)wz);
            boolean bool = true;
            int y = adjusted_location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? this.plugin.getUtils().getHighestNetherBlock(adjusted_location.getWorld(), wx, wz) : adjusted_location.getWorld().getHighestBlockAt(adjusted_location).getY();
            adjusted_location.setY((double)y);
            if (adjusted_location.getBlock().getRelative(BlockFace.DOWN).isLiquid() && !this.plugin.getConfig().getBoolean("travel.land_on_water") && !bd.isSubmarine()) {
                bool = false;
            }
            if (!bool) continue;
            Location sub = null;
            if (bd.isSubmarine()) {
                sub = tt.submarine(adjusted_location.getBlock(), bd.getDirection().forPreset());
                safe = sub != null;
            } else {
                int[] start = TARDISTimeTravel.getStartLocation(adjusted_location, bd.getDirection());
                boolean bl = safe = TARDISTimeTravel.safeLocation(start[0], y, start[2], start[1], start[3], adjusted_location.getWorld(), bd.getDirection()) < 1;
            }
            if (!safe) continue;
            Location location = final_location = bd.isSubmarine() ? sub : adjusted_location;
            if (!this.plugin.getPluginRespect().getRespect(final_location, new Parameters(bd.getPlayer().getPlayer(), Flag.getNoMessageFlags()))) continue;
            return final_location;
        }
        return bd.getLocation();
    }
}

