/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise.npc;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.KeepAlive;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.lazarus.disguise.npc.NPCConnection;
import me.eccentric_nz.TARDIS.lazarus.disguise.npc.NPCPacketListener;
import me.eccentric_nz.TARDIS.lazarus.disguise.npc.NPCPlayer;
import me.eccentric_nz.TARDIS.skins.ProfileChanger;
import me.eccentric_nz.TARDIS.skins.SkinFetcher;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class EmergencyProgramOneSpawner {
    private final org.bukkit.entity.Player player;
    private final Location location;
    private NPCPlayer npc = null;

    public EmergencyProgramOneSpawner(org.bukkit.entity.Player player, Location location) {
        this.player = player;
        this.location = location;
    }

    public void create() {
        SkinFetcher getter = new SkinFetcher(TARDIS.plugin, this.player.getUniqueId());
        getter.fetchAsync((hasResult, fetched) -> {
            JsonObject properties;
            if (hasResult && (properties = fetched.getSkin()) != null) {
                GameProfile gameProfile = new GameProfile(UUID.randomUUID(), this.player.getName());
                String value = properties.get("value").getAsString();
                String signature = properties.get("signature").getAsString();
                gameProfile.getProperties().removeAll((Object)"textures");
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", value, signature));
                DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
                ServerLevel world = ((CraftWorld)this.location.getWorld()).getHandle();
                ClientInformation info = ClientInformation.createDefault();
                this.npc = new NPCPlayer((MinecraftServer)server, world, gameProfile, ClientInformation.createDefault(), this.location);
                this.npc.connection = new NPCPacketListener((MinecraftServer)server, new NPCConnection(PacketFlow.CLIENTBOUND), this.npc, new CommonListenerCookie(gameProfile, 0, info, false, null, new HashSet(), new KeepAlive()));
                world.addNewPlayer((ServerPlayer)this.npc);
                SynchedEntityData dataWatcher = this.npc.getEntityData();
                dataWatcher.set(Player.DATA_HEALTH_ID, (Object)Float.valueOf(20.0f));
                dataWatcher.set(new EntityDataAccessor(17, EntityDataSerializers.BYTE), (Object)-1);
                ProfileChanger.setPlayerProfile(this.npc.getBukkitEntity(), gameProfile);
                net.minecraft.world.item.ItemStack feet = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getBoots());
                net.minecraft.world.item.ItemStack legs = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getLeggings());
                net.minecraft.world.item.ItemStack chest = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getChestplate());
                net.minecraft.world.item.ItemStack head = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getHelmet());
                net.minecraft.world.item.ItemStack mainHand = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getItemInMainHand());
                net.minecraft.world.item.ItemStack offHand = CraftItemStack.asNMSCopy((ItemStack)this.player.getInventory().getItemInOffHand());
                this.npc.setItemSlot(EquipmentSlot.FEET, feet);
                this.npc.setItemSlot(EquipmentSlot.LEGS, legs);
                this.npc.setItemSlot(EquipmentSlot.CHEST, chest);
                this.npc.setItemSlot(EquipmentSlot.HEAD, head);
                this.npc.setItemSlot(EquipmentSlot.MAINHAND, mainHand);
                this.npc.setItemSlot(EquipmentSlot.OFFHAND, offHand);
                this.npc.setInvulnerable(true);
                this.showAll(this.npc, this.npc.getBukkitEntity().getLocation());
            }
        });
    }

    public void showAll(ServerPlayer npc, Location location) {
        ServerEntity serverEntity = new ServerEntity(npc.level(), (Entity)npc, 0, false, packet -> {}, (packet, list) -> {}, Set.of());
        List<Pair> equipment = List.of(new Pair((Object)EquipmentSlot.MAINHAND, (Object)npc.getItemBySlot(EquipmentSlot.MAINHAND)), new Pair((Object)EquipmentSlot.OFFHAND, (Object)npc.getItemBySlot(EquipmentSlot.OFFHAND)), new Pair((Object)EquipmentSlot.HEAD, (Object)npc.getItemBySlot(EquipmentSlot.HEAD)), new Pair((Object)EquipmentSlot.CHEST, (Object)npc.getItemBySlot(EquipmentSlot.CHEST)), new Pair((Object)EquipmentSlot.LEGS, (Object)npc.getItemBySlot(EquipmentSlot.LEGS)), new Pair((Object)EquipmentSlot.FEET, (Object)npc.getItemBySlot(EquipmentSlot.FEET)));
        ClientboundSetEquipmentPacket equipmentPacket = new ClientboundSetEquipmentPacket(npc.getId(), equipment);
        ClientboundPlayerInfoUpdatePacket playerInfoAdd = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, npc);
        ClientboundAddEntityPacket namedEntitySpawn = new ClientboundAddEntityPacket((Entity)npc, serverEntity);
        ClientboundRotateHeadPacket headRotation = new ClientboundRotateHeadPacket((Entity)npc, (byte)(location.getYaw() * 256.0f / 360.0f));
        ClientboundPlayerInfoRemovePacket playerInfoRemove = new ClientboundPlayerInfoRemovePacket(List.of(npc.getUUID()));
        ClientboundSetEntityDataPacket dataPacket = null;
        List metas = npc.getEntityData().getNonDefaultValues();
        if (metas != null && !metas.isEmpty()) {
            dataPacket = new ClientboundSetEntityDataPacket(npc.getId(), metas);
        }
        for (org.bukkit.entity.Player player : Bukkit.getOnlinePlayers()) {
            if (player.getWorld() != npc.getBukkitEntity().getWorld()) continue;
            ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
            connection.send((Packet)playerInfoAdd);
            connection.send((Packet)namedEntitySpawn);
            connection.send((Packet)headRotation);
            connection.send((Packet)playerInfoRemove);
            connection.send((Packet)equipmentPacket);
            if (dataPacket == null) continue;
            connection.send((Packet)dataPacket);
        }
    }

    public NPCPlayer getNpc() {
        return this.npc;
    }
}

