/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.control.actions.LightSwitchAction;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISWallsInventory;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lights.TARDISLightChanger;
import me.eccentric_nz.TARDIS.lights.TARDISLightConverter;
import me.eccentric_nz.TARDIS.lights.TARDISLightEmittingInventory;
import me.eccentric_nz.TARDIS.lights.TARDISLightLevelsInventory;
import me.eccentric_nz.TARDIS.lights.TARDISLightSequence;
import me.eccentric_nz.TARDIS.lights.TARDISLightSequenceInventory;
import me.eccentric_nz.TARDIS.lights.TARDISLightsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISLightsGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISLightsGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightMenuClick(InventoryClickEvent event) {
        InventoryView view;
        ItemStack is;
        if (!(event.getInventory().getHolder(false) instanceof TARDISLightsInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot >= 0 && slot < 54 && (is = (view = event.getView()).getItem(slot)) != null) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                switch (slot) {
                    case 0: 
                    case 27: 
                    case 29: 
                    case 34: 
                    case 41: 
                    case 43: {
                        break;
                    }
                    case 28: {
                        player.openInventory(new TARDISWallsInventory(this.plugin, "Variable Light Blocks").getInventory());
                        break;
                    }
                    case 35: {
                        if (!this.plugin.getTrackerKeeper().getLightChangers().contains(player.getUniqueId())) {
                            ResultSetLightPrefs rslp = new ResultSetLightPrefs(this.plugin);
                            if (rslp.fromID(tardis.getTardisId())) {
                                TARDISLightChanger changer = new TARDISLightChanger(this.plugin, rslp.getLight(), tardis.getChunk(), tardis.isLightsOn(), this.getMaterialFromSlot(view, 29), player);
                                int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)changer, 2L, 100L);
                                changer.setTaskID(task);
                            }
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LIGHT_CHANGE");
                        }
                        this.close(player);
                        break;
                    }
                    case 42: {
                        player.openInventory(new TARDISLightEmittingInventory(this.plugin).getInventory());
                        break;
                    }
                    case 44: {
                        if (!this.plugin.getTrackerKeeper().getLightChangers().contains(player.getUniqueId())) {
                            ResultSetLightPrefs rslp = new ResultSetLightPrefs(this.plugin);
                            if (!rslp.fromID(tardis.getTardisId())) break;
                            Material variable = this.getMaterialFromSlot(view, 29);
                            Material emitting = this.getMaterialFromSlot(view, 43);
                            new TARDISLightConverter(this.plugin).apply(rslp.getLight(), emitting, player, variable);
                            break;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LIGHT_CHANGE");
                        break;
                    }
                    case 45: {
                        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(tardis.getTardisId())) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                            return;
                        }
                        if (!tardis.isLightsOn() && this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                            return;
                        }
                        this.close(player);
                        new LightSwitchAction(this.plugin, tardis.getTardisId(), tardis.isLightsOn(), player, tardis.getSchematic().getLights()).flickSwitch();
                        break;
                    }
                    case 47: {
                        player.openInventory(new TARDISLightLevelsInventory(this.plugin, tardis.getTardisId()).getInventory());
                        break;
                    }
                    case 49: {
                        if (!this.plugin.getTrackerKeeper().getLightChangers().contains(player.getUniqueId())) {
                            new TARDISLightSequence(this.plugin, tardis.getTardisId(), player.getUniqueId()).play();
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LIGHT_CHANGE");
                        }
                        this.close(player);
                        break;
                    }
                    case 51: {
                        player.openInventory(new TARDISLightSequenceInventory(this.plugin, tardis.getTardisId()).getInventory());
                        break;
                    }
                    case 53: {
                        this.close(player);
                        break;
                    }
                    default: {
                        ItemMeta im = is.getItemMeta();
                        String light = TARDISStringUtils.toUnderscoredUppercase(ComponentUtils.stripColour(im.displayName()));
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("light", light);
                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                        wheret.put("tardis_id", tardis.getTardisId());
                        this.plugin.getQueryFactory().doUpdate("light_prefs", set, wheret);
                        HashMap<String, Object> setpp = new HashMap<String, Object>();
                        setpp.put("lights", light);
                        HashMap<String, Object> wherepp = new HashMap<String, Object>();
                        wherepp.put("uuid", player.getUniqueId().toString());
                        this.plugin.getQueryFactory().doUpdate("player_prefs", setpp, wherepp);
                        for (int l = 1; l <= TardisLight.values().length + 2; ++l) {
                            ItemStack isl = view.getItem(l);
                            if (isl == null) continue;
                            ItemMeta iml = isl.getItemMeta();
                            if (!iml.displayName().equals((Object)im.displayName())) {
                                iml.lore(null);
                            } else {
                                iml.lore(List.of(Component.text((String)"Current light")));
                            }
                            isl.setItemMeta(iml);
                        }
                    }
                }
            }
        }
    }

    private Material getMaterialFromSlot(InventoryView view, int slot) {
        ItemStack is = view.getItem(slot);
        return is.getType();
    }
}

