/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.GallifeyStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SiluriaStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SkaroStructureUtility;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISSchematicTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"load", (Object)"paste", (Object)"save", (Object)"clear", (Object)"replace", (Object)"convert", (Object)"remove", (Object)"flowers", (Object)"fixliquid");
    private final List<String> LOAD_SUBS = ImmutableList.of((Object)"console", (Object)"room", (Object)"structure", (Object)"user");
    private final List<String> LIQUID_SUBS = ImmutableList.of((Object)"water", (Object)"lava");
    private final List<String> CONSOLE_SUBS = new ArrayList<String>(Consoles.getBY_PERMS().keySet());
    private final List<String> ROOM_SUBS = new ArrayList<String>();
    private final List<String> STRUCTURE_SUBS = new ArrayList<String>();
    private final List<String> FILE_SUBS = new ArrayList<String>();
    private final List<String> MAT_SUBS = new ArrayList<String>();
    private final List<String> LIGHT_SUBS = new ArrayList<String>();

    public TARDISSchematicTabComplete(File userDir) {
        if (userDir.exists()) {
            for (String f : userDir.list()) {
                if (!f.endsWith(".tschm")) continue;
                this.FILE_SUBS.add(f.substring(0, f.length() - 6));
            }
        }
        for (String r : TARDIS.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false)) {
            this.ROOM_SUBS.add(r.toLowerCase(Locale.ROOT));
        }
        for (String g : GallifeyStructureUtility.structures) {
            this.STRUCTURE_SUBS.add("gallifrey_" + g);
        }
        for (String s : SiluriaStructureUtility.structures) {
            this.STRUCTURE_SUBS.add("siluria_" + s);
        }
        for (String d : SkaroStructureUtility.structures) {
            this.STRUCTURE_SUBS.add("dalek_" + d);
        }
        for (Material m : Material.values()) {
            if (!m.isBlock()) continue;
            this.MAT_SUBS.add(m.toString());
        }
        for (TardisLight l : TardisLight.values()) {
            this.LIGHT_SUBS.add(l.toString());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("load")) {
            return this.partial(args[1], this.LOAD_SUBS);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("paste")) {
            return ImmutableList.of((Object)"no_air");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("replace")) {
            return this.partial(args[1], this.MAT_SUBS);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("convert")) {
            return this.partial(args[1], this.LIGHT_SUBS);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("liquid")) {
            return this.partial(args[1], this.LIQUID_SUBS);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("load")) {
            switch (args[1].toLowerCase(Locale.ROOT)) {
                case "console": {
                    return this.partial(args[2], this.CONSOLE_SUBS);
                }
                case "room": {
                    return this.partial(args[2], this.ROOM_SUBS);
                }
                case "structure": {
                    return this.partial(args[2], this.STRUCTURE_SUBS);
                }
            }
            return this.partial(args[2], this.FILE_SUBS);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("replace")) {
            return this.partial(args[2], this.MAT_SUBS);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("convert")) {
            return ImmutableList.of((Object)"SEA_LANTERN", (Object)"REDSTONE_LAMP");
        }
        return ImmutableList.of();
    }
}

