/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;

public class ProfileChanger {
    public static void setPlayerProfile(CraftPlayer cp, GameProfile profile) {
        CraftPlayer bukkitPlayer;
        ServerPlayer self = cp.getHandle();
        if (!self.sentListPacket) {
            ProfileChanger.setGameProfile(self, profile);
            return;
        }
        List players = MinecraftServer.getServer().getPlayerList().players;
        for (ServerPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee((org.bukkit.entity.Player)cp)) continue;
            ProfileChanger.untrackAndHideEntity(bukkitPlayer, self);
        }
        ProfileChanger.setGameProfile(self, profile);
        for (ServerPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee((org.bukkit.entity.Player)cp)) continue;
            ProfileChanger.trackAndShowEntity(bukkitPlayer, self, profile.getId());
        }
        ProfileChanger.refreshPlayer(self, cp.getLocation());
    }

    private static void setGameProfile(ServerPlayer player, GameProfile profile) {
        try {
            Field gpField = Player.class.getDeclaredField("gameProfile");
            gpField.setAccessible(true);
            gpField.set(player, profile);
            gpField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ignored) {
            TARDIS.plugin.debug("Failed to set GameProfile");
        }
    }

    private static void untrackAndHideEntity(CraftPlayer cp, ServerPlayer other) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((org.bukkit.entity.Player)cp, (Entity)other.getBukkitEntity()));
        ServerPlayer sp = cp.getHandle();
        ChunkMap tracker = sp.level().getChunkSource().chunkMap;
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId());
        if (entry != null) {
            entry.removePlayer(sp);
        }
        if (other.sentListPacket) {
            sp.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(other.getUUID())));
        }
    }

    private static void trackAndShowEntity(CraftPlayer cp, ServerPlayer other, UUID uuidOverride) {
        ChunkMap.TrackedEntity entry;
        ServerPlayer sp = cp.getHandle();
        ChunkMap tracker = sp.level().getChunkSource().chunkMap;
        UUID original = null;
        if (uuidOverride != null) {
            original = other.getUUID();
            other.setUUID(uuidOverride);
        }
        sp.connection.send((Packet)ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(other)));
        if (original != null) {
            other.setUUID(original);
        }
        if ((entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId())) != null && !entry.seenBy.contains(sp.connection)) {
            entry.updatePlayer(sp);
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerShowEntityEvent((org.bukkit.entity.Player)cp, (Entity)other.getBukkitEntity()));
    }

    private static void refreshPlayer(ServerPlayer sp, Location loc) {
        ServerLevel worldserver = sp.level();
        sp.connection.send((Packet)new ClientboundRespawnPacket(sp.createCommonSpawnInfo(worldserver), 3));
        sp.onUpdateAbilities();
        sp.connection.send((Packet)new ClientboundPlayerPositionPacket(0, new PositionMoveRotation(new Vec3(loc.getX(), loc.getY(), loc.getZ()), new Vec3(loc.getX(), loc.getY(), loc.getZ()), loc.getYaw(), loc.getPitch()), Collections.emptySet()));
        PlayerList playerList = sp.getServer().getPlayerList();
        playerList.sendPlayerPermissionLevel(sp);
        playerList.sendLevelInfo(sp, worldserver);
        playerList.sendAllPlayerInfo(sp);
        sp.connection.send((Packet)new ClientboundSetExperiencePacket(sp.experienceProgress, sp.totalExperience, sp.experienceLevel));
        for (MobEffectInstance mobEffect : sp.getActiveEffects()) {
            sp.connection.send((Packet)new ClientboundUpdateMobEffectPacket(sp.getId(), mobEffect, false));
        }
    }
}

