/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Features;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.skins.ProfileChanger;
import me.eccentric_nz.TARDIS.skins.Skin;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.profile.CraftPlayerProfile;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.profile.PlayerTextures;

public class SkinUtils {
    public static final HashMap<UUID, Skin> SKINNED = new HashMap();
    private static final UUID uuid = UUID.fromString("622bb234-0a3e-46d7-9e1d-ed1f03c76011");

    public static PlayerProfile getHeadProfile(Skin skin) {
        GameProfile profile = new GameProfile(uuid, "TARDIS_Skin");
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.value(), skin.signature()));
        CraftPlayerProfile playerProfile = new CraftPlayerProfile(profile);
        PlayerTextures textures = playerProfile.getTextures();
        try {
            textures.setSkin(URI.create(skin.url()).toURL(), PlayerTextures.SkinModel.CLASSIC);
        }
        catch (MalformedURLException e) {
            TARDIS.plugin.debug("Bad URL: " + skin.url());
        }
        return playerProfile;
    }

    public static boolean isAlexSkin(Player player) {
        ServerPlayer sp = ((CraftPlayer)player).getHandle();
        GameProfile profile = sp.getGameProfile();
        String base64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).value();
        String decodedValue = new String(Base64.getDecoder().decode(base64));
        JsonObject json = JsonParser.parseString((String)decodedValue).getAsJsonObject();
        JsonObject skinObject = json.getAsJsonObject("textures").getAsJsonObject("SKIN");
        if (!skinObject.has("metadata")) {
            return false;
        }
        if (!skinObject.getAsJsonObject("metadata").has("model")) {
            return false;
        }
        String model = skinObject.getAsJsonObject("metadata").get("model").getAsString();
        return model.equals("slim");
    }

    public static void setSkinModel(Player player, boolean slim) {
        ServerPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        GameProfile profile = entityPlayer.getGameProfile();
        String base64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).value();
        String decodedValue = new String(Base64.getDecoder().decode(base64));
        JsonObject json = JsonParser.parseString((String)decodedValue).getAsJsonObject();
        JsonObject textures = json.getAsJsonObject("textures");
        JsonObject skin = textures.get("SKIN").getAsJsonObject();
        if (slim) {
            JsonObject metadata = new JsonObject();
            metadata.addProperty("model", "slim");
            skin.add("metadata", (JsonElement)metadata);
        } else {
            skin.remove("metadata");
        }
        textures.add("SKIN", (JsonElement)skin);
        json.add("textures", (JsonElement)textures);
        String value = json.toString();
        TARDIS.plugin.debug(value);
        String encoded = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        String signature = textures.get("signature").getAsString();
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", encoded, signature));
        ProfileChanger.setPlayerProfile((CraftPlayer)player, profile);
    }

    public static void debug(Player player) {
        ServerPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        GameProfile profile = entityPlayer.getGameProfile();
        String base64 = ((Property)profile.getProperties().get((Object)"textures").iterator().next()).value();
        String decodedValue = new String(Base64.getDecoder().decode(base64));
        TARDIS.plugin.debug(decodedValue);
    }

    public static void setExtras(Player player, Skin skin) {
        NamespacedKey key;
        Material material = Material.LEATHER;
        switch (skin.name()) {
            case "Ace": {
                key = Features.ACE_PONYTAIL.getKey();
                break;
            }
            case "Angel of Liberty": {
                key = Features.ANGEL_OF_LIBERTY_CROWN.getKey();
                ItemStack torch = ItemStack.of((Material)Material.TORCH, (int)1);
                ItemMeta tim = torch.getItemMeta();
                tim.displayName((Component)Component.text((String)"Liberty Torch"));
                tim.setItemModel(Features.ANGEL_OF_LIBERTY_TORCH.getKey());
                torch.setItemMeta(tim);
                SkinUtils.setOrSwapItem(torch, player, EquipmentSlot.HAND);
                break;
            }
            case "Bannakaffalatta": {
                material = Material.NETHER_WART;
                key = Features.BANNAKAFFALATTA_SPIKES.getKey();
                break;
            }
            case "Brigadier Lethbridge-Stewart": {
                key = Features.BRIGADIER_LETHBRIDGE_STEWART_HAT.getKey();
                break;
            }
            case "Cyberman": {
                material = Material.IRON_INGOT;
                key = Features.CYBERMAN_FEATURES.getKey();
                ItemStack weapon = ItemStack.of((Material)material, (int)1);
                ItemMeta cwim = weapon.getItemMeta();
                cwim.displayName((Component)Component.text((String)"Cyber Weapon"));
                cwim.setItemModel(CybermanVariant.CYBER_WEAPON.getKey());
                weapon.setItemMeta(cwim);
                SkinUtils.setOrSwapItem(weapon, player, EquipmentSlot.HAND);
                break;
            }
            case "Wooden Cyberman": {
                material = Material.SPRUCE_BUTTON;
                key = Features.WOOD_CYBERMAN_FEATURES.getKey();
                ItemStack weapon = ItemStack.of((Material)material, (int)1);
                ItemMeta cwim = weapon.getItemMeta();
                cwim.displayName((Component)Component.text((String)"Wood Cyber Weapon"));
                cwim.setItemModel(CybermanVariant.WOOD_CYBER_WEAPON.getKey());
                weapon.setItemMeta(cwim);
                SkinUtils.setOrSwapItem(weapon, player, EquipmentSlot.HAND);
                break;
            }
            case "Black Cyberman": {
                material = Material.IRON_INGOT;
                key = Features.BLACK_CYBERMAN_FEATURES.getKey();
                break;
            }
            case "Invasion Cyberman": {
                material = Material.IRON_INGOT;
                key = Features.CYBERMAN_INVASION_FEATURES.getKey();
                ItemStack arm = ItemStack.of((Material)material, (int)1);
                ItemMeta cwim = arm.getItemMeta();
                cwim.displayName((Component)Component.text((String)"Cyber Arm"));
                cwim.setItemModel(CybermanVariant.CYBERMAN_INVASION_ARM.getKey());
                arm.setItemMeta(cwim);
                SkinUtils.setOrSwapItem(arm, player, EquipmentSlot.HAND);
                SkinUtils.setOrSwapItem(arm, player, EquipmentSlot.OFF_HAND);
                break;
            }
            case "Rise of the Cyberman": 
            case "Cyber Lord": 
            case "Moonbase Cyberman": {
                material = Material.IRON_INGOT;
                key = switch (skin.name()) {
                    case "Rise of the Cyberman" -> Features.CYBERMAN_RISE_FEATURES.getKey();
                    case "Moonbase Cyberman" -> Features.CYBERMAN_MOONBASE_FEATURES.getKey();
                    default -> Features.CYBER_LORD_FEATURES.getKey();
                };
                String arm = ItemStack.of((Material)material, (int)1);
                ItemMeta cwim = arm.getItemMeta();
                cwim.displayName((Component)Component.text((String)"Cyber Arm"));
                cwim.setItemModel(CybermanVariant.CYBERMAN_RISE_ARM.getKey());
                arm.setItemMeta(cwim);
                SkinUtils.setOrSwapItem((ItemStack)arm, player, EquipmentSlot.HAND);
                SkinUtils.setOrSwapItem((ItemStack)arm, player, EquipmentSlot.OFF_HAND);
                break;
            }
            case "Tenth Planet Cyberman": {
                material = Material.IRON_INGOT;
                key = Features.CYBERMAN_TENTH_PLANET_FEATURES.getKey();
                break;
            }
            case "Earthshock Cyberman": {
                material = Material.IRON_INGOT;
                key = Features.CYBERMAN_EARTHSHOCK_FEATURES.getKey();
                break;
            }
            case "Cybershade": {
                key = Features.CYBERSHADE_EARS.getKey();
                break;
            }
            case "Dalek Sec": {
                material = Material.MANGROVE_PROPAGULE;
                key = Features.DALEK_SEC_TENTACLES.getKey();
                break;
            }
            case "Empty Child": {
                material = Material.SUGAR;
                key = Features.EMPTY_CHILD_MASK.getKey();
                player.getAttribute(Attribute.SCALE).setBaseValue(0.5);
                break;
            }
            case "Hath": {
                material = Material.PUFFERFISH;
                key = Features.HATH_FEATURES.getKey();
                break;
            }
            case "Heavenly Host": {
                material = Material.GOLD_INGOT;
                key = Features.HEAVENLY_HOST_FEATURES.getKey();
                break;
            }
            case "Ice Warrior": {
                material = Material.SNOWBALL;
                key = Features.ICE_WARRIOR_CREST.getKey();
                break;
            }
            case "Impossible Astronaut": {
                material = Material.ORANGE_STAINED_GLASS_PANE;
                key = Features.IMPOSSIBLE_ASTRONAUT_PACK.getKey();
                break;
            }
            case "Jenny Flint": {
                key = null;
                ItemStack katana = ItemStack.of((Material)material, (int)1);
                ItemMeta kim = katana.getItemMeta();
                kim.displayName((Component)Component.text((String)"Katana"));
                kim.setItemModel(Features.JENNY_FLINT_KATANA.getKey());
                katana.setItemMeta(kim);
                SkinUtils.setOrSwapItem(katana, player, EquipmentSlot.OFF_HAND);
                break;
            }
            case "Jo Grant": {
                key = Features.JO_GRANT_HAIR.getKey();
                break;
            }
            case "Judoon": {
                material = Material.YELLOW_DYE;
                key = Features.JUDOON_SNOUT.getKey();
                break;
            }
            case "Martha Jones": {
                key = Features.MARTHA_JONES_HAIR.getKey();
                break;
            }
            case "Melanie Bush": {
                key = Features.MELANIE_BUSH_HAIR.getKey();
                ItemStack leftArm = ItemStack.of((Material)material, (int)1);
                ItemMeta laim = leftArm.getItemMeta();
                laim.displayName((Component)Component.text((String)skin.name()));
                laim.setItemModel(Features.MELANIE_BUSH_ARM_LEFT.getKey());
                leftArm.setItemMeta(laim);
                ItemStack rightArm = ItemStack.of((Material)material, (int)1);
                ItemMeta raim = rightArm.getItemMeta();
                raim.displayName((Component)Component.text((String)skin.name()));
                raim.setItemModel(Features.MELANIE_BUSH_ARM_RIGHT.getKey());
                rightArm.setItemMeta(raim);
                SkinUtils.setOrSwapItem(leftArm, player, EquipmentSlot.OFF_HAND);
                SkinUtils.setOrSwapItem(rightArm, player, EquipmentSlot.HAND);
                break;
            }
            case "Mire": {
                material = Material.NETHERITE_SCRAP;
                key = Features.MIRE_HELMET.getKey();
                ItemStack leftArm = ItemStack.of((Material)material, (int)1);
                ItemMeta laim = leftArm.getItemMeta();
                laim.displayName((Component)Component.text((String)skin.name()));
                laim.setItemModel(MireVariant.MIRE_LEFT_ARM.getKey());
                leftArm.setItemMeta(laim);
                ItemStack rightArm = ItemStack.of((Material)material, (int)1);
                ItemMeta raim = rightArm.getItemMeta();
                raim.displayName((Component)Component.text((String)skin.name()));
                raim.setItemModel(MireVariant.MIRE_RIGHT_ARM.getKey());
                rightArm.setItemMeta(raim);
                SkinUtils.setOrSwapItem(leftArm, player, EquipmentSlot.OFF_HAND);
                SkinUtils.setOrSwapItem(rightArm, player, EquipmentSlot.HAND);
                break;
            }
            case "Nimon": {
                material = Material.GOAT_HORN;
                key = Features.NIMON_HORNS.getKey();
                break;
            }
            case "Omega": {
                key = Features.OMEGA_FRILL.getKey();
                break;
            }
            case "Ood": {
                material = Material.ROTTEN_FLESH;
                key = Features.OOD_FEATURES.getKey();
                break;
            }
            case "Racnoss": {
                key = Features.RACNOSS_FEATURES.getKey();
                break;
            }
            case "Saturnynian": {
                material = Material.COD;
                key = Features.SATURNYNIAN_ARMS.getKey();
                break;
            }
            case "Scarecrow": {
                material = Material.WHEAT;
                key = Features.SCARECROW_EARS.getKey();
                break;
            }
            case "Sea Devil": {
                material = Material.KELP;
                key = Features.SEA_DEVIL_EARS.getKey();
                break;
            }
            case "Silence": {
                material = Material.END_STONE;
                key = Features.SILENCE_SIDE_HEAD.getKey();
                break;
            }
            case "Silurian": {
                material = Material.FEATHER;
                key = Features.SILURIAN_CREST.getKey();
                break;
            }
            case "Slitheen": {
                material = Material.TURTLE_EGG;
                key = Features.SLITHEEN_HEAD.getKey();
                ItemStack leftClaw = ItemStack.of((Material)material, (int)1);
                ItemMeta lhim = leftClaw.getItemMeta();
                lhim.displayName((Component)Component.text((String)skin.name()));
                lhim.setItemModel(SlitheenVariant.SLITHEEN_CLAW_LEFT.getKey());
                leftClaw.setItemMeta(lhim);
                ItemStack rightClaw = ItemStack.of((Material)material, (int)1);
                ItemMeta rhim = rightClaw.getItemMeta();
                rhim.displayName((Component)Component.text((String)skin.name()));
                rhim.setItemModel(SlitheenVariant.SLITHEEN_CLAW_RIGHT.getKey());
                rightClaw.setItemMeta(rhim);
                SkinUtils.setOrSwapItem(leftClaw, player, EquipmentSlot.OFF_HAND);
                SkinUtils.setOrSwapItem(rightClaw, player, EquipmentSlot.HAND);
                break;
            }
            case "Sontaran": {
                material = Material.POTATO;
                key = Features.SONTARAN_EARS.getKey();
                break;
            }
            case "Strax": {
                material = Material.POTATO;
                key = Features.STRAX_EARS.getKey();
                break;
            }
            case "Sutekh": {
                key = Features.SUTEKH_FEATURES.getKey();
                break;
            }
            case "Sycorax": {
                key = Features.SYCORAX_CAPE.getKey();
                break;
            }
            case "Roman Rory": {
                key = Features.ROMAN_RORY_CAPE.getKey();
                break;
            }
            case "Tegan": {
                key = Features.TEGAN_HAT.getKey();
                break;
            }
            case "The Beast": {
                key = Features.THE_BEAST_HORNS.getKey();
                break;
            }
            case "Vampire of Venice": {
                material = Material.COD;
                key = Features.VAMPIRE_OF_VENICE_FAN.getKey();
                break;
            }
            case "Weeping Angel": {
                material = Material.BRICK;
                key = Features.WEEPING_ANGEL_WINGS.getKey();
                break;
            }
            case "Zygon": {
                material = Material.PAINTING;
                key = Features.ZYGON_CREST.getKey();
                break;
            }
            default: {
                return;
            }
        }
        if (!skin.name().equals("Jenny Flint")) {
            ItemStack head = ItemStack.of((Material)material, (int)1);
            ItemMeta im = head.getItemMeta();
            im.displayName((Component)Component.text((String)skin.name()));
            if (key != null) {
                im.setItemModel(key);
            }
            im.getPersistentDataContainer().set(TARDIS.plugin.getTimeLordUuidKey(), PersistentDataType.BOOLEAN, (Object)true);
            head.setItemMeta(im);
            SkinUtils.setOrSwapItem(head, player, EquipmentSlot.HEAD);
        }
    }

    public static void setOrSwapItem(ItemStack item, Player player, EquipmentSlot slot) {
        HashMap remainder;
        PlayerInventory inventory = player.getInventory();
        ItemStack current = inventory.getItem(slot);
        if (!current.getType().isAir() && !(remainder = inventory.addItem(new ItemStack[]{current})).isEmpty()) {
            player.getWorld().dropItem(player.getLocation(), current);
        }
        inventory.setItem(slot, item);
        player.updateInventory();
    }

    public static String serializeSkin(Skin skin) {
        Gson gson = new Gson();
        return gson.toJson((Object)skin);
    }

    public static Skin deserializeSkin(String json) {
        Gson gson = new Gson();
        return (Skin)gson.fromJson(json, Skin.class);
    }

    public static void removeExtras(Player player, Skin skin) {
        switch (skin.name()) {
            case "Angel of Liberty": 
            case "Cyberman": 
            case "Wooden Cyberman": {
                player.getInventory().setItem(EquipmentSlot.HEAD, null);
                player.getInventory().setItem(EquipmentSlot.HAND, null);
                break;
            }
            case "Jenny Flint": {
                player.getInventory().setItem(EquipmentSlot.OFF_HAND, null);
                break;
            }
            case "Empty Child": {
                player.getInventory().setItem(EquipmentSlot.HEAD, null);
                player.getAttribute(Attribute.SCALE).setBaseValue(1.0);
                break;
            }
            case "Mire": 
            case "Slitheen": 
            case "Rise of the Cyberman": 
            case "Cyber Lord": 
            case "Moonbase Cyberman": 
            case "Invasion Cyberman": 
            case "Melanie Bush": {
                player.getInventory().setItem(EquipmentSlot.HEAD, null);
                player.getInventory().setItem(EquipmentSlot.HAND, null);
                player.getInventory().setItem(EquipmentSlot.OFF_HAND, null);
                break;
            }
            case "Ace": 
            case "Bannakaffalatta": 
            case "Brigadier Lethbridge-Stewart": 
            case "Black Cyberman": 
            case "Tenth Planet Cyberman": 
            case "Earthshock Cyberman": 
            case "Cybershade": 
            case "Dalek Sec": 
            case "Hath": 
            case "Ice Warrior": 
            case "Impossible Astronaut": 
            case "Jo Grant": 
            case "Judoon": 
            case "Martha Jones": 
            case "Omega": 
            case "Ood": 
            case "Racnoss": 
            case "Scarecrow": 
            case "Saturnynian": 
            case "Sea Devil": 
            case "Silence": 
            case "Silurian": 
            case "Sontaran": 
            case "Strax": 
            case "Sutekh": 
            case "Sycorax": 
            case "Tegan": 
            case "The Beast": 
            case "Vampire of Venice": 
            case "Weeping Angel": 
            case "Zygon": 
            case "Nimon": 
            case "Roamn Rory": 
            case "Heavenly Host": {
                player.getInventory().setItem(EquipmentSlot.HEAD, null);
                break;
            }
        }
    }
}

