/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeUtilities;
import me.eccentric_nz.tardischunkgenerator.custombiome.TerraBiomeLocator;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.terraform.coregen.bukkit.TerraformGenerator;

public class TARDISBiomeFinder {
    private final TARDIS plugin;

    public TARDISBiomeFinder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void run(World w, String search, Player player, int id, COMPASS direction, Location current) {
        Location tb;
        this.plugin.getMessenger().sendStatus(player, "BIOME_SEARCH");
        if (TARDIS.plugin.getServer().getPluginManager().isPluginEnabled("TerraformGenerator") && w.getGenerator() instanceof TerraformGenerator) {
            tb = new TerraBiomeLocator(w, current, search).execute();
        } else {
            try {
                Biome biome = (Biome)RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME).get(new NamespacedKey("minecraft", search.toLowerCase(Locale.ROOT)));
                if (biome == null || biome.equals((Object)Biome.THE_VOID)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_TRAVEL_NOT_VALID");
                    return;
                }
                tb = BiomeUtilities.searchBiome(w, biome, current);
            }
            catch (IllegalArgumentException iae) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_VALID");
                return;
            }
        }
        if (tb == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_FOUND");
            return;
        }
        if (!this.plugin.getPluginRespect().getRespect(tb, new Parameters(player, Flag.getDefaultFlags()))) {
            if (this.plugin.getConfig().getBoolean("travel.no_destination_malfunctions")) {
                this.plugin.getTrackerKeeper().getMalfunction().put(id, true);
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PROTECTED");
                return;
            }
        }
        World bw = tb.getWorld();
        while (!bw.getChunkAt(tb).isLoaded()) {
            bw.getChunkAt(tb).load();
        }
        int highest = tb.getWorld().getHighestBlockYAt(tb);
        if (tb.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            highest = TARDISStaticLocationGetters.getNetherHighest(tb);
        }
        tb.setY((double)(highest + 1));
        int[] start_loc = TARDISTimeTravel.getStartLocation(tb, direction);
        int tmp_y = tb.getBlockY();
        for (int up = 0; up < 10; ++up) {
            int count = TARDISTimeTravel.safeLocation(start_loc[0], tmp_y + up, start_loc[2], start_loc[1], start_loc[3], tb.getWorld(), direction);
            if (count != 0) continue;
            tb.setY((double)(tmp_y + up));
            break;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", tb.getWorld().getName());
        set.put("x", tb.getBlockX());
        set.put("y", tb.getBlockY());
        set.put("z", tb.getBlockZ());
        set.put("direction", direction.toString());
        set.put("submarine", 0);
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
        this.plugin.getMessenger().send(player, "BIOME_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.BIOME));
        this.plugin.getTrackerKeeper().getRescue().remove(id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            new TARDISLand(this.plugin, id, player).exitVortex();
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.BIOME, id));
        }
    }
}

