/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.upgrades;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.SystemUpgrade;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSystemUpgrades;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeUpdate;
import me.eccentric_nz.TARDIS.upgrades.TARDISSystemTreeGUI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISSystemTreeListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISSystemTreeListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSystemInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISSystemTreeGUI)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        if (is.getType() != Material.LIME_GLAZED_TERRACOTTA && slot != 45) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String uuid = player.getUniqueId().toString();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (!rst.resultSet()) {
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        wheret.put("uuid", uuid);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_OWNER");
            this.close(player);
            return;
        }
        ResultSetSystemUpgrades rsp = new ResultSetSystemUpgrades(this.plugin, id, uuid);
        if (!rsp.resultset()) {
            this.close(player);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_TRAVEL_FIRST");
            return;
        }
        if (slot == 45) {
            this.close(player);
            return;
        }
        SystemUpgrade current = rsp.getData();
        SystemTree clicked = switch (slot) {
            case 9 -> SystemTree.ARCHITECTURE;
            case 11 -> SystemTree.FEATURE;
            case 15 -> SystemTree.NAVIGATION;
            case 17 -> SystemTree.THROTTLE;
            case 18 -> SystemTree.CHAMELEON_CIRCUIT;
            case 20 -> SystemTree.SAVES;
            case 22 -> SystemTree.TOOLS;
            case 24 -> SystemTree.DISTANCE_1;
            case 26 -> SystemTree.FASTER;
            case 27 -> SystemTree.ROOM_GROWING;
            case 29 -> SystemTree.MONITOR;
            case 31 -> SystemTree.TARDIS_LOCATOR;
            case 33 -> SystemTree.DISTANCE_2;
            case 35 -> SystemTree.RAPID;
            case 36 -> SystemTree.DESKTOP_THEME;
            case 38 -> SystemTree.FORCE_FIELD;
            case 40 -> SystemTree.TELEPATHIC_CIRCUIT;
            case 42 -> SystemTree.DISTANCE_3;
            case 44 -> SystemTree.WARP;
            case 49 -> SystemTree.STATTENHEIM_REMOTE;
            case 51 -> SystemTree.INTER_DIMENSIONAL_TRAVEL;
            case 53 -> SystemTree.EXTERIOR_FLIGHT;
            default -> SystemTree.UPGRADE_TREE;
        };
        try {
            SystemTree required = SystemTree.valueOf(clicked.getRequired());
            if (!current.getUpgrades().get((Object)required).booleanValue()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_REQUIRED", required.getName());
                player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 1.0f, 1.0f);
            } else {
                if (current.getUpgrades().get((Object)clicked).booleanValue()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_HAS", clicked.getName());
                    player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_STEP, 1.0f, 1.0f);
                    return;
                }
                int cost = clicked.getBranch().equals("branch") ? this.plugin.getSystemUpgradesConfig().getInt("branch") : this.plugin.getSystemUpgradesConfig().getInt(clicked.getBranch() + "." + clicked.toString().toLowerCase(Locale.ROOT));
                if (cost > current.getArtronLevel()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_COST", clicked.getName());
                    player.playSound(player.getLocation(), Sound.ENTITY_CAT_EAT, 1.0f, 1.0f);
                    return;
                }
                HashMap<String, Object> wheretl = new HashMap<String, Object>();
                wheretl.put("uuid", uuid);
                this.plugin.getQueryFactory().alterEnergyLevel("player_prefs", -cost, wheretl, player);
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_SUCCESS", clicked.getName());
                new SystemUpgradeUpdate(this.plugin).set(uuid, id, clicked);
                ItemMeta im = is.getItemMeta();
                im.setItemModel(clicked.getUnlocked());
                List lore = im.lore();
                lore.set(lore.size() - 1, Component.text((String)"Unlocked", (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC));
                im.lore(lore);
                is.setItemMeta(im);
                int remaining = current.getArtronLevel() - cost;
                ItemStack st = view.getItem(SystemTree.UPGRADE_TREE.getSlot());
                ItemMeta stim = st.getItemMeta();
                List stlore = stim.lore();
                stlore.set(3, Component.text((String)("Artron Level: " + remaining), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
                stim.lore(stlore);
                st.setItemMeta(stim);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.debug("IllegalArgumentException for " + clicked.getRequired());
            this.close(player);
        }
    }
}

