/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRegenerations;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISRegenerationCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"add", (Object)"remove", (Object)"block");

    public TARDISRegenerationCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisregeneration")) {
            if (args.length < 2) {
                this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "TOO_FEW_ARGS");
                return true;
            }
            if (args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("add")) {
                if (!sender.hasPermission("tardis.admin")) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
                    return true;
                }
                if (args.length < 3) {
                    this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "TOO_FEW_ARGS");
                    return true;
                }
                Player p = this.plugin.getServer().getPlayer(args[1]);
                if (p == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "COULD_NOT_FIND_NAME");
                    return true;
                }
                String uuid = p.getUniqueId().toString();
                int amount = TARDISNumberParsers.parseInt(args[2]);
                int max = this.plugin.getRegenerationConfig().getInt("regenerations", 15);
                if (amount < 0 || amount > max) {
                    this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "ARG_REGENERATION");
                    return true;
                }
                ResultSetRegenerations rsr = new ResultSetRegenerations(this.plugin);
                if (rsr.fromUUID(uuid)) {
                    int setA = rsr.getCount() + (args[0].equalsIgnoreCase("add") ? amount : -amount);
                    if (setA < 0) {
                        setA = 0;
                    }
                    if (setA > max) {
                        setA = max;
                    }
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("regenerations", setA);
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", uuid);
                    this.plugin.getQueryFactory().doUpdate("player_prefs", set, where);
                    this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "REGENERATION_SET", p.getName(), setA);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("block")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    String tf = args[1].toLowerCase(Locale.ROOT);
                    if (!tf.equals("on") && !tf.equals("off")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "PREF_ON_OFF", "regeneration block");
                        return true;
                    }
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("regen_block_on", tf.equals("on") ? 1 : 0);
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", player.getUniqueId().toString());
                    this.plugin.getQueryFactory().doUpdate("player_prefs", set, where);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "REGENERATION_BLOCK", tf);
                    return true;
                }
                this.plugin.getMessenger().send(sender, TardisModule.REGENERATION, "CMD_NO_CONSOLE");
                return true;
            }
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        return ImmutableList.of();
    }
}

