/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.TARDISAdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.artron.TARDISBeaconToggler;
import me.eccentric_nz.TARDIS.artron.TARDISLampToggler;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.StandbyData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetStandby;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISStandbyMode
implements Runnable {
    private final TARDIS plugin;
    private final int amount;

    public TARDISStandbyMode(TARDIS plugin) {
        this.plugin = plugin;
        this.amount = this.plugin.getArtronConfig().getInt("standby");
    }

    @Override
    public void run() {
        HashMap<Integer, StandbyData> ids = new ResultSetStandby(this.plugin).onStandby();
        ids.forEach((key, standbyData) -> {
            int id = key;
            int level = standbyData.level();
            if (!this.isTravelling(id) && !this.isNearCharger(id) && level > this.amount) {
                int remove = this.amount;
                if (this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(standbyData.uuid())) {
                    remove *= 3;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -remove, where, null);
            } else if (level <= this.amount) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    HashMap<String, Object> wherep = new HashMap<String, Object>();
                    wherep.put("tardis_id", id);
                    HashMap<String, Object> setp = new HashMap<String, Object>();
                    setp.put("powered_on", 0);
                    OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(standbyData.uuid());
                    if (player.isOnline()) {
                        TARDISSounds.playTARDISSound(player.getPlayer().getLocation(), "power_down");
                        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "POWER_OFF_AUTO");
                    }
                    long delay = 0L;
                    if (standbyData.hidden()) {
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisremote " + player.getName() + " rebuild");
                        if (player.isOnline()) {
                            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "POWER_FAIL");
                        }
                        delay = 20L;
                    }
                    if (standbyData.preset().equals((Object)ChameleonPreset.ADAPTIVE) || standbyData.preset().usesArmourStand()) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISAdaptiveBoxLampToggler(this.plugin).toggleLamp(id, false, standbyData.preset()), delay);
                    }
                    if (standbyData.lights()) {
                        new TARDISLampToggler(this.plugin).flickSwitch(id, standbyData.uuid(), true, standbyData.lightType());
                    }
                    new TARDISBeaconToggler(this.plugin).flickSwitch(standbyData.uuid(), id, false);
                    this.plugin.getQueryFactory().doUpdate("tardis", setp, wherep);
                    this.plugin.getTrackerKeeper().getActiveForceFields().remove(standbyData.uuid());
                }, 1L);
            }
        });
    }

    private boolean isTravelling(int id) {
        return this.plugin.getTrackerKeeper().getDematerialising().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id);
    }

    private boolean isNearCharger(int id) {
        ResultSetCurrentFromId rs = new ResultSetCurrentFromId(this.plugin, id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) || !rs.resultSet()) {
            return false;
        }
        Current current = rs.getCurrent();
        if (current.location().getWorld() == null) {
            return false;
        }
        for (Location l : this.plugin.getGeneralKeeper().getRechargers()) {
            if (!this.plugin.getUtils().compareLocations(current.location(), l)) continue;
            return true;
        }
        return false;
    }
}

