/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.vehicle.InterpolatedAnimation;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.sonic.actions.TARDISSonicFreeze;
import me.eccentric_nz.TARDIS.utility.TARDISVector3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MountCommand {
    private final TARDIS plugin;

    public MountCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean test(Player player, boolean mount) {
        if (mount) {
            Location observerPos = player.getEyeLocation();
            TARDISVector3D observerDir = new TARDISVector3D(observerPos.getDirection());
            TARDISVector3D observerStart = new TARDISVector3D(observerPos);
            TARDISVector3D observerEnd = observerStart.add(observerDir.multiply(16));
            ArmorStand as = null;
            for (Entity target : player.getNearbyEntities(8.0, 8.0, 8.0)) {
                TARDISVector3D targetPos = new TARDISVector3D(target.getLocation());
                TARDISVector3D minimum = targetPos.add(-0.5, 0.0, -0.5);
                TARDISVector3D maximum = targetPos.add(0.5, 1.67, 0.5);
                if (!target.getType().equals((Object)EntityType.ARMOR_STAND) || !TARDISSonicFreeze.hasIntersection(observerStart, observerEnd, minimum, maximum) || as != null && !(as.getLocation().distanceSquared(observerPos) > target.getLocation().distanceSquared(observerPos))) continue;
                as = (ArmorStand)target;
            }
            if (as == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WA_STAND");
                return true;
            }
            ItemStack box = ItemStack.of((Material)Material.BLUE_DYE, (int)1);
            ItemMeta im = box.getItemMeta();
            im.setItemModel(ChameleonVariant.BLUE_CLOSED.getKey());
            box.setItemMeta(im);
            ItemDisplay display = VehicleUtility.getItemDisplay(player, box, 1.75f);
            int period = 40;
            this.plugin.getTrackerKeeper().setAnimateTask(this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new InterpolatedAnimation(display, period), 5L, (long)period));
            as.addPassenger((Entity)player);
        } else {
            for (Entity e : player.getPassengers()) {
                e.eject();
                e.remove();
            }
            Entity vehicle = player.getVehicle();
            vehicle.eject();
            this.plugin.getServer().getScheduler().cancelTask(this.plugin.getTrackerKeeper().getAnimateTask());
        }
        return true;
    }
}

