/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisCommand;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.update.TARDISUpdateableCategory;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final TARDIS plugin;
    private final List<String> ROOT_SUBS = new ArrayList<String>();
    private final List<String> ON_OFF_SUBS = ImmutableList.of((Object)"on", (Object)"off");
    private final List<String> DOOR_SUBS = ImmutableList.of((Object)"open", (Object)"close");
    private final List<String> ITEM_SUBS = ImmutableList.of((Object)"hand", (Object)"inventory", (Object)"cell");
    private final List<String> DIR_SUBS = ImmutableList.of((Object)"north", (Object)"west", (Object)"south", (Object)"east", (Object)"north_east", (Object)"north_west", (Object)"south_west", (Object)"south_east");
    private final List<String> LIST_SUBS = ImmutableList.of((Object)"companions", (Object)"saves", (Object)"areas", (Object)"rechargers");
    private final List<String> LAMP_SUBS = ImmutableList.of((Object)"auto", (Object)"list", (Object)"set");
    private final List<String> ALLOWED_LAMP_MATERIALS = new ArrayList<String>();
    private final List<String> ARCHIVE_SUBS = ImmutableList.of((Object)"add", (Object)"description", (Object)"remove", (Object)"scan", (Object)"update", (Object)"y");
    private final List<String> EXTRA_SUBS = ImmutableList.of((Object)"blocks", (Object)"unlock");
    private final List<String> Y_SUBS = ImmutableList.of((Object)"64", (Object)"65");
    private final List<String> CONSOLE_SIZE_SUBS = ImmutableList.of((Object)"SMALL", (Object)"MEDIUM", (Object)"TALL", (Object)"MASSIVE");
    private final List<String> THEME_SUBS = ImmutableList.of((Object)"SIXTY_THREE", (Object)"ZERO_FIVE", (Object)"TWENTY_TWENTY", (Object)"RANDOM");
    private final List<String> TRANSMAT_SUBS = ImmutableList.of((Object)"tp", (Object)"add", (Object)"remove", (Object)"update", (Object)"list");
    private final List<String> MONSTERS_SUBS = ImmutableList.of((Object)"reset", (Object)"kill");
    private final List<String> UPD_SUBS = new ArrayList<String>();
    private final List<String> SEC_SUBS = new ArrayList<String>();
    private final List<String> RECHARGER_SUBS;
    private final List<String> MAT_SUBS = new ArrayList<String>();
    private final List<String> PRESET_SUBS = new ArrayList<String>();
    private final List<String> DIM_SUBS = new ArrayList<String>();
    private final List<String> SECTION_SUBS = new ArrayList<String>();
    private final List<String> HANDLES_SUBS = ImmutableList.of((Object)"rotate", (Object)"lock");

    public TARDISTabComplete(TARDIS plugin) {
        this.plugin = plugin;
        for (TardisCommand tardisCommand : TardisCommand.values()) {
            this.ROOT_SUBS.add(tardisCommand.toString());
        }
        this.RECHARGER_SUBS = this.getPublicRechargers();
        for (Enum enum_ : ChameleonPreset.values()) {
            this.PRESET_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : Updateable.values()) {
            this.UPD_SUBS.add(((Updateable)enum_).getName());
            if (((Updateable)enum_).isSecondary()) {
                this.SEC_SUBS.add(((Updateable)enum_).getName());
            }
            this.UPD_SUBS.add("blocks");
            this.UPD_SUBS.add("handles");
            this.UPD_SUBS.add("list");
            this.UPD_SUBS.add("remove_displays");
        }
        this.SEC_SUBS.add("remove");
        TARDISWalls.BLOCKS.forEach(m -> this.MAT_SUBS.add(m.toString()));
        for (World w : plugin.getServer().getWorlds()) {
            this.DIM_SUBS.add(TARDISAliasResolver.getWorldAlias(w));
        }
        for (TARDISUpdateableCategory tARDISUpdateableCategory : TARDISUpdateableCategory.values()) {
            this.SECTION_SUBS.add(tARDISUpdateableCategory.getName().toLowerCase(Locale.ROOT));
        }
        List lampAllowList = plugin.getLampsConfig().getList("lamp_blocks");
        if (lampAllowList != null) {
            for (Object allow : lampAllowList) {
                if (!(allow instanceof String)) continue;
                String string = (String)allow;
                this.ALLOWED_LAMP_MATERIALS.add(string);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub2;
            switch (sub2 = args[0].toLowerCase(Locale.ROOT)) {
                case "add": 
                case "comehere": 
                case "remove": 
                case "rescue": 
                case "save_player": {
                    return null;
                }
                case "archive": {
                    return this.partial(lastArg, this.ARCHIVE_SUBS);
                }
                case "bell": {
                    return this.partial(lastArg, this.ON_OFF_SUBS);
                }
                case "direction": {
                    return this.partial(lastArg, this.DIR_SUBS);
                }
                case "door": {
                    return this.partial(lastArg, this.DOOR_SUBS);
                }
                case "egg": {
                    return this.partial(lastArg, this.THEME_SUBS);
                }
                case "sethome": {
                    return this.partial(lastArg, List.of("preset"));
                }
                case "item": {
                    return this.partial(lastArg, this.ITEM_SUBS);
                }
                case "list": {
                    return this.partial(lastArg, this.LIST_SUBS);
                }
                case "room": 
                case "jettison": {
                    return this.partial(lastArg, this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false));
                }
                case "lamps": {
                    return this.partial(lastArg, this.LAMP_SUBS);
                }
                case "monsters": {
                    return this.partial(lastArg, this.MONSTERS_SUBS);
                }
                case "transmat": {
                    return this.partial(lastArg, this.TRANSMAT_SUBS);
                }
                case "secondary": {
                    return this.partial(lastArg, this.SEC_SUBS);
                }
                case "update": 
                case "decommission": {
                    return this.partial(lastArg, this.UPD_SUBS);
                }
                case "dimensionicon": {
                    return this.partial(lastArg, this.DIM_SUBS);
                }
                case "section": {
                    return this.partial(lastArg, this.SECTION_SUBS);
                }
            }
        } else if (args.length == 3) {
            String sub3 = args[1].toLowerCase(Locale.ROOT);
            switch (args[0]) {
                case "update": {
                    if (sub3.equals("handles")) {
                        return this.partial(lastArg, this.HANDLES_SUBS);
                    }
                    return this.partial(lastArg, this.EXTRA_SUBS);
                }
                case "saveicon": {
                    return this.partial(lastArg, this.MAT_SUBS);
                }
                case "lamps": {
                    return ImmutableList.of();
                }
            }
            switch (sub3) {
                case "rechargers": {
                    return this.partial(lastArg, this.RECHARGER_SUBS);
                }
                case "scan": {
                    return this.partial(lastArg, this.CONSOLE_SIZE_SUBS);
                }
                case "set": {
                    return this.partial(lastArg, this.PRESET_SUBS);
                }
            }
        } else if (args.length == 4) {
            String sub4 = args[1].toLowerCase(Locale.ROOT);
            if (sub4.equals("add") || sub4.equals("update")) {
                return this.partial(lastArg, this.CONSOLE_SIZE_SUBS);
            }
            if (sub4.equals("y")) {
                return this.partial(lastArg, this.Y_SUBS);
            }
        } else if ((args.length == 6 || args.length == 7) && (sub = args[0].toLowerCase(Locale.ROOT)).equals("lamps")) {
            return this.partial(lastArg, this.ALLOWED_LAMP_MATERIALS);
        }
        return ImmutableList.of();
    }

    private List<String> getPublicRechargers() {
        ArrayList<String> ret = new ArrayList<String>();
        this.plugin.getConfig().getConfigurationSection("rechargers").getKeys(false).forEach(r -> {
            if (!r.startsWith("rift")) {
                ret.add((String)r);
            }
        });
        return ret;
    }
}

