/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.control.TARDISScannerData;
import me.eccentric_nz.TARDIS.control.TARDISScannerMap;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.rooms.TARDISExteriorRenderer;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class TARDISScanner {
    private final TARDIS plugin;

    public TARDISScanner(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static List<Entity> getNearbyEntities(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        ArrayList<Entity> radiusEntities = new ArrayList<Entity>();
        for (int chX = -chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = -chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e.getLocation().distance(l) <= (double)radius) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return radiusEntities;
    }

    public TARDISScannerData getScannerData(Player player, int id, BukkitScheduler bsched) {
        String whereIsIt;
        COMPASS tardisDirection;
        Location scan_loc;
        TARDISScannerData data = new TARDISScannerData();
        TARDISSounds.playTARDISSound(player.getLocation(), "tardis_scanner");
        if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
            ResultSetNextLocation rsn = new ResultSetNextLocation(this.plugin, id);
            if (!rsn.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NEXT_NOT_FOUND");
                return null;
            }
            scan_loc = new Location(rsn.getWorld(), (double)rsn.getX(), (double)rsn.getY(), (double)rsn.getZ());
            tardisDirection = rsn.getDirection();
            whereIsIt = this.plugin.getLanguage().getString("SCAN_NEXT");
        } else {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return null;
            }
            Current current = rsc.getCurrent();
            scan_loc = current.location();
            tardisDirection = current.direction();
            whereIsIt = this.plugin.getLanguage().getString("SCAN_CURRENT");
        }
        data.setScanLocation(scan_loc);
        data.setTardisDirection(tardisDirection);
        HashMap<EntityType, Integer> scannedEntities = new HashMap<EntityType, Integer>();
        ArrayList<String> playerNames = new ArrayList<String>();
        for (Entity k : TARDISScanner.getNearbyEntities(scan_loc, 16)) {
            EntityType et = k.getType();
            if (!TARDISConstants.ENTITY_TYPES.contains(et)) continue;
            boolean visible = true;
            if (et.equals((Object)EntityType.PLAYER)) {
                Player entPlayer = (Player)k;
                if (player.canSee(entPlayer)) {
                    playerNames.add(entPlayer.getName());
                } else {
                    visible = false;
                }
            }
            if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                EntityEquipment ee;
                if ((et.equals((Object)EntityType.SKELETON) || et.equals((Object)EntityType.ZOMBIE) || et.equals((Object)EntityType.ZOMBIFIED_PIGLIN)) && (ee = ((LivingEntity)k).getEquipment()).getHelmet() != null) {
                    switch (ee.getHelmet().getType()) {
                        case BAKED_POTATO: {
                            et = EntityType.EGG;
                            break;
                        }
                        case BOOK: {
                            et = EntityType.END_CRYSTAL;
                            break;
                        }
                        case CRIMSON_BUTTON: {
                            et = EntityType.BLOCK_DISPLAY;
                            break;
                        }
                        case FEATHER: {
                            et = EntityType.JUNGLE_BOAT;
                            break;
                        }
                        case IRON_INGOT: {
                            et = EntityType.AREA_EFFECT_CLOUD;
                            break;
                        }
                        case KELP: {
                            et = EntityType.EXPERIENCE_BOTTLE;
                            break;
                        }
                        case MANGROVE_PROPAGULE: {
                            et = EntityType.SMALL_FIREBALL;
                            break;
                        }
                        case NETHERITE_SCRAP: {
                            et = EntityType.GLOW_ITEM_FRAME;
                            break;
                        }
                        case PAINTING: {
                            et = EntityType.FISHING_BOBBER;
                            break;
                        }
                        case POTATO: {
                            et = EntityType.FIREWORK_ROCKET;
                            break;
                        }
                        case PUFFERFISH: {
                            et = EntityType.INTERACTION;
                            break;
                        }
                        case RED_CANDLE: {
                            et = EntityType.TEXT_DISPLAY;
                            break;
                        }
                        case SLIME_BALL: {
                            et = EntityType.LLAMA_SPIT;
                            break;
                        }
                        case SNOWBALL: {
                            et = EntityType.SNOWBALL;
                            break;
                        }
                        case SPIDER_EYE: {
                            et = EntityType.ITEM_DISPLAY;
                            break;
                        }
                        case STONE_BUTTON: {
                            et = EntityType.DRAGON_FIREBALL;
                            break;
                        }
                        case SUGAR: {
                            et = EntityType.FALLING_BLOCK;
                            break;
                        }
                        case TURTLE_EGG: {
                            et = EntityType.ARROW;
                            break;
                        }
                    }
                }
                if (et.equals((Object)EntityType.ENDERMAN) && !k.getPassengers().isEmpty() && k.getPassengers().getFirst() != null && ((Entity)k.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) {
                    et = EntityType.SPLASH_POTION;
                }
                if (et.equals((Object)EntityType.ARMOR_STAND) && (ee = ((ArmorStand)k).getEquipment()).getHelmet() != null) {
                    switch (ee.getHelmet().getType()) {
                        case YELLOW_DYE: {
                            et = EntityType.SHULKER_BULLET;
                            break;
                        }
                        case BONE: {
                            et = EntityType.EVOKER_FANGS;
                            break;
                        }
                        case ROTTEN_FLESH: {
                            et = EntityType.ITEM_FRAME;
                            break;
                        }
                        case GUNPOWDER: {
                            et = EntityType.ITEM;
                            break;
                        }
                    }
                }
            }
            Integer entity_count = scannedEntities.getOrDefault(et, 0);
            if (!visible) continue;
            scannedEntities.put(et, entity_count + 1);
        }
        if (TARDISPermission.hasPermission(player, "tardis.scanner.map")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            where.put("type", 37);
            ResultSetControls rs = new ResultSetControls(this.plugin, where, true);
            if (rs.resultSet()) {
                Location mapFrame = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getLocation());
                if (mapFrame != null) {
                    while (!mapFrame.getChunk().isLoaded()) {
                        mapFrame.getChunk().load();
                    }
                }
                ItemFrame itemFrame = null;
                for (Entity e : mapFrame.getWorld().getNearbyEntities(mapFrame, 1.0, 1.0, 1.0)) {
                    if (!(e instanceof ItemFrame)) continue;
                    itemFrame = (ItemFrame)e;
                    break;
                }
                if (itemFrame != null && itemFrame.getItem().getType() == Material.FILLED_MAP) {
                    new TARDISScannerMap(this.plugin, scan_loc, itemFrame).setMap();
                }
            }
        }
        long time = scan_loc.getWorld().getTime();
        data.setTime(time);
        String dayNight = TARDISStaticUtils.getTime(time);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_RESULT", whereIsIt);
        String worldName = scan_loc.getWorld().getName();
        String alias = !this.plugin.getPlanetsConfig().getBoolean("planets." + worldName + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(scan_loc.getWorld()) : TARDISAliasResolver.getWorldAlias(scan_loc.getWorld());
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_WORLD", alias);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_COORDS", scan_loc.getBlockX() + ":" + scan_loc.getBlockY() + ":" + scan_loc.getBlockZ());
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_DIRECTION", tardisDirection.toString()), 20L);
        String biome = scan_loc.getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT);
        data.setScannedBiome(biome);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_TYPE", biome), 40L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_TIME", dayNight + " / " + time), 60L);
        String weather = switch (biome) {
            case "DESERT", "DESERT_HILLS", "DESERT_LAKES", "SAVANNA", "SAVANNA_PLATEAU", "SHATTERED_SAVANNA", "SHATTERED_SAVANNA_PLATEAU", "BADLANDS", "BADLANDS_PLATEAU", "ERODED_BADLANDS", "MODIFIED_BADLANDS_PLATEAU", "MODIFIED_WOODED_BADLANDS_PLATEAU", "WOODED_BADLANDS_PLATEAU" -> this.plugin.getLanguage().getString("WEATHER_DRY");
            case "SNOWY_TUNDRA", "ICE_SPIKES", "FROZEN_OCEAN", "FROZEN_RIVER", "SNOWY_BEACH", "SNOWY_TAIGA", "SNOWY_MOUNTAINS", "SNOWY_TAIGA_HILLS", "SNOWY_TAIGA_MOUNTAINS" -> {
                if (scan_loc.getWorld().hasStorm()) {
                    yield this.plugin.getLanguage().getString("WEATHER_SNOW");
                }
                yield this.plugin.getLanguage().getString("WEATHER_COLD");
            }
            default -> scan_loc.getWorld().hasStorm() ? this.plugin.getLanguage().getString("WEATHER_RAIN") : this.plugin.getLanguage().getString("WEATHER_CLEAR");
        };
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_WEATHER", weather), 80L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_HUMIDITY", String.format("%.2f", scan_loc.getBlock().getHumidity())), 100L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_TEMP", String.format("%.2f", scan_loc.getBlock().getTemperature())), 120L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (!scannedEntities.isEmpty()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_ENTS");
                scannedEntities.forEach((ent, value) -> {
                    Object message = "";
                    StringBuilder buf = new StringBuilder();
                    if (ent.equals((Object)EntityType.PLAYER) && !playerNames.isEmpty()) {
                        playerNames.forEach(p -> buf.append(", ").append((String)p));
                        message = " (" + buf.substring(2) + ")";
                    }
                    switch (ent) {
                        case AREA_EFFECT_CLOUD: {
                            player.sendMessage("    Cyberman: " + value);
                            break;
                        }
                        case ARROW: {
                            player.sendMessage("    Slitheen: " + value);
                            break;
                        }
                        case BLOCK_DISPLAY: {
                            player.sendMessage("    Davros: " + value);
                            break;
                        }
                        case JUNGLE_BOAT: {
                            player.sendMessage("    Silurian: " + value);
                            break;
                        }
                        case DRAGON_FIREBALL: {
                            player.sendMessage("    Weeping Angel: " + value);
                            break;
                        }
                        case ITEM: {
                            player.sendMessage("    Toclafane: " + value);
                            break;
                        }
                        case EGG: {
                            player.sendMessage("    Strax: " + value);
                            break;
                        }
                        case END_CRYSTAL: {
                            player.sendMessage("    Vashta Nerada: " + value);
                            break;
                        }
                        case EVOKER_FANGS: {
                            player.sendMessage("    K9: " + value);
                            break;
                        }
                        case FALLING_BLOCK: {
                            player.sendMessage("    Empty Child: " + value);
                            break;
                        }
                        case FIREWORK_ROCKET: {
                            player.sendMessage("    Sontaran: " + value);
                            break;
                        }
                        case FISHING_BOBBER: {
                            player.sendMessage("    Zygon: " + value);
                            break;
                        }
                        case GLOW_ITEM_FRAME: {
                            player.sendMessage("    Mire: " + value);
                            break;
                        }
                        case INTERACTION: {
                            player.sendMessage("    Hath: " + value);
                            break;
                        }
                        case ITEM_DISPLAY: {
                            player.sendMessage("    Racnoss: " + value);
                            break;
                        }
                        case ITEM_FRAME: {
                            player.sendMessage("    Ood: " + value);
                            break;
                        }
                        case LLAMA_SPIT: {
                            player.sendMessage("    Dalek: " + value);
                            break;
                        }
                        case SHULKER_BULLET: {
                            player.sendMessage("    Judoon: " + value);
                            break;
                        }
                        case SMALL_FIREBALL: {
                            player.sendMessage("    Dalek Sec: " + value);
                            break;
                        }
                        case SNOWBALL: {
                            player.sendMessage("    Ice Warrior: " + value);
                            break;
                        }
                        case SPLASH_POTION: {
                            player.sendMessage("    Silent: " + value);
                            break;
                        }
                        case TEXT_DISPLAY: {
                            player.sendMessage("    Headless Monk: " + value);
                            break;
                        }
                        case EXPERIENCE_BOTTLE: {
                            player.sendMessage("    Sea Devil: " + value);
                            break;
                        }
                        default: {
                            if (ent == EntityType.ARMOR_STAND) break;
                            player.sendMessage("    " + String.valueOf(ent) + ": " + value + (String)message);
                        }
                    }
                });
                scannedEntities.clear();
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_NONE");
            }
            if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.scanner") > 0) {
                TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
                tcc.getCircuits();
                int uses_left = tcc.getScannerUses();
                new TARDISCircuitDamager(this.plugin, DiskCircuit.SCANNER, uses_left, id, player).damage();
            }
        }, 140L);
        return data;
    }

    public void scan(int id, Player player, String renderer, int level) {
        BukkitScheduler scheduler;
        TARDISScannerData data;
        TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
        tcc.getCircuits();
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false) && !tcc.hasScanner()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_MISSING");
            return;
        }
        if (this.plugin.getTrackerKeeper().getHasRandomised().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_NO_RANDOM");
            return;
        }
        if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.scanner") > 0) {
            int uses_left = tcc.getScannerUses();
            new TARDISCircuitDamager(this.plugin, DiskCircuit.SCANNER, uses_left, id, player).damage();
        }
        if ((data = this.getScannerData(player, id, scheduler = this.plugin.getServer().getScheduler())) != null) {
            boolean extrend = true;
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
            if (rsp.resultSet()) {
                extrend = rsp.isRendererOn();
            }
            if (!renderer.isEmpty() && extrend) {
                int required = this.plugin.getArtronConfig().getInt("render");
                if (level > required) {
                    scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.plugin.getUtils().inTARDISWorld(player)) {
                            TARDISExteriorRenderer ter = new TARDISExteriorRenderer(this.plugin);
                            ter.render(renderer, data.getScanLocation(), id, player, data.getTardisDirection(), data.getTime(), data.getScannedBiome());
                        }
                    }, 160L);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_RENDER");
                }
            }
        }
    }
}

