/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.custommodels.GUISaves;
import me.eccentric_nz.TARDIS.database.data.Destination;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinationsByPlanet;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISSavesInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final List<Integer> slots = new LinkedList<Integer>(List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44));
    private final int id;
    private final String world;
    private final Inventory inventory;

    public TARDISSavesInventory(TARDIS plugin, int id, String world) {
        this.plugin = plugin;
        this.id = id;
        this.world = world;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS saves", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        HashMap<Integer, ItemStack> dests = new HashMap<Integer, ItemStack>();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        where.put("world", this.world);
        ResultSetDestinationsByPlanet rsd = new ResultSetDestinationsByPlanet(this.plugin, where);
        int i = 0;
        int highest = -1;
        if (rsd.resultSet()) {
            List<Destination> data = rsd.getData();
            int count = 0;
            for (Destination map : data) {
                Material material;
                int slot;
                if (map.type() != 0) continue;
                if (++count > 45) break;
                if (map.slot() != -1) {
                    slot = map.slot();
                    if (slot > highest) {
                        highest = slot;
                    }
                } else {
                    slot = this.slots.getFirst();
                }
                this.slots.remove((Object)slot);
                if (slot >= 45) continue;
                if (map.icon().isEmpty()) {
                    material = TARDISConstants.GUI_IDS.get(i);
                } else {
                    try {
                        material = Material.valueOf((String)map.icon());
                    }
                    catch (IllegalArgumentException e) {
                        material = TARDISConstants.GUI_IDS.get(i);
                    }
                }
                ItemStack is = ItemStack.of((Material)material, (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)map.dest_name()));
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                String world = !this.plugin.getPlanetsConfig().getBoolean("planets." + map.world() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(map.world()) : TARDISAliasResolver.getWorldAlias(map.world());
                lore.add(Component.text((String)world));
                lore.add(Component.text((String)("" + map.x())));
                lore.add(Component.text((String)("" + map.y())));
                lore.add(Component.text((String)("" + map.z())));
                lore.add(Component.text((String)map.direction()));
                lore.add(Component.text((boolean)map.submarine()));
                if (!map.preset().isEmpty()) {
                    lore.add(Component.text((String)map.preset()));
                }
                im.lore(lore);
                is.setItemMeta(im);
                dests.put(slot, is);
                ++i;
            }
            for (int s = 0; s < 45; ++s) {
                stack[s] = dests.getOrDefault(s, null);
            }
        }
        ItemStack tool = ItemStack.of((Material)GUISaves.REARRANGE_SAVES.material(), (int)1);
        ItemMeta rearrange = tool.getItemMeta();
        rearrange.displayName((Component)Component.text((String)"Rearrange saves"));
        tool.setItemMeta(rearrange);
        ItemStack bucket = ItemStack.of((Material)GUISaves.DELETE_SAVE.material(), (int)1);
        ItemMeta delete = bucket.getItemMeta();
        delete.displayName((Component)Component.text((String)"Delete save"));
        bucket.setItemMeta(delete);
        ItemStack planet = ItemStack.of((Material)GUISaves.BACK_TO_PLANETS.material(), (int)1);
        ItemMeta map = planet.getItemMeta();
        map.displayName((Component)Component.text((String)"Back to Dimension Map"));
        planet.setItemMeta(map);
        block9: for (int m = 45; m < 54; ++m) {
            switch (m) {
                case 45: {
                    stack[m] = tool;
                    continue block9;
                }
                case 47: {
                    stack[m] = bucket;
                    continue block9;
                }
                case 53: {
                    stack[m] = planet;
                    continue block9;
                }
                default: {
                    stack[m] = null;
                }
            }
        }
        return stack;
    }
}

