/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.compound;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.compound.CompoundBuilder;
import me.eccentric_nz.tardischemistry.compound.CompoundInventory;
import me.eccentric_nz.tardischemistry.element.Element;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CompoundGUIListener
extends TARDISMenuListener {
    public CompoundGUIListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompoundMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof CompoundInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < 27) {
            switch (slot) {
                case 0: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                case 17: {
                    event.setCancelled(true);
                    this.checkFormula(event.getClickedInventory(), player);
                    break;
                }
                case 26: {
                    event.setCancelled(true);
                    this.close(player);
                    break;
                }
                default: {
                    event.setCancelled(true);
                    break;
                }
            }
        } else {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("CompoundGUIListener");
                event.setCancelled(true);
            }
        }
    }

    private void checkFormula(Inventory inventory, Player player) {
        String f;
        StringBuilder formula = new StringBuilder();
        for (int i = 18; i < 26; ++i) {
            ItemMeta im;
            ItemStack is = inventory.getItem(i);
            if (is == null || !is.getType().equals((Object)Material.FEATHER) || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName()) continue;
            try {
                Element element = Element.valueOf(ComponentUtils.stripColour(im.displayName()));
                int amount = is.getAmount();
                formula.append((Object)element).append(":").append(amount).append("-");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String string = f = formula.length() > 1 ? formula.substring(0, formula.length() - 1) : "";
        if (!f.isEmpty()) {
            for (Compound compound : Compound.values()) {
                if (!compound.getFormula().equals(f)) continue;
                ItemStack chemical = CompoundBuilder.getCompound(compound);
                inventory.setItem(0, chemical);
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                for (int i = 18; i < 26; ++i) {
                    inventory.setItem(i, null);
                }
                return;
            }
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
    }
}

