/*
 * Decompiled with CFR 0.152.
 */
package cintlex.responsiveserver;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsiveServerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ResponsiveServer");
    private static final Path CONFIG_PATH = Paths.get("config/responsiveserver.properties", new String[0]);
    private static final int latestversion = 1;
    private static ResponsiveServerConfig cfg;
    public boolean bypassDefaultIntervals = true;
    public int updateInterval = 1;
    public boolean MC100949 = true;
    public boolean MC233911 = true;
    public boolean MC278139 = true;
    public boolean MC297196 = true;
    private int cfgversion = 1;

    private ResponsiveServerConfig() {
    }

    public static ResponsiveServerConfig getInstance() {
        if (cfg == null) {
            cfg = new ResponsiveServerConfig();
            cfg.load();
        }
        return cfg;
    }

    public void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                this.save();
                LOGGER.info("[Responsive Server] Initialized config");
                return;
            }
            Properties p = new Properties();
            try (FileInputStream fis = new FileInputStream(CONFIG_PATH.toFile());){
                p.load(fis);
            }
            int version = Integer.parseInt(p.getProperty("version", "0"));
            this.bypassDefaultIntervals = Boolean.parseBoolean(p.getProperty("bypassDefaultIntervals", "true"));
            this.updateInterval = Integer.parseInt(p.getProperty("updateInterval", "1"));
            this.MC100949 = Boolean.parseBoolean(p.getProperty("MC100949", "true"));
            this.MC233911 = Boolean.parseBoolean(p.getProperty("MC233911", "true"));
            this.MC278139 = Boolean.parseBoolean(p.getProperty("MC278139", "true"));
            this.MC297196 = Boolean.parseBoolean(p.getProperty("MC297196", "true"));
            if (version < 1) {
                this.cfgversion = 1;
                this.save();
            } else {
                this.cfgversion = version;
            }
            LOGGER.info("[Responsive Server] Initialized config");
        }
        catch (IOException | NumberFormatException e) {
            this.save();
        }
    }

    private void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            StringBuilder sb = new StringBuilder();
            sb.append("# Config version, don't touch\n");
            sb.append("version=").append(this.cfgversion).append("\n\n");
            sb.append("#You must restart your client/server to apply changes!\n\n");
            sb.append("# UPDATE RATE\n\n");
            sb.append("# This will automatically set every loaded entity to have an update interval of the value\n");
            sb.append("# specified in the updateInterval setting. This makes all entities update at the same\n");
            sb.append("# consistency, providing smoother motion, less interpolation, and more accurate positions\n");
            sb.append("# depending on the set value. This also includes projectiles, item entities, dropped items,\n");
            sb.append("# boats, etc. This bypasses mojang optimized intervals, and may impact the server's MSPT.\n");
            sb.append("# Disabling this will also disable the UpdateInterval setting.\n");
            sb.append("# Performance Impact: Low-High\n");
            sb.append("bypassDefaultIntervals=").append(this.bypassDefaultIntervals).append("\n\n");
            sb.append("# How many ticks until updateInterval sends changes.\n");
            sb.append("# This setting will be ignored if bypassDefaultIntervals is false.\n");
            sb.append("# Performance Impact: Low-High\n");
            sb.append("# Mojang default: 3\n");
            sb.append("# Min: 1\n");
            sb.append("updateInterval=").append(this.updateInterval).append("\n\n");
            sb.append("# FIXES\n\n");
            sb.append("# MC-100949 - Shield blocking is delayed\n");
            sb.append("# Removes the 5 tick delay when starting and ending a shield block. Fixes the small window of\n");
            sb.append("# inconsistency where you appear to be blocking, but still take damage.\n");
            sb.append("# Performance Impact: None\n");
            sb.append("MC100949=").append(this.MC100949).append("\n\n");
            sb.append("# MC-233911 - Sleeping in a bed and waking up no longer instantly sets the daytime sky\n");
            sb.append("# Sends time packet immediately to clients after wakeUpAllPlayers is called. Fixes the sky\n");
            sb.append("# still being dark for a bit when players skip night.\n");
            sb.append("# Performance Impact: None\n");
            sb.append("MC233911=").append(this.MC233911).append("\n\n");
            sb.append("# MC-278139 - Players are no longer affected by knockback upon death\n");
            sb.append("# Prevents the client from being set to an unloaded state during the death animation. Fixes\n");
            sb.append("# knockback and other motion updates not applying to dead players.\n");
            sb.append("# Performance Impact: None\n");
            sb.append("MC278139=").append(this.MC278139).append("\n\n");
            sb.append("# MC-297196 - Knockback is synchronized to client with inconsistent delay\n");
            sb.append("# Fixes the ordering of ChunkMap ticks being sent before the ServerLevel tick. It now sends\n");
            sb.append("# after. This is how the vanilla game handled it before 1.14, recommended to leave on for\n");
            sb.append("# smoother combat.\n");
            sb.append("# Performance Impact: Minimal\n");
            sb.append("MC297196=").append(this.MC297196).append("\n");
            Files.writeString(CONFIG_PATH, (CharSequence)sb.toString(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

