/*
 * Decompiled with CFR 0.152.
 */
package tpa.mamtak.tpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Tpa
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, TpaRequest> requests = new HashMap<UUID, TpaRequest>();
    private final Set<UUID> tpaToggled = new HashSet<UUID>();
    private final Set<UUID> teleporting = new HashSet<UUID>();
    private int cooldown;
    private int timeout;
    private int delay;
    private boolean cancelOnMove;
    private boolean cancelOnDamage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        for (String cmd : List.of("tpa", "tpahere", "tpaccept", "tpdeny", "tptoggle")) {
            Objects.requireNonNull(this.getCommand(cmd)).setExecutor((CommandExecutor)this);
            Objects.requireNonNull(this.getCommand(cmd)).setTabCompleter((TabCompleter)this);
        }
    }

    private void loadConfig() {
        FileConfiguration cfg = this.getConfig();
        this.cooldown = cfg.getInt("cooldown", 10);
        this.timeout = cfg.getInt("timeout", 60);
        this.delay = cfg.getInt("delay", 5);
        this.cancelOnMove = cfg.getBoolean("cancel-on-move", true);
        this.cancelOnDamage = cfg.getBoolean("cancel-on-damage", true);
    }

    public void onDisable() {
        this.requests.clear();
        this.tpaToggled.clear();
        this.teleporting.clear();
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        String name;
        if (!(s instanceof Player)) {
            s.sendMessage(Component.text((String)"Only players can use this.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)s;
        switch (name = cmd.getName().toLowerCase()) {
            case "tpa": {
                if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                    if (player.isOp()) {
                        this.reloadConfig();
                        this.loadConfig();
                        player.sendMessage(Component.text((String)"TPA config reloaded.").color((TextColor)NamedTextColor.GREEN));
                        break;
                    }
                    player.sendMessage(Component.text((String)"No permission.").color((TextColor)NamedTextColor.RED));
                    break;
                }
                this.handleRequest(player, args, false);
                break;
            }
            case "tpahere": {
                this.handleRequest(player, args, true);
                break;
            }
            case "tpaccept": {
                this.handleAccept(player);
                break;
            }
            case "tpdeny": {
                this.handleDeny(player);
                break;
            }
            case "tptoggle": {
                this.toggleRequests(player);
                break;
            }
            default: {
                player.sendMessage(Component.text((String)"Unknown command.").color((TextColor)NamedTextColor.RED));
            }
        }
        return true;
    }

    private void handleRequest(Player sender, String[] args, boolean here) {
        if (args.length != 1) {
            sender.sendMessage(Component.text((String)("Usage: /" + (here ? "tpahere" : "tpa") + " <player>")).color((TextColor)NamedTextColor.RED));
            return;
        }
        final Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(Component.text((String)"Player not found.").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (target.equals((Object)sender)) {
            sender.sendMessage(Component.text((String)"You can\u2019t teleport to yourself.").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (this.tpaToggled.contains(target.getUniqueId())) {
            sender.sendMessage(Component.text((String)target.getName(), (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" has disabled TPA.", (TextColor)NamedTextColor.LIGHT_PURPLE)));
            return;
        }
        this.requests.put(target.getUniqueId(), new TpaRequest(sender.getUniqueId(), here));
        sender.sendMessage(((TextComponent)Component.text((String)"You", (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" sent a TPA request to ", (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)target.getName(), (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
        TextComponent.Builder b = Component.text();
        ((TextComponent.Builder)b.append((Component)Component.text((String)sender.getName(), (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" wants to teleport ", (TextColor)NamedTextColor.LIGHT_PURPLE));
        if (here) {
            ((TextComponent.Builder)((TextComponent.Builder)b.append((Component)Component.text((String)"you", (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" to ", (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)"them", (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        } else {
            ((TextComponent.Builder)b.append((Component)Component.text((String)"to ", (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)"you", (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        }
        TextComponent prompt = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)b.append((Component)Component.text((String)".\n", (TextColor)NamedTextColor.LIGHT_PURPLE))).append(((TextComponent)Component.text((String)"[Accept]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)"/tpaccept"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to accept").color((TextColor)NamedTextColor.GRAY))))).append((Component)Component.space())).append(((TextComponent)Component.text((String)"[Deny]", (TextColor)NamedTextColor.RED).clickEvent(ClickEvent.runCommand((String)"/tpdeny"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to deny").color((TextColor)NamedTextColor.GRAY))))).build();
        target.sendMessage((Component)prompt);
        new BukkitRunnable(){

            public void run() {
                Tpa.this.requests.remove(target.getUniqueId());
            }
        }.runTaskLater((Plugin)this, (long)this.timeout * 20L);
    }

    private void handleAccept(Player t) {
        TpaRequest req = this.requests.remove(t.getUniqueId());
        if (req == null) {
            t.sendMessage(Component.text((String)"No pending TPA.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Player s = Bukkit.getPlayer((UUID)req.sender);
        if (s == null || !s.isOnline()) {
            t.sendMessage(Component.text((String)"Requester offline.").color((TextColor)NamedTextColor.RED));
            return;
        }
        t.sendMessage(((TextComponent)((TextComponent)Component.text((String)"You", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" accepted ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)s.getName(), (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"'s request.", (TextColor)NamedTextColor.GREEN)));
        s.sendMessage(Component.text((String)t.getName(), (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" accepted your request.", (TextColor)NamedTextColor.GREEN)));
        final Player tel = req.here ? t : s;
        final Player dst = req.here ? s : t;
        this.teleporting.add(tel.getUniqueId());
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = Tpa.this.delay;
            }

            public void run() {
                if (!Tpa.this.teleporting.contains(tel.getUniqueId())) {
                    tel.sendActionBar(Component.text((String)"Teleport canceled").color((TextColor)NamedTextColor.RED));
                    this.cancel();
                    return;
                }
                if (this.seconds > 0) {
                    tel.sendActionBar(Component.text((String)("Teleporting in " + this.seconds + "...")).color((TextColor)NamedTextColor.LIGHT_PURPLE));
                    --this.seconds;
                } else {
                    Tpa.this.teleporting.remove(tel.getUniqueId());
                    tel.teleport((Entity)dst);
                    tel.sendActionBar(Component.text((String)"Teleported to ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)dst.getName(), (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void handleDeny(Player t) {
        TpaRequest req = this.requests.remove(t.getUniqueId());
        if (req == null) {
            t.sendMessage(Component.text((String)"No pending TPA.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Player s = Bukkit.getPlayer((UUID)req.sender);
        if (s != null && s.isOnline()) {
            s.sendMessage(Component.text((String)t.getName(), (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)" denied your request.", (TextColor)NamedTextColor.RED)));
        }
        t.sendMessage(Component.text((String)"TPA request denied.").color((TextColor)NamedTextColor.RED));
    }

    private void toggleRequests(Player p) {
        if (this.tpaToggled.remove(p.getUniqueId())) {
            p.sendMessage(Component.text((String)"Incoming TPA enabled.").color((TextColor)NamedTextColor.GREEN));
        } else {
            this.tpaToggled.add(p.getUniqueId());
            p.sendMessage(Component.text((String)"Incoming TPA disabled.").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (this.cancelOnMove && this.teleporting.remove(e.getPlayer().getUniqueId())) {
            e.getPlayer().sendActionBar(Component.text((String)"Teleport canceled \u2013 moved!").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        Player p;
        Entity entity;
        if (this.cancelOnDamage && (entity = e.getEntity()) instanceof Player && this.teleporting.remove((p = (Player)entity).getUniqueId())) {
            p.sendActionBar(Component.text((String)"Teleport canceled \u2013 damaged!").color((TextColor)NamedTextColor.RED));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        String name = cmd.getName().toLowerCase();
        if ((name.equals("tpa") || name.equals("tpahere")) && args.length == 1) {
            Player p;
            ArrayList<String> out = new ArrayList<String>();
            String lower = args[0].toLowerCase();
            if (name.equals("tpa") && sender instanceof Player && (p = (Player)sender).isOp() && "reload".startsWith(lower)) {
                out.add("reload");
            }
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (!online.getName().toLowerCase().startsWith(lower)) continue;
                out.add(online.getName());
            }
            return out;
        }
        return Collections.emptyList();
    }

    private static class TpaRequest {
        final UUID sender;
        final boolean here;
        final long timestamp;

        TpaRequest(UUID s, boolean h) {
            this.sender = s;
            this.here = h;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

