/*
 * Decompiled with CFR 0.152.
 */
package github.jaffe2718.mcmti.util;

import github.jaffe2718.mcmti.client.MicrophoneTextInput;
import github.jaffe2718.mcmti.config.McmtiConfig;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.jetbrains.annotations.NotNull;

public final class AudioRecorder {
    private static final AudioFormat AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    private static AudioRecorder INSTANCE;
    private final TargetDataLine line = AudioSystem.getTargetDataLine(AUDIO_FORMAT);

    public static void destroy() {
        if (INSTANCE != null) {
            AudioRecorder.INSTANCE.line.close();
            INSTANCE = null;
        }
    }

    public static void init() {
        AudioRecorder.destroy();
        try {
            INSTANCE = new AudioRecorder();
        }
        catch (LineUnavailableException e) {
            MicrophoneTextInput.LOGGER.error("Failed to initialize audio recorder", (Throwable)e);
        }
    }

    public static AudioRecorder instance() {
        return INSTANCE;
    }

    private AudioRecorder() throws LineUnavailableException {
        this.line.open(AUDIO_FORMAT);
    }

    private static float @NotNull [] toFloatArray(byte @NotNull [] data) {
        float[] result = new float[data.length / 2];
        ShortBuffer shortBuffer = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        for (int i = 0; i < result.length; ++i) {
            result[i] = Float.max(-1.0f, Float.min((float)shortBuffer.get() / 32767.0f, 1.0f));
        }
        return result;
    }

    public static float @NotNull [] recordCycle() {
        AudioRecorder.INSTANCE.line.start();
        byte[] buf = new byte[McmtiConfig.recordCycleMs * 32];
        int read = AudioRecorder.INSTANCE.line.read(buf, 0, buf.length);
        AudioRecorder.INSTANCE.line.stop();
        AudioRecorder.INSTANCE.line.flush();
        if (read > 0) {
            return AudioRecorder.toFloatArray(buf);
        }
        return new float[0];
    }

    public static float @NotNull [] record() {
        assert (McmtiConfig.mode != McmtiConfig.Mode.AUTO_SEND);
        ByteArrayOutputStream dynamicBuffer = new ByteArrayOutputStream();
        byte[] chunk = new byte[McmtiConfig.recordBufferSize];
        AudioRecorder.INSTANCE.line.start();
        while (MicrophoneTextInput.RECOGNIZE_KEY.method_1434()) {
            int read = AudioRecorder.INSTANCE.line.read(chunk, 0, chunk.length);
            if (read <= 0) continue;
            dynamicBuffer.write(chunk, 0, read);
        }
        AudioRecorder.INSTANCE.line.stop();
        AudioRecorder.INSTANCE.line.flush();
        return AudioRecorder.toFloatArray(dynamicBuffer.toByteArray());
    }
}

