/*
 * Decompiled with CFR 0.152.
 */
package github.jaffe2718.mcmti.util;

import eu.midnightdust.lib.config.MidnightConfig;
import github.jaffe2718.mcmti.client.MicrophoneTextInput;
import github.jaffe2718.mcmti.client.gui.screen.AdvancedConfigWarningScreen;
import github.jaffe2718.mcmti.config.McmtiConfig;
import github.jaffe2718.mcmti.util.AudioRecorder;
import github.jaffe2718.mcmti.util.SpeechRecognizer;
import java.util.concurrent.locks.LockSupport;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public abstract class EventSystem {
    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(EventSystem::onConfigAltered);
        ClientTickEvents.END_WORLD_TICK.register(EventSystem::showRecognizeStatus);
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            SpeechRecognizer.destroy();
            AudioRecorder.destroy();
        });
        Thread.ofVirtual().start(EventSystem::recognizeTask).setName("thread.mcmti.recognizer.loop");
    }

    private static void showRecognizeStatus(class_638 world) {
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 instanceof class_746) {
            class_746 player = class_7462;
            if (class_310.method_1551().field_1755 == null) {
                if (AudioRecorder.instance() == null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.audioInputDeviceLoadFailed"), true);
                } else if (SpeechRecognizer.instance() == null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.whisperModelLoadFailed"), true);
                } else if (McmtiConfig.mode != McmtiConfig.Mode.AUTO_SEND && MicrophoneTextInput.RECOGNIZE_KEY.method_1434()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.recordingAudio"), true);
                }
            }
        }
    }

    private static void onConfigAltered(class_310 client) {
        if (McmtiConfig.advancedConfig && !MicrophoneTextInput.advancedConfig && class_310.method_1551().field_1755 instanceof MidnightConfig.MidnightConfigScreen) {
            class_310.method_1551().method_1507((class_437)new AdvancedConfigWarningScreen(class_310.method_1551().field_1755));
        }
        if (!McmtiConfig.model.equals(SpeechRecognizer.modelPath) || !McmtiConfig.grammar.equals(SpeechRecognizer.grammarPath)) {
            SpeechRecognizer.init();
        }
        MicrophoneTextInput.advancedConfig = McmtiConfig.advancedConfig;
    }

    private static void recognizeTask() {
        MicrophoneTextInput.LOGGER.info("Recognize thread started");
        @Nullable Thread vthread = null;
        while (true) {
            try {
                while (true) {
                    class_746 class_7462;
                    if ((class_7462 = class_310.method_1551().field_1724) instanceof class_746) {
                        class_746 player = class_7462;
                        if (class_310.method_1551().field_1755 == null && AudioRecorder.instance() != null && SpeechRecognizer.instance() != null) {
                            switch (McmtiConfig.mode) {
                                case AUTO_SEND: {
                                    float[] audio = AudioRecorder.recordCycle();
                                    Thread.ofVirtual().start(() -> {
                                        String result = SpeechRecognizer.recognize(audio);
                                        if (!result.isEmpty()) {
                                            player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.messageSent"), true);
                                            player.field_3944.method_45729(McmtiConfig.prefix + result);
                                        }
                                    });
                                    break;
                                }
                                case RELEASE_KEY_TO_SEND: {
                                    float[] audio;
                                    if (MicrophoneTextInput.RECOGNIZE_KEY.method_1434()) {
                                        audio = AudioRecorder.record();
                                        vthread = Thread.ofVirtual().start(() -> {
                                            String result = SpeechRecognizer.recognize(audio);
                                            if (!result.isEmpty()) {
                                                player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.messageSent"), true);
                                                player.field_3944.method_45729(McmtiConfig.prefix + result);
                                            }
                                        });
                                        break;
                                    }
                                    if (vthread == null || !vthread.isAlive()) break;
                                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.recognizing"), true);
                                    break;
                                }
                                case RELEASE_KEY_TO_INPUT: {
                                    float[] audio;
                                    if (MicrophoneTextInput.RECOGNIZE_KEY.method_1434()) {
                                        audio = AudioRecorder.record();
                                        vthread = Thread.ofVirtual().start(() -> {
                                            String result = SpeechRecognizer.recognize(audio);
                                            if (!result.isEmpty()) {
                                                class_310.method_1551().method_1507((class_437)new class_408(McmtiConfig.prefix + result));
                                            }
                                        });
                                        break;
                                    }
                                    if (vthread == null || !vthread.isAlive()) break;
                                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mcmti.recognizing"), true);
                                }
                            }
                            continue;
                        }
                    }
                    LockSupport.parkNanos(10000000L);
                }
            }
            catch (Throwable t) {
                MicrophoneTextInput.LOGGER.error("Error in recognize task", t);
                continue;
            }
            break;
        }
    }
}

