/*
 * Decompiled with CFR 0.152.
 */
package github.jaffe2718.mcmti.util;

import github.jaffe2718.mcmti.client.MicrophoneTextInput;
import github.jaffe2718.mcmti.config.McmtiConfig;
import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperFullParams;
import io.github.givimad.whisperjni.WhisperGrammar;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeechRecognizer {
    public static final WhisperJNI WHISPER = new WhisperJNI();
    private static volatile SpeechRecognizer INSTANCE;
    @NotNull
    final WhisperContext ctx = WHISPER.init(Path.of(modelPath, new String[0]));
    @Nullable
    final WhisperGrammar grammar = !grammarPath.isEmpty() ? WHISPER.parseGrammar(grammarPath) : null;
    public static String modelPath;
    public static String grammarPath;

    public static SpeechRecognizer instance() {
        return INSTANCE;
    }

    public static void init() {
        SpeechRecognizer.destroy();
        modelPath = McmtiConfig.model;
        String string = grammarPath = McmtiConfig.advancedConfig ? McmtiConfig.grammar : "";
        if (INSTANCE == null) {
            try {
                INSTANCE = new SpeechRecognizer();
            }
            catch (IOException e) {
                MicrophoneTextInput.LOGGER.error("Failed to initialize speech recognizer", (Throwable)e);
            }
        }
    }

    public static void destroy() {
        if (INSTANCE != null) {
            SpeechRecognizer.INSTANCE.ctx.close();
            if (SpeechRecognizer.INSTANCE.grammar != null) {
                WHISPER.free(SpeechRecognizer.INSTANCE.grammar);
            }
            INSTANCE = null;
        }
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    private static String repairEncoding(@NotNull String str, String srcEncoding, String dstEncoding) {
        try {
            return new String(str.getBytes(srcEncoding), dstEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            MicrophoneTextInput.LOGGER.error("Couldn't repair encoding, using default", (Throwable)uee);
            return str;
        }
    }

    @NotNull
    public static String recognize(float[] audio) {
        if (INSTANCE == null) {
            return "";
        }
        WhisperFullParams params = McmtiConfig.getParams();
        params.grammar = SpeechRecognizer.INSTANCE.grammar;
        int flag = WHISPER.full(SpeechRecognizer.INSTANCE.ctx, params, audio, audio.length);
        if (flag == 0) {
            String result = WHISPER.fullGetSegmentText(SpeechRecognizer.INSTANCE.ctx, 0);
            if (McmtiConfig.encodingRepair) {
                return SpeechRecognizer.repairEncoding(result, McmtiConfig.srcEncoding, McmtiConfig.dstEncoding);
            }
            return result;
        }
        return "";
    }

    private SpeechRecognizer() throws IOException {
    }

    static {
        modelPath = "";
        grammarPath = "";
    }
}

