/*
 * Decompiled with CFR 0.152.
 */
package me.jaffe2718.mcmti.config;

import eu.midnightdust.lib.config.MidnightConfig;
import io.github.freshsupasulley.whisperjni.WhisperFullParams;
import io.github.freshsupasulley.whisperjni.WhisperSamplingStrategy;
import java.nio.charset.Charset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class McmtiConfig
extends MidnightConfig {
    @MidnightConfig.Entry(category="general", selectionMode=0, width=4096, fileExtensions={"bin", "ggml"})
    public static String model = "";
    @MidnightConfig.Entry(category="general", width=15)
    public static String language = "en";
    @MidnightConfig.Entry(category="general")
    public static Mode mode = Mode.RELEASE_KEY_TO_SEND;
    @MidnightConfig.Entry(category="general", min=1024.0, max=65536.0)
    @MidnightConfig.Condition(requiredOption="mode", requiredValue={"AUTO_SEND"})
    public static int recordCycleMs = 5000;
    @MidnightConfig.Entry(category="general", min=64.0, max=4096.0)
    @MidnightConfig.Condition(requiredOption="mode", requiredValue={"RELEASE_KEY_TO_SEND", "RELEASE_KEY_TO_INPUT"})
    public static int recordBufferSize = 1024;
    @MidnightConfig.Entry(category="general")
    @MidnightConfig.Condition(requiredOption="mode", requiredValue={"RELEASE_KEY_TO_INPUT"})
    public static boolean draftInput = false;
    @MidnightConfig.Entry(category="general")
    public static String prefix = "\u2308Speech Input\u230b";
    @MidnightConfig.Entry(category="general")
    public static boolean encodingRepair = false;
    @MidnightConfig.Entry(category="general")
    @MidnightConfig.Condition(requiredOption="encodingRepair")
    public static String srcEncoding = Charset.defaultCharset().displayName();
    @MidnightConfig.Entry(category="general")
    @MidnightConfig.Condition(requiredOption="encodingRepair")
    public static String dstEncoding = Charset.defaultCharset().displayName();
    @MidnightConfig.Entry(category="advanced")
    @ApiStatus.Experimental
    public static boolean advancedConfig = false;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean useCustomDynamicLib = false;
    @MidnightConfig.Entry(category="advanced", width=4096, selectionMode=1)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="useCustomDynamicLib")})
    public static String customDynamicLibDir = "";
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int nThreads = 0;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int audioCtx;
    @MidnightConfig.Entry(category="advanced", min=1024.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int nMaxTextCtx;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int offsetMs;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int durationMs;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean translate;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean noTimestamps;
    @MidnightConfig.Entry(category="advanced", width=4096)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static String initialPrompt;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean noContext;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean singleSegment;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean printSpecial;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean printProgress;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean printRealtime;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean printTimestamps;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean suppressBlank;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean suppressNonSpeechTokens;
    @MidnightConfig.Entry(category="advanced", min=0.0, max=2.0, isSlider=true, precision=200)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float temperature;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float maxInitialTs;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float lengthPenalty;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float temperatureInc;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float entropyThold;
    @MidnightConfig.Entry(category="advanced", max=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float logprobThold;
    @MidnightConfig.Entry(category="advanced", min=0.0, max=1.0, isSlider=true, precision=200)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float noSpeechThold;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int greedyBestOf;
    @MidnightConfig.Entry(category="advanced", min=1.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static int beamSearchBeamSize;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float beamSearchPatience;
    @MidnightConfig.Entry(category="advanced", selectionMode=0, fileExtensions={"gbnf"})
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static String grammar;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static float grammarPenalty;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static WhisperSamplingStrategy whisperSamplingStrategy;
    @MidnightConfig.Entry(category="advanced")
    @MidnightConfig.Condition(requiredOption="advancedConfig")
    public static boolean vad;
    @MidnightConfig.Entry(category="advanced", selectionMode=0, width=4096, fileExtensions={"bin", "ggml"})
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static String vad_model_path;
    @MidnightConfig.Entry(category="advanced", min=0.0, max=1.0, isSlider=true, precision=200)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static float vad__threshold;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static int vad__min_speech_duration_ms;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static int vad__min_silence_duration_ms;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static float vad__max_speech_duration_s;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static int vad__speech_pad_ms;
    @MidnightConfig.Entry(category="advanced", min=0.0)
    @MidnightConfig.Conditions(value={@MidnightConfig.Condition(requiredOption="advancedConfig"), @MidnightConfig.Condition(requiredOption="vad")})
    public static float vad__samples_overlap;

    @NotNull
    public static WhisperFullParams getParams() {
        WhisperFullParams params;
        if (advancedConfig) {
            params = new WhisperFullParams(whisperSamplingStrategy);
            params.nThreads = nThreads;
            params.audioCtx = audioCtx;
            params.nMaxTextCtx = nMaxTextCtx;
            params.offsetMs = offsetMs;
            params.temperature = temperature;
            params.maxInitialTs = maxInitialTs;
            params.lengthPenalty = lengthPenalty;
            params.temperatureInc = temperatureInc;
            params.entropyThold = entropyThold;
            params.logprobThold = logprobThold;
            params.noSpeechThold = noSpeechThold;
            params.greedyBestOf = greedyBestOf;
            params.beamSearchBeamSize = beamSearchBeamSize;
            params.beamSearchPatience = beamSearchPatience;
            params.grammarPenalty = grammarPenalty;
            params.suppressNonSpeechTokens = suppressNonSpeechTokens;
            params.suppressBlank = suppressBlank;
            params.printTimestamps = printTimestamps;
            params.printProgress = printProgress;
            params.printRealtime = printRealtime;
            params.printSpecial = printSpecial;
            params.singleSegment = singleSegment;
            params.initialPrompt = initialPrompt.isBlank() ? null : initialPrompt;
            params.noContext = noContext;
            params.translate = translate;
            params.noTimestamps = noTimestamps;
            params.durationMs = durationMs;
            params.vad = vad;
            if (vad) {
                params.vad_model_path = vad_model_path.isBlank() ? null : vad_model_path;
                params.vadParams.threshold = vad__threshold;
                params.vadParams.min_speech_duration_ms = vad__min_speech_duration_ms;
                params.vadParams.min_silence_duration_ms = vad__min_silence_duration_ms;
                params.vadParams.max_speech_duration_s = vad__max_speech_duration_s;
                params.vadParams.speech_pad_ms = vad__speech_pad_ms;
                params.vadParams.samples_overlap = vad__samples_overlap;
            }
        } else {
            params = new WhisperFullParams();
            params.suppressBlank = true;
            params.suppressNonSpeechTokens = true;
        }
        params.language = language;
        return params;
    }

    static {
        nMaxTextCtx = 16384;
        initialPrompt = "";
        noContext = true;
        printProgress = true;
        printTimestamps = true;
        suppressBlank = true;
        suppressNonSpeechTokens = true;
        temperature = 0.0f;
        maxInitialTs = 1.0f;
        lengthPenalty = -1.0f;
        temperatureInc = 0.4f;
        entropyThold = 2.4f;
        logprobThold = -1.0f;
        noSpeechThold = 0.6f;
        greedyBestOf = -1;
        beamSearchBeamSize = 2;
        beamSearchPatience = -1.0f;
        grammar = "";
        grammarPenalty = 100.0f;
        whisperSamplingStrategy = WhisperSamplingStrategy.BEAM_SEARCH;
        vad = false;
        vad_model_path = "";
        vad__threshold = 0.0f;
        vad__min_speech_duration_ms = 0;
        vad__min_silence_duration_ms = 0;
        vad__max_speech_duration_s = 0.0f;
        vad__speech_pad_ms = 0;
        vad__samples_overlap = 0.0f;
    }

    public static enum Mode {
        AUTO_SEND,
        RELEASE_KEY_TO_SEND,
        RELEASE_KEY_TO_INPUT;

    }
}

