/*
 * Decompiled with CFR 0.152.
 */
package me.jaffe2718.mcmti.event;

import eu.midnightdust.lib.config.MidnightConfigScreen;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import me.jaffe2718.mcmti.MicrophoneTextInput;
import me.jaffe2718.mcmti.client.gui.screen.AdvancedConfigWarningScreen;
import me.jaffe2718.mcmti.config.McmtiConfig;
import me.jaffe2718.mcmti.util.AudioRecorder;
import me.jaffe2718.mcmti.util.SpeechRecognizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public interface EventSystem {
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();

    public static void showRecognizeStatus(ClientLevel world) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer instanceof LocalPlayer) {
            LocalPlayer player = localPlayer;
            if (Minecraft.getInstance().screen == null) {
                if (AudioRecorder.instance() == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.audioInputDeviceLoadFailed"), true);
                } else if (SpeechRecognizer.instance() == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.whisperModelLoadFailed"), true);
                } else if (McmtiConfig.mode != McmtiConfig.Mode.AUTO_SEND && MicrophoneTextInput.RECOGNIZE_KEY.isDown()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.recordingAudio"), true);
                }
            }
        }
    }

    public static void onConfigAltered(Minecraft client) {
        if (McmtiConfig.advancedConfig && !MicrophoneTextInput.advancedConfig && Minecraft.getInstance().screen instanceof MidnightConfigScreen) {
            Minecraft.getInstance().setScreen((Screen)new AdvancedConfigWarningScreen(Minecraft.getInstance().screen));
        }
        if (!McmtiConfig.model.equals(SpeechRecognizer.modelPath) || !McmtiConfig.grammar.equals(SpeechRecognizer.grammarPath)) {
            SpeechRecognizer.init();
        }
        MicrophoneTextInput.advancedConfig = McmtiConfig.advancedConfig;
    }

    public static void recognizeTask() {
        MicrophoneTextInput.LOGGER.info("Recognize thread started");
        @Nullable Thread vthread = null;
        while (true) {
            try {
                while (true) {
                    LocalPlayer localPlayer;
                    if (Minecraft.getInstance() != null && (localPlayer = Minecraft.getInstance().player) instanceof LocalPlayer) {
                        LocalPlayer player = localPlayer;
                        if (Minecraft.getInstance().screen == null && AudioRecorder.instance() != null && SpeechRecognizer.instance() != null) {
                            switch (McmtiConfig.mode) {
                                case AUTO_SEND: {
                                    float[] audio = AudioRecorder.recordCycle();
                                    Thread.ofVirtual().start(() -> {
                                        String result = SpeechRecognizer.recognize(audio);
                                        if (!result.isEmpty()) {
                                            player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.messageSent"), true);
                                            player.connection.sendChat(McmtiConfig.prefix + result);
                                        }
                                    });
                                    break;
                                }
                                case RELEASE_KEY_TO_SEND: {
                                    float[] audio;
                                    if (MicrophoneTextInput.RECOGNIZE_KEY.isDown()) {
                                        audio = AudioRecorder.record();
                                        vthread = Thread.ofVirtual().start(() -> {
                                            String result = SpeechRecognizer.recognize(audio);
                                            if (!result.isEmpty()) {
                                                SCHEDULED_EXECUTOR_SERVICE.schedule(() -> player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.messageSent"), true), 100L, TimeUnit.MILLISECONDS);
                                                player.connection.sendChat(McmtiConfig.prefix + result);
                                            }
                                        });
                                    } else if (vthread != null && vthread.isAlive()) {
                                        player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.recognizing"), true);
                                    }
                                    LockSupport.parkNanos(1000000L);
                                    break;
                                }
                                case RELEASE_KEY_TO_INPUT: {
                                    float[] audio;
                                    if (MicrophoneTextInput.RECOGNIZE_KEY.isDown()) {
                                        audio = AudioRecorder.record();
                                        vthread = Thread.ofVirtual().start(() -> {
                                            String result = SpeechRecognizer.recognize(audio);
                                            if (!result.isEmpty()) {
                                                Minecraft.getInstance().submit(() -> Minecraft.getInstance().setScreen((Screen)new ChatScreen(McmtiConfig.prefix + result, McmtiConfig.draftInput))).join();
                                            }
                                        });
                                    } else if (vthread != null && vthread.isAlive()) {
                                        player.displayClientMessage((Component)Component.translatable((String)"message.mcmti.recognizing"), true);
                                    }
                                    LockSupport.parkNanos(1000000L);
                                }
                            }
                            continue;
                        }
                    }
                    LockSupport.parkNanos(10000000L);
                }
            }
            catch (Throwable t) {
                MicrophoneTextInput.LOGGER.error("Error in recognize task", t);
                continue;
            }
            break;
        }
    }
}

