/*
 * Decompiled with CFR 0.152.
 */
package foodaddition;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import foodaddition.api.config.ConfigItems;
import foodaddition.api.handlers.commands.RefreshFoodEffects;
import foodaddition.api.handlers.drops.DropHandler;
import foodaddition.api.handlers.effects.PotionEffectHandler;
import foodaddition.api.recipes.ConfigRecipes;
import foodaddition.config.Config;
import foodaddition.model.config.ConfigTweaks;
import foodaddition.model.integrations.ThaumcraftCompat;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="foodaddition", useMetadata=true)
public class FoodAddition {
    public static final String modID = "foodaddition";
    public static final Logger logger = LogManager.getLogger((String)"foodaddition");
    public static File configDir;
    public static PotionEffectHandler effectHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            configDir = new File(event.getModConfigurationDirectory(), modID);
            configDir.mkdirs();
            Config.init(new File(configDir, modID.concat(".cfg")));
        }
        catch (Exception e) {
            logger.error("Food Addition has a problem loading it's config");
        }
        finally {
            if (Config.config != null) {
                Config.save();
            }
        }
        ConfigItems.init();
        ConfigTweaks.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ConfigRecipes.init();
        if (Config.customMobDropsEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new DropHandler());
        }
        if (Config.potionEffectsEnabled) {
            effectHandler = new PotionEffectHandler();
            MinecraftForge.EVENT_BUS.register((Object)effectHandler);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"Thaumcraft") && Config.thaumcraftIntegrationEnabled) {
            ThaumcraftCompat.init();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new RefreshFoodEffects());
    }

    public static void log(String message) {
        logger.log(Level.INFO, modID.concat(" : ").concat(message));
    }
}

