/*
 * Decompiled with CFR 0.152.
 */
package foodaddition.api.config;

import foodaddition.api.items.FoodAdditionItem;
import foodaddition.model.items.Horse;
import foodaddition.model.items.Sheep;
import foodaddition.model.items.Squid;
import foodaddition.model.items.Wolf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.item.Item;

public class ConfigItems {
    private static final ArrayList<FoodAdditionItem> instances = new ArrayList(4);
    private static final HashMap<String, Item> rawItems;
    private static final HashMap<String, Item> cookedItems;
    public static final ArrayList<String> entitiesThatDrop;

    public static void init() {
        ConfigItems.clearCollections();
        for (FoodAdditionItem instance : instances) {
            entitiesThatDrop.add(instance.getEntityName());
            if (!instance.isItemEnabled()) continue;
            rawItems.put(instance.getEntityName(), instance.getItemRaw());
            cookedItems.put(instance.getEntityName(), instance.getItemCooked());
        }
    }

    private static void clearCollections() {
        rawItems.clear();
        cookedItems.clear();
        entitiesThatDrop.clear();
    }

    public static void registerFoodAdditionItem(FoodAdditionItem ... instances) {
        ConfigItems.instances.addAll(Arrays.asList(instances));
    }

    public static Item getRawItem(String entityName) {
        return rawItems.get(entityName);
    }

    public static Item getCookedItem(String entityName) {
        return cookedItems.get(entityName);
    }

    static {
        ConfigItems.registerFoodAdditionItem(new Horse(), new Sheep(), new Squid(), new Wolf());
        int length = instances.size();
        rawItems = new HashMap(length);
        cookedItems = new HashMap(length);
        entitiesThatDrop = new ArrayList(length);
    }
}

