/*
 * Decompiled with CFR 0.152.
 */
package foodaddition.api.handlers.effects;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import foodaddition.FoodAddition;
import foodaddition.api.handlers.effects.types.EffectEntry;
import foodaddition.api.handlers.effects.types.FoodEffectEntry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class PotionEffectHandler {
    private static final Map<String, List<PotionEffect>> effectMap = new HashMap<String, List<PotionEffect>>(20);
    private static final Gson gson = new Gson();
    private static final Type listType = new TypeToken<ArrayList<FoodEffectEntry>>(){}.getType();
    public static final File effectJson = new File(FoodAddition.configDir, "potion_effects.json");

    public PotionEffectHandler() {
        this.doJsonExists();
        this.loadConfig();
    }

    @SubscribeEvent
    public void onFoodEaten(PlayerUseItemEvent.Finish event) {
        if (!(event.item.func_77973_b() instanceof ItemFood)) {
            return;
        }
        String registryName = Item.field_150901_e.func_148750_c((Object)event.item.func_77973_b());
        String key = registryName.concat("@").concat(String.valueOf(event.item.func_77960_j()));
        List<PotionEffect> effects = effectMap.get(key);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                event.entityPlayer.func_70690_d(new PotionEffect(effect));
            }
        }
    }

    private void loadConfig() {
        try {
            FileReader reader = new FileReader(effectJson);
            List entries = (List)gson.fromJson((Reader)reader, listType);
            for (FoodEffectEntry entry : entries) {
                String key = entry.getItem().concat("@").concat(String.valueOf(entry.getMeta()));
                ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
                for (EffectEntry effect : entry) {
                    potionEffects.add(new PotionEffect(effect.getId(), effect.getDuration(), effect.getAmplifier()));
                }
                effectMap.put(key, potionEffects);
            }
        }
        catch (Exception e) {
            System.err.println("foodaddition".concat(" - Failed to load potion effects config : ".concat(e.getMessage())));
        }
    }

    public void reload() {
        effectMap.clear();
        this.loadConfig();
    }

    public void doJsonExists() {
        if (!effectJson.exists()) {
            String defaultJson = "[\n".concat("  {\n").concat("    \"item\": \"minecraft:apple\",\n").concat("    \"meta\": 0,\n").concat("    \"effects\": [\n").concat("      { \"id\": 10, \"duration\": 20, \"amplifier\": 1 }\n").concat("    ]\n").concat("  }\n").concat("]");
            try {
                Files.write(effectJson.toPath(), defaultJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                FoodAddition.log("[Food Addition] created default potion_effects.json at: " + effectJson.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

