/*
 * Decompiled with CFR 0.152.
 */
package foodaddition.api.items;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;

public abstract class FoodAdditionItem {
    private static final String editedModID = "foodaddition";
    private static final String rawID = "Raw";
    private static final String cookedID = "Cooked";
    private static final int hunger = 2;
    private static final float saturation = 0.3f;
    private final int hungerCooked;
    private final float saturationCooked;
    private Item itemRaw;
    private Item itemCooked;

    public FoodAdditionItem(int hungerCooked, float saturationCooked) {
        this.hungerCooked = hungerCooked;
        this.saturationCooked = saturationCooked;
        this.init();
    }

    public void init() {
        if (this.isItemEnabled()) {
            this.itemRaw = new ItemFood(2, 0.3f, this.canBeFeedToWolf()).func_77655_b(this.getUnlocalizedName(rawID)).func_111206_d(this.getTextureName(rawID));
            GameRegistry.registerItem((Item)this.itemRaw, (String)this.itemRaw.func_77658_a().substring(5));
            this.itemCooked = new ItemFood(this.hungerCooked, this.saturationCooked, this.canBeFeedToWolf()).func_77655_b(this.getUnlocalizedName(cookedID)).func_111206_d(this.getTextureName(cookedID));
            GameRegistry.registerItem((Item)this.itemCooked, (String)this.itemCooked.func_77658_a().substring(5));
        }
    }

    public Item getItemRaw() {
        return this.itemRaw;
    }

    public Item getItemCooked() {
        return this.itemCooked;
    }

    public boolean canBeFeedToWolf() {
        return true;
    }

    public abstract boolean isItemEnabled();

    public String getEntityName() {
        return this.getClass().getSimpleName();
    }

    public String getItemName() {
        return this.getClass().getSimpleName();
    }

    public String getUnlocalizedName(String id) {
        return id.concat(this.getItemName());
    }

    public String getTextureName(String id) {
        return editedModID.concat(":").concat(id).concat(this.getItemName());
    }
}

