/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering.effects;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderState;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderer;
import ivorius.pandorasbox.client.rendering.effects.IvRenderHelper;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffectMeltdown;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;

public class PBEffectRendererMeltdown
implements PBEffectRenderer<PBEffectMeltdown> {
    public class_2960 meltdownTexture1 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_1.png");
    public class_2960 meltdownTexture2 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_2.png");
    public class_2960 meltdownTexture3 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_3.png");

    @Override
    public void renderBox(PandorasBoxRenderer renderer, PandorasBoxRenderState renderState, PBEffectMeltdown effect, float partialTicks, class_4587 poseStack, class_11659 submitNodeCollector, int packedLightIn, float height) {
        int lightColor = 0xFF6611;
        float timePassed = Math.min((float)renderState.effectTicksExisted / (float)effect.getMaxTicksAlive(), 1.0f);
        if ((double)timePassed >= 0.8) {
            timePassed *= timePassed;
            timePassed *= timePassed;
            timePassed *= timePassed * 0.5f;
            float scale = timePassed * 0.3f * effect.getRange() * 0.3f;
            IvRenderHelper.renderLights((float)renderState.entityTickCount + partialTicks, scale, height, lightColor, timePassed * 255.0f, 10, poseStack, submitNodeCollector);
        }
        Arrays.stream(effect.getEffects()).toList().forEach(pbEffect -> {
            PBEffectRenderer renderer1 = PBEffectRenderingRegistry.rendererForEffect(pbEffect);
            if (renderer1 != null && !pbEffect.isDone(renderState.effectTicksExisted)) {
                renderer1.renderBox(renderer, renderState, pbEffect, partialTicks, poseStack, submitNodeCollector, packedLightIn, height);
            }
        });
        if (!renderState.renderItem.method_65606()) {
            return;
        }
        timePassed = Math.min((float)renderState.effectTicksExisted / (float)effect.getMaxTicksAlive(), 1.0f);
        submitNodeCollector.method_73489((class_3879)renderer.model, (Object)renderState, poseStack, class_1921.method_23580((class_2960)this.getTextureForProgress(timePassed)), packedLightIn, class_4608.field_21444, renderState.field_61821, null);
    }

    @Override
    public List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> getLayers(PandorasBoxRenderer renderer, PandorasBoxRenderState renderState, PBEffectMeltdown effect, PandorasBoxModel model, float partialTicks) {
        ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>>();
        Arrays.stream(effect.getEffects()).toList().forEach(pbEffect -> {
            List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> renderLayers;
            PBEffectRenderer renderer1 = PBEffectRenderingRegistry.rendererForEffect(pbEffect);
            if (renderer1 != null && !pbEffect.isDone(renderState.effectTicksExisted) && (renderLayers = renderer1.getLayers(renderer, renderState, pbEffect, model, partialTicks)) != null) {
                layers.addAll(renderLayers);
            }
        });
        return layers;
    }

    public class_2960 getTextureForProgress(float progress) {
        return (double)progress >= 0.75 ? this.meltdownTexture3 : ((double)progress >= 0.35 ? this.meltdownTexture2 : this.meltdownTexture1);
    }
}

