/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.effects.structure.ShapeConfiguration;
import ivorius.pandorasbox.effects.structure.StructureShape;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenShapes
extends PBEffectGenerateByStructure<StructureShape> {
    public static final MapCodec<PBEffectGenShapes> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectGenShapes.base(), (App)PBNBTHelper.arrayCodec(StructureShape.CODEC, () -> new StructureShape[0]).fieldOf("structures").forGetter((Function<PBEffectGenShapes, StructureShape[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStructures(), (Livorius/pandorasbox/effects/PBEffectGenShapes;)[Livorius/pandorasbox/effects/structure/StructureShape;)())).apply((Applicative)instance, PBEffectGenShapes::new));

    public PBEffectGenShapes(int maxTicksAlive) {
        this(maxTicksAlive, new StructureShape[0]);
    }

    public PBEffectGenShapes(int maxTicksAlive, StructureShape[] structures) {
        super(maxTicksAlive);
        this.structures = structures;
    }

    public void setRandomShapes(class_5819 random, Collection<WeightedBlock> blocks, double range, double minSize, double maxSize, int number, int shape) {
        this.structures = new StructureShape[number];
        for (int i = 0; i < ((StructureShape[])this.structures).length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.configuration = new ShapeConfiguration(PandorasBoxHelper.getRandomBlockList(random, blocks), shape < 0 ? random.method_43048(4) : shape, minSize + random.method_43058() * (maxSize - minSize));
            ((StructureShape[])this.structures)[i] = randomShape;
        }
    }

    public void setShapes(class_5819 random, class_2248[] blockSelection, double range, double minSize, double maxSize, int number, int shape, int unifiedSeed) {
        this.structures = new StructureShape[number];
        for (int i = 0; i < ((StructureShape[])this.structures).length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.configuration = new ShapeConfiguration((class_2248[])blockSelection.clone(), shape < 0 ? random.method_43048(4) : shape, minSize + random.method_43058() * (maxSize - minSize));
            randomShape.unifiedSeed = unifiedSeed;
            ((StructureShape[])this.structures)[i] = randomShape;
        }
    }

    @Override
    public void generateStructure(class_1937 level, PandorasBoxEntity entity, class_5819 random, StructureShape structure, class_2338 pos, float newRatio, float prevRatio) {
        double prevSize = structure.getSize() * (double)prevRatio;
        double newSize = structure.getSize() * (double)newRatio;
        int requiredRange = class_3532.method_15357((double)newSize);
        switch (structure.getShapeType()) {
            case 0: {
                for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                    for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                        for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                            double dist = class_3532.method_15355((float)(xPlus * xPlus + yPlus * yPlus + zPlus * zPlus));
                            if (!(dist <= newSize)) continue;
                            if (dist > prevSize) {
                                this.generateOnBlock(level, entity, random, structure, pos.method_10081(structure.pos.method_34592(xPlus, yPlus, zPlus)));
                                continue;
                            }
                            zPlus = -zPlus;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                    for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                        for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                            double xDist = Math.abs(xPlus);
                            double yDist = Math.abs(yPlus);
                            double zDist = Math.abs(zPlus);
                            if (!(xDist <= newSize) || !(yDist <= newSize) || !(zDist <= newSize)) continue;
                            if (xDist > prevSize || yDist > prevSize || zDist > prevSize) {
                                this.generateOnBlock(level, entity, random, structure, pos.method_10081(structure.pos.method_34592(xPlus, yPlus, zPlus)));
                                continue;
                            }
                            zPlus = -zPlus;
                        }
                    }
                }
                break;
            }
            default: {
                int totalHeight = class_3532.method_15357((double)structure.getSize());
                for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                    int yDist = Math.abs(yPlus);
                    if (!((double)yDist <= newSize)) continue;
                    if ((double)yDist > prevSize) {
                        int levelSize = structure.getShapeType() == 2 ? totalHeight - yDist : yDist + 1;
                        for (int xPlus = -levelSize; xPlus <= levelSize; ++xPlus) {
                            for (int zPlus = -levelSize; zPlus <= levelSize; ++zPlus) {
                                this.generateOnBlock(level, entity, random, structure, pos.method_10081(structure.pos.method_34592(xPlus, yPlus, zPlus)));
                            }
                        }
                        continue;
                    }
                    yPlus = -yPlus;
                }
            }
        }
    }

    public void generateOnBlock(class_1937 world, PandorasBoxEntity entity, class_5819 random, StructureShape structure, class_2338 pos) {
        class_2248 block = structure.getBlocks()[random.method_43048(structure.getBlocks().length)];
        PBEffectGenShapes.setBlockVarying(world, pos, block, structure.unifiedSeed);
    }

    @Override
    public StructureShape createStructure() {
        return new StructureShape();
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

