/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntityIDListEffect;
import ivorius.pandorasbox.effects.structure.StructureTarget;
import ivorius.pandorasbox.effects.structure.TargetConfiguration;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.weighted.WeightedEntity;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenTargets
extends PBEffectGenerateByStructure<StructureTarget> {
    public static final MapCodec<PBEffectGenTargets> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectGenTargets.base(), (App)PBNBTHelper.arrayCodec(StructureTarget.CODEC, () -> new StructureTarget[0]).fieldOf("structures").forGetter((Function<PBEffectGenTargets, StructureTarget[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStructures(), (Livorius/pandorasbox/effects/PBEffectGenTargets;)[Livorius/pandorasbox/effects/structure/StructureTarget;)()), (App)WeightedEntity.ID_CODEC.fieldOf("entity_to_spawn").forGetter(PBEffectGenTargets::getEntityToSpawn), (App)Codec.DOUBLE.fieldOf("range").forGetter(PBEffectGenTargets::getRange), (App)Codec.DOUBLE.fieldOf("target_size").forGetter(PBEffectGenTargets::getTargetSize), (App)Codec.DOUBLE.fieldOf("entity_density").forGetter(PBEffectGenTargets::getEntityDensity)).apply((Applicative)instance, PBEffectGenTargets::new));
    public String entityToSpawn;
    public double range;
    public double targetSize;
    public double entityDensity;

    public PBEffectGenTargets(int maxTicksAlive, StructureTarget[] structures, String entityToSpawn, double range, double targetSize, double entityDensity) {
        super(maxTicksAlive);
        this.structures = structures;
        this.entityToSpawn = entityToSpawn;
        this.range = range;
        this.targetSize = targetSize;
        this.entityDensity = entityDensity;
    }

    public PBEffectGenTargets(int maxTicksAlive, String entityToSpawn, double range, double targetSize, double entityDensity) {
        this(maxTicksAlive, new StructureTarget[0], entityToSpawn, range, targetSize, entityDensity);
    }

    public String getEntityToSpawn() {
        return this.entityToSpawn;
    }

    public double getRange() {
        return this.range;
    }

    public double getTargetSize() {
        return this.targetSize;
    }

    public double getEntityDensity() {
        return this.entityDensity;
    }

    public void createTargets(class_1937 world, double x, double y, double z, class_5819 random) {
        List players = world.method_18467(class_1657.class, new class_238(x - this.range, y - this.range, z - this.range, x + this.range, y + this.range, z + this.range));
        this.structures = new StructureTarget[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            class_1657 player = (class_1657)players.get(i);
            StructureTarget structureTarget = new StructureTarget();
            structureTarget.pos = new class_2382(class_3532.method_15357((double)player.method_23317()), class_3532.method_15357((double)(player.method_23318() - 0.5)), class_3532.method_15357((double)player.method_23321()));
            structureTarget.structureStart = random.method_43057() * 0.3f;
            structureTarget.structureLength = 0.5f + random.method_43057() * 0.2f;
            Integer[] colors = new Integer[class_3532.method_15384((double)this.targetSize) * 2];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = random.method_43048(16);
            }
            structureTarget.configuration = new TargetConfiguration(colors);
            ((StructureTarget[])this.structures)[i] = structureTarget;
        }
    }

    @Override
    public void generateStructure(class_1937 level, PandorasBoxEntity entity, class_5819 random, StructureTarget structure, class_2338 pos, float newRatio, float prevRatio) {
        double newRange = (double)newRatio * this.targetSize;
        double prevRange = (double)prevRatio * this.targetSize;
        int requiredRange = class_3532.method_15384((double)newRange);
        for (int xP = -requiredRange; xP <= requiredRange; ++xP) {
            for (int zP = -requiredRange; zP <= requiredRange; ++zP) {
                double dist = class_3532.method_15355((float)(xP * xP + zP * zP));
                if (dist < newRange && dist >= prevRange) {
                    class_6885.class_6888 terracottas = class_7923.field_41175.method_46735(PandorasBox.ALL_TERRACOTTA);
                    class_2382 offset = structure.pos.method_34592(xP, 0, zP);
                    PBEffectGenTargets.setBlockSafe(level, new class_2338(offset), ((class_2248)terracottas.method_40240(structure.getColors()[class_3532.method_15357((double)dist)].intValue()).comp_349()).method_9564());
                    double nextDist = class_3532.method_15355((float)(xP * xP + 9 + (zP * zP + 9)));
                    if (nextDist >= this.targetSize && random.method_43058() < this.entityDensity) {
                        class_1297 newEntity = SpawnEntityIDListEffect.createEntity(level, entity, random, this.entityToSpawn, (double)offset.method_10263() + 0.5, (double)offset.method_10264() + 1.5, (double)offset.method_10260() + 0.5);
                        assert (newEntity != null);
                        level.method_8649(newEntity);
                    }
                }
                for (int yP = 1; yP <= requiredRange; ++yP) {
                    double dist3D = class_3532.method_15355((float)(xP * xP + zP * zP + yP * yP));
                    if (!(dist3D < newRange) || !(dist3D >= prevRange)) continue;
                    PBEffectGenTargets.setBlockToAirSafe(level, new class_2338(structure.pos.method_34592(xP, yP, zP)));
                }
            }
        }
    }

    @Override
    public StructureTarget createStructure() {
        return new StructureTarget();
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

