/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.weighted;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_5819;

public class WeightedSelector {
    public static <T extends Item> double totalWeight(Collection<T> items) {
        return items.stream().mapToDouble(Item::weight).reduce(0.0, Double::sum);
    }

    public static <T> double totalWeight(Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return items.stream().mapToDouble(weightFunction).reduce(0.0, Double::sum);
    }

    public static boolean canSelect(Collection<? extends Item> items) {
        return items.stream().anyMatch(item -> item.weight() > 0.0);
    }

    public static <T> boolean canSelect(Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return items.stream().anyMatch(item -> weightFunction.applyAsDouble(item) > 0.0);
    }

    public static <T> T selectWeightless(class_5819 rand, Collection<T> items, int counted) {
        T item;
        counted = rand.method_43048(counted);
        Iterator<T> iterator = items.iterator();
        do {
            item = iterator.next();
        } while (counted-- != 0 && iterator.hasNext());
        return item;
    }

    public static <T extends Item> T selectItem(class_5819 rand, Collection<T> items) {
        return WeightedSelector.selectItem(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T extends Item> T selectItem(class_5819 rand, Collection<T> items, double totalWeight) {
        return WeightedSelector.selectItem(rand, items, totalWeight, false);
    }

    public static <T extends Item> T selectItem(class_5819 rand, Collection<T> items, boolean remove) {
        return WeightedSelector.selectItem(rand, items, WeightedSelector.totalWeight(items), remove);
    }

    public static <T extends Item> T selectItem(class_5819 rand, Collection<T> items, double totalWeight, boolean remove) {
        if (items.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        double random = rand.method_43058() * totalWeight;
        int counted = 0;
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext()) {
            Item t = (Item)iterator.next();
            if ((random -= t.weight()) <= 0.0) {
                if (remove) {
                    iterator.remove();
                }
                return (T)t;
            }
            ++counted;
        }
        return (T)((Item)WeightedSelector.selectWeightless(rand, items, counted));
    }

    public static <T> T select(class_5819 rand, Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return WeightedSelector.select(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction));
    }

    public static <T> T select(class_5819 rand, Collection<T> items, ToDoubleFunction<T> weightFunction, double totalWeight) {
        return WeightedSelector.select(rand, items, weightFunction, totalWeight, false);
    }

    public static <T> T select(class_5819 rand, Collection<T> items, ToDoubleFunction<T> weightFunction, boolean remove) {
        return WeightedSelector.select(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction), remove);
    }

    public static <T> T select(class_5819 rand, Collection<T> items, ToDoubleFunction<T> weightFunction, double totalWeight, boolean remove) {
        if (items.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        double random = rand.method_43058() * totalWeight;
        int counted = 0;
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if ((random -= weightFunction.applyAsDouble(t)) <= 0.0) {
                if (remove) {
                    iterator.remove();
                }
                return t;
            }
            ++counted;
        }
        return WeightedSelector.selectWeightless(rand, items, counted);
    }

    public static <T> T select(class_5819 rand, Collection<SimpleItem<T>> items) {
        return WeightedSelector.selectItem(rand, items).item();
    }

    public static <T> T select(class_5819 rand, Collection<SimpleItem<T>> items, double totalWeight) {
        return WeightedSelector.selectItem(rand, items, totalWeight).item();
    }

    public static <T> T select(class_5819 rand, Collection<SimpleItem<T>> items, boolean remove) {
        return WeightedSelector.selectItem(rand, items, remove).item();
    }

    public static <T> T select(class_5819 rand, Collection<SimpleItem<T>> items, double totalWeight, boolean remove) {
        return WeightedSelector.selectItem(rand, items, totalWeight, remove).item();
    }

    public static interface Item {
        public double weight();
    }

    public record SimpleItem<T>(double weight, T item) implements Item,
    Comparable<Item>
    {
        public static <T> SimpleItem<T> of(double weight, T item) {
            return new SimpleItem<T>(weight, item);
        }

        public static <T> List<SimpleItem<T>> apply(Stream<T> items, ToDoubleFunction<T> weightFunction) {
            return items.map(input -> new SimpleItem<Object>(weightFunction.applyAsDouble(input), input)).collect(Collectors.toList());
        }

        public static <T> Collection<SimpleItem<T>> apply(Collection<T> items, ToDoubleFunction<T> weightFunction) {
            return Collections2.transform(items, item -> new SimpleItem<Object>(weightFunction.applyAsDouble(item), item));
        }

        public static <T> List<SimpleItem<T>> apply(List<T> items, ToDoubleFunction<T> weightFunction) {
            return SimpleItem.apply(items.stream(), weightFunction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleItem that = (SimpleItem)o;
            if (Double.compare(that.weight, this.weight) != 0) {
                return false;
            }
            return Objects.equals(this.item, that.item);
        }

        @Override
        public int hashCode() {
            int result = Double.hashCode(this.weight);
            result = 31 * result + (this.item != null ? this.item.hashCode() : 0);
            return result;
        }

        @Override
        public String toString() {
            return "SimpleItem{weight=" + this.weight + ", item=" + String.valueOf(this.item) + "}";
        }

        @Override
        public int compareTo(Item o) {
            return Double.compare(this.weight, o.weight());
        }
    }

    public static class ItemComparator
    implements Comparator<Item> {
        @Override
        public int compare(Item o1, Item o2) {
            return Double.compare(o1.weight(), o2.weight());
        }
    }
}

