/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering.effects;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderState;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderer;
import ivorius.pandorasbox.client.rendering.effects.IvRenderHelper;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.client.rendering.effects.renderstate.MeltdownEffectRenderState;
import ivorius.pandorasbox.client.rendering.effects.renderstate.PandoraEffectRenderState;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMeltdown;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;

public class PBEffectRendererMeltdown
extends PBEffectRenderer<PBEffectMeltdown, MeltdownEffectRenderState> {
    public class_2960 meltdownTexture1 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_1.png");
    public class_2960 meltdownTexture2 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_2.png");
    public class_2960 meltdownTexture3 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_3.png");

    @Override
    public void renderBox(PandorasBoxRenderer renderer, PandorasBoxRenderState renderState, MeltdownEffectRenderState effectRenderState, class_4587 poseStack, class_11659 submitNodeCollector, int packedLightIn, float height, float timePassed) {
        int lightColor = 0xFF6611;
        if ((double)timePassed >= 0.8) {
            float renderProgress = timePassed;
            renderProgress *= renderProgress;
            renderProgress *= renderProgress;
            renderProgress *= renderProgress * 0.5f;
            float scale = renderProgress * 0.3f * effectRenderState.range * 0.3f;
            IvRenderHelper.renderLights((float)effectRenderState.effectTicksExisted + renderState.partialTicks, scale, height, lightColor, renderProgress * 255.0f, 10, poseStack, submitNodeCollector);
        }
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            renderer1.renderBox(renderer, renderState, pandoraEffectRenderState, poseStack, submitNodeCollector, packedLightIn, height, PandorasBoxRenderer.calculateProgress(renderState, pandoraEffectRenderState));
        });
        if (!renderState.renderItem.method_65606()) {
            return;
        }
        submitNodeCollector.method_73489((class_3879)renderer.model, (Object)renderState, poseStack, class_1921.method_23580((class_2960)this.getTextureForProgress(timePassed)), packedLightIn, class_4608.field_21444, renderState.field_61821, null);
    }

    @Override
    public List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> getLayers(PandorasBoxRenderer renderer, PandorasBoxRenderState renderState, MeltdownEffectRenderState effectRenderState, PandorasBoxModel model) {
        ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>>();
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> renderLayers = renderer1.getLayers(renderer, renderState, pandoraEffectRenderState, model);
            if (renderLayers != null) {
                layers.addAll(renderLayers);
            }
        });
        return layers;
    }

    @Override
    public PandoraEffectRenderState createRenderState() {
        return new MeltdownEffectRenderState();
    }

    public class_2960 getTextureForProgress(float progress) {
        return (double)progress >= 0.75 ? this.meltdownTexture3 : ((double)progress >= 0.35 ? this.meltdownTexture2 : this.meltdownTexture1);
    }

    @Override
    public void extractRenderState(PandorasBoxRenderState boxRenderState, MeltdownEffectRenderState pandoraEffectRenderState, PBEffectMeltdown pandoraEffect, int effectTicksExisted) {
        super.extractRenderState(boxRenderState, pandoraEffectRenderState, pandoraEffect, effectTicksExisted);
        pandoraEffectRenderState.range = pandoraEffect.getRange();
        ArrayList<PandoraEffectRenderState> effectRenderStates = new ArrayList<PandoraEffectRenderState>();
        for (PBEffect effect : pandoraEffect.getEffects()) {
            PBEffectRenderer<?, ?> renderer = PBEffectRenderingRegistry.rendererForID(effect.rendererResourceLocationForEffect());
            int ticksExistedForEffect = pandoraEffect.getTicksExistedForEffect(effect, effectTicksExisted);
            if (effect.isDone(ticksExistedForEffect) && !renderer.rendersAfterDone()) continue;
            PandoraEffectRenderState renderState = renderer.createRenderState();
            renderer.extractRenderState(boxRenderState, renderState, effect, ticksExistedForEffect);
            effectRenderStates.add(renderState);
        }
        pandoraEffectRenderState.effects = (PandoraEffectRenderState[])effectRenderStates.toArray(PandoraEffectRenderState[]::new);
    }

    @Override
    public boolean rendersAfterDone() {
        return true;
    }
}

