/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effectholder.EffectHolder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.Init;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record PBEffectComponent(class_6885<EffectHolder> holders, class_6885<EffectHolder> randomSelection, Optional<class_1799> renderItem, boolean selectsRandom) implements class_9299
{
    public static final PBEffectComponent DEFAULT = new PBEffectComponent((class_6885<EffectHolder>)class_6885.method_58563(), (class_6885<EffectHolder>)class_6885.method_58563(), Optional.empty(), true);
    public static final Codec<PBEffectComponent> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EffectHolder.CODEC.optionalFieldOf("effect_holders", (Object)class_6885.method_58563()).forGetter(PBEffectComponent::holders), (App)EffectHolder.CODEC.optionalFieldOf("random_selection", (Object)class_6885.method_58563()).forGetter(PBEffectComponent::randomSelection), (App)class_1799.field_49266.optionalFieldOf("render_item").forGetter(PBEffectComponent::renderItem), (App)Codec.BOOL.optionalFieldOf("selects_random", (Object)false).forGetter(PBEffectComponent::selectsRandom)).apply((Applicative)instance, PBEffectComponent::new));
    public static final Codec<PBEffectComponent> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)EffectHolder.CODEC.orElse((Object)class_6885.method_58563()).xmap(holders -> new PBEffectComponent((class_6885<EffectHolder>)holders, (class_6885<EffectHolder>)class_6885.method_58563(), Optional.empty(), holders.method_40247() == 0), PBEffectComponent::holders));

    public PBEffectComponent(class_6885<EffectHolder> holders, class_6885<EffectHolder> randomSelection, Optional<class_1799> renderItem, boolean selectsRandom) {
        this.holders = holders;
        this.randomSelection = randomSelection;
        this.renderItem = renderItem;
        this.selectsRandom = selectsRandom || holders.method_40247() == 0 || randomSelection.method_40247() > 0;
    }

    public PandorasBoxEntity createEffect(class_1937 level, class_1657 player, class_2338 pos, boolean floatAway, class_1799 heldStack) {
        if (level.method_8608()) {
            return null;
        }
        if (this.holders.method_40247() == 0) {
            return PBECRegistry.spawnPandorasBox(level, level.field_9229, heldStack, this.renderItem, true, player, pos, floatAway, this.randomSelection);
        }
        ArrayList<PBEffect> pbEffects = new ArrayList<PBEffect>();
        for (class_6880 holder : this.holders) {
            pbEffects.add(((EffectHolder)holder.comp_349()).effectCreator.constructEffect(level, pos.method_10263(), (double)pos.method_10264() + 1.2, pos.method_10260(), level.field_9229));
        }
        if (this.selectsRandom) {
            pbEffects.addAll(PBECRegistry.createRandomEffects(level, level.field_9229, pos.method_10263(), (double)pos.method_10264() + 1.2, pos.method_10260(), true, Optional.of(this.randomSelection), Init.EFFECT_HOLDER_REGISTRY_KEY));
        }
        return PBECRegistry.spawnPandorasBox(level, new PBEffectMulti(pbEffects.toArray(new PBEffect[0]), new int[pbEffects.size()]), heldStack, this.renderItem, player, pos, floatAway, false);
    }

    public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> consumer, class_1836 tooltipFlag, class_9473 dataComponentGetter) {
        if (this.selectsRandom) {
            consumer.accept((class_2561)class_2561.method_43471((String)"component.pandora_effects.random").method_27692(class_124.field_1078));
            consumer.accept((class_2561)class_2561.method_43473());
        }
        if (this.randomSelection.method_40247() > 0) {
            consumer.accept((class_2561)class_2561.method_43471((String)"component.pandora_effects.random_selection").method_27692(class_124.field_1078));
            for (class_6880 holder : this.randomSelection) {
                consumer.accept((class_2561)class_2561.method_43470((String)" - ").method_10852(((EffectHolder)holder.comp_349()).component()).method_27692(class_124.field_1080));
            }
            consumer.accept((class_2561)class_2561.method_43473());
        }
        if (this.holders.method_40247() > 0) {
            consumer.accept((class_2561)class_2561.method_43471((String)"component.pandora_effects.holders").method_27692(class_124.field_1078));
            for (class_6880 holder : this.holders) {
                consumer.accept((class_2561)class_2561.method_43470((String)" - ").method_10852(((EffectHolder)holder.comp_349()).component()).method_27692(class_124.field_1080));
            }
        }
    }

    public boolean isEmpty() {
        return this.equals(DEFAULT);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PBEffectComponent)) {
            return false;
        }
        PBEffectComponent that = (PBEffectComponent)o;
        return this.selectsRandom() == that.selectsRandom() && Objects.equals(this.renderItem(), that.renderItem()) && Objects.equals(this.holders(), that.holders()) && Objects.equals(this.randomSelection(), that.randomSelection());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.holders(), this.randomSelection(), this.renderItem(), this.selectsRandom());
    }
}

