/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.effects.entity.DrugEntityEffect;
import ivorius.pandorasbox.mods.PsychedelicraftHooks;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record PBECDrugEntities(IValue time, IValue number, DValue range, float chanceForMoreEffects, List<PsychedelicraftHooks.WeightedDrugType> drugTypes, Optional<Integer> color) implements PBEffectCreator
{
    public static final MapCodec<PBECDrugEntities> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECDrugEntities::time), (App)IValue.CODEC.fieldOf("number").forGetter(PBECDrugEntities::number), (App)DValue.CODEC.fieldOf("range").forGetter(PBECDrugEntities::range), (App)class_5699.method_65311((float)0.0f, (float)1.0f).fieldOf("chance_for_more_effects").forGetter(PBECDrugEntities::chanceForMoreEffects), (App)PsychedelicraftHooks.WeightedDrugType.DRUG_TYPE_CODEC.listOf().fieldOf("drug_types").forGetter(PBECDrugEntities::drugTypes), (App)RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("r").forGetter(Vector3f::x), (App)Codec.FLOAT.fieldOf("g").forGetter(Vector3f::y), (App)Codec.FLOAT.fieldOf("b").forGetter(Vector3f::z)).apply((Applicative)i, Vector3f::new)).xmap(MathUtils::getArgb, MathUtils::unpackRgb).optionalFieldOf("color").forGetter(PBECDrugEntities::color)).apply((Applicative)instance, PBECDrugEntities::new));

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int number = this.number.getValue(random);
        int time = this.time.getValue(random);
        double range = this.range.getValue(random);
        ArrayList<DrugInfluence> effects = new ArrayList<DrugInfluence>(number);
        for (int i = 0; i < number; ++i) {
            PsychedelicraftHooks.WeightedDrugType weightedDrug = WeightedSelector.selectItem(random, this.drugTypes);
            float value = random.method_43057() * (weightedDrug.maxAddValue() - weightedDrug.minAddValue()) + weightedDrug.minAddValue();
            DrugInfluence drugInfluence = this.color.map(vector3f -> new DrugInfluence((DrugType)weightedDrug.drugTypeHolder().comp_349(), 0, 0.0, 0.0, (double)value, vector3f.intValue())).orElseGet(() -> new DrugInfluence((DrugType)weightedDrug.drugTypeHolder().comp_349(), 0, 0.0, 0.0, (double)value));
            effects.add(drugInfluence);
        }
        return new PBEffectEntityBased(time, range, new DrugEntityEffect(effects));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return this.chanceForMoreEffects;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

