/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effectholder.EffectHolder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntityIDListEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.EntityInit;
import ivorius.pandorasbox.init.Init;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class PBECRegistry {
    public static final int MAX_DELAY_IN_MULTIEFFECT = 60;

    public static PBEffectCreator randomEffectCreatorOfType(class_5819 random, List<EffectHolder> holders) {
        return holders.get((int)random.method_43048((int)holders.size())).effectCreator;
    }

    public static PBEffect createEffect(class_1937 world, class_5819 random, double x, double y, double z, PBEffectCreator creator) {
        if (!PBECRegistry.isAnyNull(world, random, creator)) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffect(class_1937 world, class_5819 random, double x, double y, double z, boolean multi, Optional<class_6885<EffectHolder>> selection, class_5321<? extends class_2378<EffectHolder>> registryKey) {
        List<PBEffect> effects = PBECRegistry.createRandomEffects(world, random, x, y, z, multi, selection, registryKey);
        if (effects.size() == 1) {
            return effects.getFirst();
        }
        PBEffect[] effectArray = effects.toArray(new PBEffect[0]);
        int[] delays = new int[effectArray.length];
        for (int i = 1; i < delays.length; ++i) {
            delays[i] = random.method_43048(60);
        }
        return new PBEffectMulti(effectArray, delays);
    }

    public static List<PBEffect> createRandomEffects(class_1937 world, class_5819 random, double x, double y, double z, boolean multi, Optional<class_6885<EffectHolder>> selection, class_5321<? extends class_2378<EffectHolder>> registryKey) {
        class_6885 holders = selection.filter(set -> set.method_40247() > 0).orElseGet(() -> class_6885.method_40242(world.method_30349().method_30530(registryKey).method_42017().toList()));
        boolean isPeaceful = world.method_8407().equals((Object)class_1267.field_5801);
        List<EffectHolder> fixedChanceHolders = holders.method_40239().map(class_6880::comp_349).filter(effectHolder -> effectHolder.fixedChance() != -1.0).toList();
        List<EffectHolder> positiveEffects = holders.method_40239().map(class_6880::comp_349).filter(effectHolder -> !fixedChanceHolders.contains(effectHolder) && effectHolder.isGood()).toList();
        List<EffectHolder> negativeEffects = holders.method_40239().map(class_6880::comp_349).filter(effectHolder -> !fixedChanceHolders.contains(effectHolder) && !effectHolder.isGood()).toList();
        float currentMinChance = 1.0f;
        ArrayList<PBEffect> effects = new ArrayList<PBEffect>();
        do {
            PBEffect effect;
            PBEffectCreator creator = null;
            for (EffectHolder fixedChanceCreator : fixedChanceHolders) {
                if (!(random.method_43058() < fixedChanceCreator.fixedChance()) || fixedChanceCreator.canBeGoodOrBad() && !fixedChanceCreator.isGood() && isPeaceful) continue;
                creator = fixedChanceCreator.effectCreator;
                break;
            }
            if (creator == null) {
                creator = PBECRegistry.randomEffectCreatorOfType(random, isPeaceful || (double)random.method_43057() < (Double)PandorasBox.CONFIG.goodEffectChance.get() ? positiveEffects : negativeEffects);
            }
            if ((effect = PBECRegistry.constructEffectSafe(creator, world, x, y, z, random)) != null) {
                effects.add(effect);
            }
            currentMinChance = Math.min(currentMinChance, creator.chanceForMoreEffects(world, x, y, z, random));
        } while (effects.isEmpty() || multi && (double)random.method_43057() < PBECRegistry.newEffectChance(currentMinChance) && effects.size() < (Integer)PandorasBox.CONFIG.maxEffectsPerBox.get());
        return effects;
    }

    private static double newEffectChance(double effectFactor) {
        double intensity = (Double)PandorasBox.CONFIG.boxIntensity.get();
        return intensity == 0.0 ? 0.0 : Math.pow(effectFactor, 1.0 / intensity);
    }

    public static PBEffect constructEffectSafe(PBEffectCreator creator, class_1937 world, double x, double y, double z, class_5819 random) {
        return creator.constructEffect(world, x, y, z, random);
    }

    public static PandorasBoxEntity spawnPandorasBox(class_1937 world, class_5819 random, class_1799 heldItem, Optional<class_1799> renderItem, boolean multi, class_1657 player, class_2338 pos, boolean floatAway, class_6885<EffectHolder> holders) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, pos.method_10263(), (double)pos.method_10264() + 1.2, pos.method_10260(), multi, Optional.of(holders), Init.EFFECT_HOLDER_REGISTRY_KEY);
        return PBECRegistry.spawnPandorasBox(world, effect, heldItem, renderItem, player, pos, floatAway, true);
    }

    public static PandorasBoxEntity spawnPandorasBox(class_1937 world, class_5819 random, Optional<class_1799> renderItem, boolean multi, class_1657 player) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, player.method_23317(), player.method_23318() + 1.2, player.method_23321(), multi, Optional.empty(), Init.EFFECT_HOLDER_REGISTRY_KEY);
        return PBECRegistry.spawnPandorasBox(world, effect, class_1799.field_8037, renderItem, player, null, true, true);
    }

    public static PandorasBoxEntity spawnPandorasBox(class_1937 world, class_5819 random, Optional<class_1799> renderItem, PBEffectCreator creator, class_1657 player) {
        PBEffect effect = PBECRegistry.createEffect(world, random, player.method_23317(), player.method_23318() + 1.2, player.method_23321(), creator);
        return PBECRegistry.spawnPandorasBox(world, effect, class_1799.field_8037, renderItem, player, null, true, false);
    }

    public static PandorasBoxEntity spawnPandorasBox(class_1937 world, PBEffect effect, class_1799 heldItem, Optional<class_1799> renderItem, class_1657 player, class_2338 pos, boolean floatAway, boolean canGenerateMoreEffectsAfterwards) {
        if (effect != null && !world.method_8608()) {
            PandorasBoxEntity pandorasBox = new PandorasBoxEntity(EntityInit.BOX, world, canGenerateMoreEffectsAfterwards, !floatAway, heldItem.method_7958());
            if (pos == null) {
                pos = class_2338.method_49637((double)(player.method_23317() + (double)player.method_5735().method_10148()), (double)player.method_23318(), (double)(player.method_23321() + (double)player.method_5735().method_10165()));
            }
            while (world.method_8320(pos).method_51366()) {
                if (!world.method_8320(pos.method_10074()).method_51366()) {
                    pos = pos.method_10074();
                    continue;
                }
                pos = pos.method_10084();
            }
            pandorasBox.setBoxEffect(effect);
            pandorasBox.setBoxWaitingTime(40);
            SpawnEntityIDListEffect.moveTo(pandorasBox, new class_243((class_2382)pos), player.method_36454() + 180.0f, 0.0f);
            if (renderItem.isPresent()) {
                class_1799 chosen = heldItem.method_46651(1);
                if (!renderItem.get().method_7960()) {
                    chosen = renderItem.get();
                }
                pandorasBox.setRenderItem(chosen);
            }
            pandorasBox.beginFloating();
            pandorasBox.setOwner((class_1309)player);
            world.method_8649((class_1297)pandorasBox);
            return pandorasBox;
        }
        return null;
    }

    public static boolean isAnyNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }
}

