/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnItems;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.effects.entity.ThrowItemsEntityEffect;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public record PBECThrowItems(IValue time, DValue range, DValue throwChancePerItem, DValue deletionChancePerThrow, IValue smuggledInItems, EitherArrayList<RandomizedItemStack, RandomizedItemTag> items) implements PBEffectCreator
{
    public static final MapCodec<PBECThrowItems> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECThrowItems::time), (App)DValue.CODEC.fieldOf("range").forGetter(PBECThrowItems::range), (App)DValue.CODEC.fieldOf("throw_chance_per_item").forGetter(PBECThrowItems::throwChancePerItem), (App)DValue.CODEC.fieldOf("deletion_chance_per_throw").forGetter(PBECThrowItems::deletionChancePerThrow), (App)IValue.CODEC.fieldOf("smuggled_in_items").forGetter(PBECThrowItems::smuggledInItems), (App)RandomizedItemStack.LIST_CODEC.fieldOf("items").forGetter(PBECThrowItems::items)).apply((Applicative)instance, PBECThrowItems::new));

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int time = this.time.getValue(random);
        double range = this.range.getValue(random);
        double chancePerItem = this.throwChancePerItem.getValue(random);
        double deletionChance = this.deletionChancePerThrow.getValue(random);
        int smuggledIn = this.smuggledInItems.getValue(random);
        class_1799[] stacks = PBECSpawnItems.getItemStacks(random, world.method_30349(), PandorasBoxHelper.assembleRandomisedStacks((class_2378<class_1792>)class_7923.field_41178, (class_2378<class_2248>)class_7923.field_41175, this.items), smuggledIn, random.method_43048(3) != 0, true, 0, false, false);
        return new PBEffectEntityBased(time, range, new ThrowItemsEntityEffect(chancePerItem, deletionChance, stacks));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.15f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

