/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.generate.two_dimensional.GenDome;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenWorldSnake
extends PBEffectNormal {
    public static final MapCodec<PBEffectGenWorldSnake> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectGenWorldSnake.base(), (App)PBNBTHelper.arrayCodec(class_7923.field_41175.method_39673(), () -> new class_2248[0]).fieldOf("blocks").forGetter(PBEffectGenWorldSnake::getBlocks), (App)Codec.INT.fieldOf("unified_seed").forGetter(PBEffectGenWorldSnake::getUnifiedSeed), (App)class_243.field_38277.fieldOf("current_position").forGetter(PBEffectGenWorldSnake::getCurrent), (App)Codec.DOUBLE.fieldOf("size").forGetter(PBEffectGenWorldSnake::getSize), (App)Codec.DOUBLE.fieldOf("speed").forGetter(PBEffectGenWorldSnake::getSpeed), (App)Codec.FLOAT.fieldOf("direction_yaw").forGetter(PBEffectGenWorldSnake::getDirYaw), (App)Codec.FLOAT.fieldOf("direction_pitch").forGetter(PBEffectGenWorldSnake::getDirPitch), (App)Codec.FLOAT.fieldOf("direction_yaw_accel").forGetter(PBEffectGenWorldSnake::getDirYawAcc), (App)Codec.FLOAT.fieldOf("direction_pitch_accel").forGetter(PBEffectGenWorldSnake::getDirPitchAcc)).apply((Applicative)instance, PBEffectGenWorldSnake::new));
    public class_2248[] blocks;
    public int unifiedSeed;
    public class_243 current;
    public double size;
    public double speed;
    public float dirYaw;
    public float dirPitch;
    public float dirYawAcc;
    public float dirPitchAcc;

    public PBEffectGenWorldSnake(int maxTicksAlive, class_2248[] blocks, int unifiedSeed, class_243 current, double size, double speed, float dirYaw, float dirPitch, float dirYawAcc, float dirPitchAcc) {
        super(maxTicksAlive);
        this.blocks = blocks;
        this.unifiedSeed = unifiedSeed;
        this.current = current;
        this.size = size;
        this.speed = speed;
        this.dirYaw = dirYaw;
        this.dirPitch = dirPitch;
        this.dirYawAcc = dirYawAcc;
        this.dirPitchAcc = dirPitchAcc;
    }

    public PBEffectGenWorldSnake(int maxTicksAlive, class_2248[] blocks, int unifiedSeed, double currentX, double currentY, double currentZ, double size, double speed, float dirYaw, float dirPitch) {
        this(maxTicksAlive, blocks, unifiedSeed, new class_243(currentX, currentY, currentZ), size, speed, dirYaw, dirPitch, 0.0f, 0.0f);
    }

    public class_2248[] getBlocks() {
        return this.blocks;
    }

    public int getUnifiedSeed() {
        return this.unifiedSeed;
    }

    public class_243 getCurrent() {
        return this.current;
    }

    public double getSize() {
        return this.size;
    }

    public double getSpeed() {
        return this.speed;
    }

    public float getDirYaw() {
        return this.dirYaw;
    }

    public float getDirPitch() {
        return this.dirPitch;
    }

    public float getDirYawAcc() {
        return this.dirYawAcc;
    }

    public float getDirPitchAcc() {
        return this.dirPitchAcc;
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        if (!level.method_8608()) {
            int requiredRange = class_3532.method_15384((double)this.size);
            float f1 = class_3532.method_15362((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = class_3532.method_15374((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -class_3532.method_15362((float)(-this.dirPitch * ((float)Math.PI / 180)));
            float f4 = class_3532.method_15374((float)(-this.dirPitch * ((float)Math.PI / 180)));
            double dirX = (double)(f2 * f3) * this.speed;
            double dirY = (double)f4 * this.speed;
            double dirZ = (double)(f1 * f3) * this.speed;
            double newX = this.current.field_1352 + dirX;
            double newY = this.current.field_1351 + dirY;
            double newZ = this.current.field_1350 + dirZ;
            int baseX = class_3532.method_15357((double)newX);
            int baseY = class_3532.method_15357((double)newY);
            int baseZ = class_3532.method_15357((double)newZ);
            for (int x = -requiredRange; x <= requiredRange; ++x) {
                for (int y = -requiredRange; y <= requiredRange; ++y) {
                    for (int z = -requiredRange; z <= requiredRange; ++z) {
                        if (!GenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, newX, newY, newZ, 0.0, this.size) || GenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, this.current.field_1352, this.current.field_1351, this.current.field_1350, 0.0, this.size)) continue;
                        PBEffectGenWorldSnake.setBlockVarying(level, new class_2338(x + baseX, y + baseY, z + baseZ), this.blocks[random.method_43048(this.blocks.length)], this.unifiedSeed);
                    }
                }
            }
            this.current = new class_243(newX, newY, newZ);
            this.dirYaw += this.dirYawAcc;
            this.dirPitch += this.dirPitchAcc;
            this.dirYawAcc += class_3532.method_15363((float)((random.method_43057() - random.method_43057()) * 0.5f), (float)-10.0f, (float)10.0f);
            this.dirPitchAcc += class_3532.method_15363((float)((random.method_43057() - random.method_43057()) * 0.5f), (float)-10.0f, (float)10.0f);
        }
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

