/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.position.PositionEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectPositionBased
extends PBEffectNormal {
    public static final MapCodec<PBEffectPositionBased> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectPositionBased.base(), (App)Codec.INT.fieldOf("number").forGetter(PBEffectPositionBased::getNumber), (App)Codec.DOUBLE.fieldOf("range").forGetter(PBEffectPositionBased::getRange), (App)PositionEffect.CODEC.fieldOf("effect").forGetter(PBEffectPositionBased::getEffect)).apply((Applicative)instance, PBEffectPositionBased::new));
    public final int number;
    public final double range;
    public final PositionEffect effect;

    public PBEffectPositionBased(int time, int number, double range, PositionEffect effect) {
        super(time);
        this.number = number;
        this.range = range;
        this.effect = effect;
    }

    public int getNumber() {
        return this.number;
    }

    public double getRange() {
        return this.range;
    }

    public PositionEffect getEffect() {
        return this.effect;
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            int prev = this.getSpawnNumber(prevRatio);
            int toSpawn = this.getSpawnNumber(newRatio) - prev;
            for (int i = 0; i < toSpawn; ++i) {
                double eX = effectCenter.field_1352 + (random.method_43058() - random.method_43058()) * this.range;
                double eY = effectCenter.field_1351 + (random.method_43058() - random.method_43058()) * 3.0 * 2.0;
                double eZ = effectCenter.field_1350 + (random.method_43058() - random.method_43058()) * this.range;
                this.effect.doEffect(serverLevel, entity, random, newRatio, prevRatio, eX, eY, eZ);
            }
        }
    }

    private int getSpawnNumber(float ratio) {
        return class_3532.method_15375((float)(ratio * (float)this.number));
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

