/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.generate.block_mappers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.generate.block_mappers.BlockMapper;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.EquipmentSet;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import ivorius.pandorasbox.weighted.WeightedSelector;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2473;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3749;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public record CityMapper(Either<class_2248, class_6862<class_2248>>[] targets, List<class_1299<?>> spawnerEntities, class_6885<@NotNull EquipmentSet> equipmentSets, EitherArrayList<RandomizedItemStack, RandomizedItemTag> items) implements BlockMapper
{
    public static final MapCodec<CityMapper> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(Codec.either((Codec)class_7923.field_41175.method_39673(), (Codec)class_6862.method_40093((class_5321)class_7924.field_41254)), () -> new Either[0]).fieldOf("targets").forGetter(CityMapper::targets), (App)class_7923.field_41177.method_39673().listOf().fieldOf("spawner_entities").forGetter(CityMapper::spawnerEntities), (App)EquipmentSet.INDIRECT_CODEC.fieldOf("equipment_sets").forGetter(CityMapper::equipmentSets), (App)RandomizedItemStack.LIST_CODEC.fieldOf("items").forGetter(CityMapper::items)).apply((Applicative)instance, CityMapper::new));

    @Override
    public boolean matches(class_3218 serverLevel, PandorasBoxEntity entity, class_2338 blockPos, class_2680 state, class_5819 random) {
        return this.targets.length == 0 || PBEffect.isBlockAnyOf(state.method_26204(), this.targets);
    }

    @Override
    public void convertBlock(class_3218 serverLevel, class_2338 pos, class_2680 state, class_5819 random, PandorasBoxEntity entity, class_243 effectCenter, int pass, int unifiedSeed, double range) {
        if (serverLevel.method_8320(pos.method_10084()).method_26204() == class_2246.field_10124) {
            if (serverLevel.field_9229.method_43048(144) == 0) {
                block6: for (int i = 0; i < 4; ++i) {
                    switch (i) {
                        case 0: {
                            class_2338 newPos = pos.method_10078();
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10078().method_10084(), class_2246.field_10136.method_9564());
                            continue block6;
                        }
                        case 1: {
                            class_2338 newPos = pos.method_10067();
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10067().method_10084(), class_2246.field_10136.method_9564());
                            continue block6;
                        }
                        case 2: {
                            class_2338 newPos = pos.method_10095();
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10078(), class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10067(), class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10095().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10078().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10095().method_10078().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10067().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10095().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10095().method_10067().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10095().method_10084(), class_2246.field_10136.method_9564());
                            continue block6;
                        }
                        case 3: {
                            class_2338 newPos = pos.method_10072();
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10078(), class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10067(), class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10219.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10072().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10078().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10072().method_10078().method_10078().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10067().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10072().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10072().method_10067().method_10067().method_10084(), class_2246.field_10136.method_9564());
                            PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10072().method_10084(), class_2246.field_10136.method_9564());
                        }
                    }
                }
                PBEffect.setBlockSafe((class_1937)serverLevel, pos, class_2246.field_10566.method_9564());
                PBEffect.setBlockSafe((class_1937)serverLevel, pos.method_10084(), (class_2680)class_2246.field_10394.method_9564().method_11657((class_2769)class_2473.field_11476, (Comparable)Integer.valueOf(1)));
                ((class_2473)class_2246.field_10394).method_10507(serverLevel, pos.method_10084(), serverLevel.method_8320(pos.method_10084()), serverLevel.field_9229);
            } else if (serverLevel.field_9229.method_43048(81) == 0) {
                int pHeight = random.method_39332(3, 7);
                for (int yp = 0; yp <= pHeight; ++yp) {
                    if (yp != pHeight) {
                        PBEffect.setBlockSafe((class_1937)serverLevel, pos.method_10086(yp), class_2246.field_10252.method_9564());
                        continue;
                    }
                    class_2338 newPos = pos.method_10086(yp);
                    PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10252.method_9564());
                    newPos = this.randomDir(newPos, serverLevel.field_9229);
                    PBEffect.setBlockSafe((class_1937)serverLevel, newPos, class_2246.field_10252.method_9564());
                    PBEffect.setBlockSafe((class_1937)serverLevel, newPos.method_10074(), (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.TRUE));
                }
            } else if (serverLevel.field_9229.method_43048(144) == 0) {
                PBEffect.setBlockSafe((class_1937)serverLevel, pos, class_2246.field_10107.method_9564());
                int width = serverLevel.field_9229.method_39332(3, 6);
                int floors = serverLevel.field_9229.method_39332(1, 10);
                floors = floors < 3 || (double)serverLevel.field_9229.method_43057() > 0.8 ? floors : 3;
                int height = floors * width * 2;
                for (int y = pos.method_10264(); y <= pos.method_10264() + height + 2; ++y) {
                    for (int x = pos.method_10263() - width; x <= pos.method_10263() + width; ++x) {
                        for (int z = pos.method_10260() - width; z <= pos.method_10260() + width; ++z) {
                            this.buildStructure((class_1937)serverLevel, new class_2338(x, y, z), width, height, pos.method_10264(), pos.method_10263(), pos.method_10260());
                        }
                    }
                }
                class_2338 stairPos = pos.method_10069(width - 1, 0, width - 1);
                class_2350 direction = class_2350.field_11039;
                int sideProgress = 0;
                while (stairPos.method_10264() - pos.method_10264() < height + 1) {
                    class_2338 stepPos = stairPos.method_10093(direction);
                    class_2680 stairState = (class_2680)class_2246.field_10392.method_9564().method_47968((class_2769)class_2510.field_11571, (Comparable)direction);
                    class_2680 inverseState = (class_2680)((class_2680)class_2246.field_10392.method_9564().method_47968((class_2769)class_2510.field_11571, (Comparable)direction.method_10153())).method_47968((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
                    if (++sideProgress == 2 * (width - 1)) {
                        direction = direction.method_10170();
                        sideProgress = 0;
                        PBEffect.setBlockSafe((class_1937)serverLevel, stepPos, class_2246.field_10093.method_9564());
                        heightenedPos = stepPos.method_10062();
                        for (i = 0; i < 3; ++i) {
                            heightenedPos = heightenedPos.method_10084();
                            PBEffect.setBlockToAirSafe((class_1937)serverLevel, heightenedPos);
                        }
                    } else {
                        if (stepPos.method_10264() - pos.method_10264() > 0) {
                            PBEffect.setBlockSafe((class_1937)serverLevel, stepPos, inverseState);
                        }
                        if ((stepPos = stepPos.method_10084()).method_10264() - pos.method_10264() < height + 1) {
                            PBEffect.setBlockSafe((class_1937)serverLevel, stepPos, stairState);
                            heightenedPos = stepPos.method_10062();
                            for (i = 0; i < 3; ++i) {
                                heightenedPos = heightenedPos.method_10084();
                                PBEffect.setBlockToAirSafe((class_1937)serverLevel, heightenedPos);
                            }
                        } else {
                            PBEffect.setBlockSafe((class_1937)serverLevel, stepPos.method_10074(), class_2246.field_10093.method_9564());
                        }
                    }
                    stairPos = stepPos;
                }
            } else if (serverLevel.field_9229.method_43048(64) == 0) {
                PBEffect.setBlockSafe((class_1937)serverLevel, pos, class_2246.field_10033.method_9564());
                PBEffect.setBlockSafe((class_1937)serverLevel, pos.method_10074(), class_2246.field_10524.method_9564());
                PBEffect.setBlockSafe((class_1937)serverLevel, pos.method_10087(2), class_2246.field_10002.method_9564());
            } else {
                PBEffect.setBlockSafe((class_1937)serverLevel, pos, class_2246.field_10235.method_9564());
            }
        } else {
            PBEffect.setBlockSafe((class_1937)serverLevel, pos, class_2246.field_10235.method_9564());
        }
    }

    public void buildStructure(class_1937 world, class_2338 currentPos, int width, int height, int originY, int originX, int originZ) {
        class_3218 serverLevel = (class_3218)world;
        int relativeHeight = currentPos.method_10264() - originY;
        double relative = (double)relativeHeight / (double)(width * 2);
        if (currentPos.method_10264() == originY || relative == Math.ceil(relative)) {
            if (currentPos.method_10263() == originX && currentPos.method_10260() == originZ) {
                PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10260.method_9564());
                class_2586 block = world.method_8321(currentPos);
                if (block instanceof class_2636) {
                    class_2636 spawnerBlock = (class_2636)block;
                    int entity = world.field_9229.method_43048(this.spawnerEntities.size());
                    spawnerBlock.method_46408(this.spawnerEntities.get(entity), world.field_9229);
                }
                return;
            }
            if (IvMathHelper.compareOffsets(currentPos.method_10263(), originX, width - 1) && currentPos.method_10260() == originZ) {
                PBEffect.setBlockSafe(world, currentPos.method_10084(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.method_10147((float)(originX - currentPos.method_10263()), (float)0.0f, (float)0.0f)));
                class_2595 chestBlockEntity = (class_2595)world.method_8321(currentPos.method_10084());
                if (chestBlockEntity != null) {
                    List<RandomizedItemStack> itemSelection = PandorasBoxHelper.assembleRandomisedStacks((class_2378<class_1792>)class_7923.field_41178, (class_2378<class_2248>)class_7923.field_41175, this.items);
                    if ((double)world.field_9229.method_43057() > 0.05) {
                        for (int i = 0; i < world.field_9229.method_43048(5) + 2; ++i) {
                            RandomizedItemStack chestContent = WeightedSelector.selectItem(world.field_9229, itemSelection);
                            class_1799 stack = chestContent.itemStack().method_7972();
                            if (chestContent.max() > stack.method_7914()) {
                                stack.method_57379(class_9334.field_50071, (Object)chestContent.max());
                            }
                            stack.method_7939(chestContent.min() + world.field_9229.method_43048(chestContent.max() - chestContent.min() + 1));
                            int slot = world.field_9229.method_43048(chestBlockEntity.method_5439());
                            while (!chestBlockEntity.method_5438(slot).method_7960()) {
                                slot = world.field_9229.method_43048(chestBlockEntity.method_5439());
                            }
                            chestBlockEntity.method_5447(slot, stack);
                        }
                    } else {
                        EquipmentSet set = WeightedSelector.selectItem(world.field_9229, this.equipmentSets.method_40239().map(class_6880::comp_349).toList());
                        class_1799[] itemSet = set.items();
                        class_1799[] chestContent = new class_1799[itemSet.length];
                        for (int i = 0; i < itemSet.length; ++i) {
                            chestContent[i] = itemSet[i].method_7972();
                        }
                        chestBlockEntity.method_58685(chestBlockEntity.method_58693(), class_9326.method_57841().method_57854(class_9334.field_49631, (Object)set.name()).method_57852());
                        for (class_1799 stack : chestContent) {
                            int slot = world.field_9229.method_43048(chestBlockEntity.method_5439());
                            while (!chestBlockEntity.method_5438(slot).method_7960()) {
                                slot = world.field_9229.method_43048(chestBlockEntity.method_5439());
                            }
                            chestBlockEntity.method_5447(slot, stack);
                        }
                    }
                }
            }
            if (IvMathHelper.compareOffsets(currentPos.method_10263(), originX, width - 1) || IvMathHelper.compareOffsets(currentPos.method_10260(), originZ, width - 1)) {
                PBEffect.setBlockSafe(world, currentPos, class_2246.field_10235.method_9564());
                return;
            }
            PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10107.method_9564());
        } else if (IvMathHelper.compareOffsets(currentPos.method_10263(), originX, width) || IvMathHelper.compareOffsets(currentPos.method_10260(), originZ, width)) {
            if (relativeHeight >= height + 1) {
                if (IvMathHelper.compareOffsets(currentPos.method_10263(), originX, width) && IvMathHelper.compareOffsets(currentPos.method_10260(), originZ, width)) {
                    PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10107.method_9564());
                } else if (relativeHeight == height + 1) {
                    PBEffect.setBlockSafe(world, currentPos, this.glassState((class_1937)serverLevel, currentPos, (class_2389)class_2246.field_10355));
                }
                return;
            }
            if (currentPos.method_10263() == originX || currentPos.method_10260() == originZ) {
                if (relativeHeight < 3) {
                    PBEffect.setBlockToAirSafe((class_1937)serverLevel, currentPos);
                } else if (relativeHeight == 3) {
                    PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10107.method_9564());
                } else {
                    PBEffect.setBlockSafe(world, currentPos, this.glassState((class_1937)serverLevel, currentPos, (class_2389)class_2246.field_10355));
                }
            } else if (currentPos.method_10263() == originX + width - 1 || currentPos.method_10260() == originZ + width - 1) {
                PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10107.method_9564());
            } else {
                PBEffect.setBlockSafe((class_1937)serverLevel, currentPos, class_2246.field_10107.method_9564());
            }
        } else if (!world.method_8320(currentPos).method_27852(class_2246.field_10034)) {
            PBEffect.setBlockToAirSafe(world, currentPos);
        }
    }

    public class_2338 randomDir(class_2338 original, class_5819 random) {
        class_2350 dir = class_2350.method_10139((int)random.method_43048(4));
        return switch (dir) {
            case class_2350.field_11043 -> original.method_10095();
            case class_2350.field_11035 -> original.method_10072();
            case class_2350.field_11034 -> original.method_10078();
            case class_2350.field_11039 -> original.method_10067();
            default -> original;
        };
    }

    public class_2680 glassState(class_1937 level, class_2338 pos, class_2389 block) {
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 west = pos.method_10067();
        class_2338 east = pos.method_10078();
        class_2680 northState = level.method_8320(north);
        class_2680 southState = level.method_8320(south);
        class_2680 westState = level.method_8320(west);
        class_2680 eastState = level.method_8320(east);
        return (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(block.method_10281(northState, northState.method_26206((class_1922)level, north, class_2350.field_11035))))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(block.method_10281(southState, southState.method_26206((class_1922)level, south, class_2350.field_11043))))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(block.method_10281(westState, westState.method_26206((class_1922)level, west, class_2350.field_11034))))).method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(block.method_10281(eastState, eastState.method_26206((class_1922)level, east, class_2350.field_11039))));
    }

    @Override
    @NotNull
    public MapCodec<? extends BlockMapper> codec() {
        return CODEC;
    }
}

