/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.utils;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EitherArrayList<L, R>
extends ArrayList<Either<L, R>> {
    public EitherArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public EitherArrayList() {
    }

    public EitherArrayList(Collection<? extends Either<L, R>> c) {
        super(c);
    }

    public Set<L> leftSide() {
        return this.stream().filter(lrEither -> lrEither.left().isPresent()).map(lrEither -> lrEither.left().get()).collect(Collectors.toSet());
    }

    public Set<R> rightSide() {
        return this.stream().filter(lrEither -> lrEither.right().isPresent()).map(lrEither -> lrEither.right().get()).collect(Collectors.toSet());
    }

    public L getL(int index) {
        return (L)((Either)this.get(index)).orThrow();
    }

    public R getR(int index) {
        return (R)((Either)this.get(index)).swap().orThrow();
    }

    public boolean addLeft(L obj) {
        return this.add(Either.left(obj));
    }

    public void addLeft(int index, L obj) {
        this.add(index, Either.left(obj));
    }

    public boolean addRight(R obj) {
        return this.add(Either.right(obj));
    }

    public void addRight(int index, R obj) {
        this.add(index, Either.right(obj));
    }

    public <T> List<T> map(Function<L, T> leftMapper, Function<R, T> rightMapper) {
        return this.stream().map(either -> either.map(leftMapper, rightMapper)).toList();
    }
}

