/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.entity.EntityEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectEntityBased
extends PBEffectNormal {
    public static final MapCodec<PBEffectEntityBased> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectEntityBased.base(), (App)Codec.DOUBLE.fieldOf("range").forGetter(PBEffectEntityBased::getRange), (App)EntityEffect.CODEC.fieldOf("effect").forGetter(PBEffectEntityBased::getEffect)).apply((Applicative)instance, PBEffectEntityBased::new));
    public final EntityEffect effect;
    public final double range;

    public PBEffectEntityBased(int maxTicksAlive, double range, EntityEffect effect) {
        super(maxTicksAlive);
        this.effect = effect;
        this.range = range;
    }

    public EntityEffect getEffect() {
        return this.effect;
    }

    public double getRange() {
        return this.range;
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        class_238 bb = new class_238(effectCenter.field_1352 - this.range, effectCenter.field_1351 - this.range, effectCenter.field_1350 - this.range, effectCenter.field_1352 + this.range, effectCenter.field_1351 + this.range, effectCenter.field_1350 + this.range);
        List entities = level.method_18467(class_1309.class, bb);
        for (class_1309 entityLivingBase : entities) {
            double dist = entityLivingBase.method_5739((class_1297)entity);
            double strength = (this.range - dist) / this.range;
            if (!(strength > 0.0)) continue;
            this.effect.affectEntity(level, entity, random, entityLivingBase, newRatio, prevRatio, strength);
        }
    }

    @Override
    public void finalizeEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random) {
        this.effect.finalise(level, entity, effectCenter, random);
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

