/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.serialization.MapCodec;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.effects.generate.flags.GenerateByFlag;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenerateByFlag
extends PBEffectRangeBased {
    public static final MapCodec<PBEffectGenerateByFlag> CODEC = PBEffectGenerateByFlag.produceCodec(instance -> GenerateByFlag.CODEC.fieldOf("generate_by_flag").forGetter(PBEffectGenerateByFlag::getGenerateByFlag), PBEffectGenerateByFlag::new);
    public final GenerateByFlag generateByFlag;

    public PBEffectGenerateByFlag(int time, double range, int passes, int unifiedSeed, GenerateByFlag generateByFlag) {
        super(time, range, passes, unifiedSeed);
        this.generateByFlag = generateByFlag;
    }

    public GenerateByFlag getGenerateByFlag() {
        return this.generateByFlag;
    }

    @Override
    public void setUpEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random) {
        super.setUpEffect(level, entity, effectCenter, random);
        byte requiredRange = (byte)class_3532.method_15384((double)this.range);
        int baseX = class_3532.method_15357((double)effectCenter.field_1352);
        int baseY = class_3532.method_15357((double)effectCenter.field_1351);
        int baseZ = class_3532.method_15357((double)effectCenter.field_1350);
        boolean[] flags = new boolean[31];
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                    double dist = class_3532.method_15355((float)(x * x + y * y + z * z));
                    if (!(dist <= this.range)) continue;
                    flags[y + 15] = this.generateByFlag.hasFlag(level, entity, random, new class_2338(baseX + x, baseY + y, baseZ + z));
                }
                this.setAllFlags(x, z, flags);
            }
        }
    }

    @Override
    public void generateInRange(class_1937 level, PandorasBoxEntity entity, class_5819 random, class_243 effectCenter, double prevRange, double newRange, int pass) {
        byte requiredRange = (byte)class_3532.method_15384((double)newRange);
        int baseX = class_3532.method_15357((double)effectCenter.field_1352);
        int baseY = class_3532.method_15357((double)effectCenter.field_1351);
        int baseZ = class_3532.method_15357((double)effectCenter.field_1350);
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                    double dist = class_3532.method_15355((float)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateByFlag.generateOnBlock(level, entity, random, pass, this.unifiedSeed, new class_2338(baseX + x, baseY + y, baseZ + z), dist, this.getFlag(x, y, z));
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    public void setAllFlags(byte x, byte z, boolean ... flags) {
        int flagInt = 0;
        for (int i = flags.length - 1; i >= 0; --i) {
            boolean flag = flags[i];
            if (flag) {
                flagInt = (flagInt << 1) + 1;
                continue;
            }
            flagInt <<= 1;
        }
        this.generateByFlag.flags()[this.getFlagIndex((byte)x, (byte)z)] = flagInt;
    }

    public void setFlag(byte x, byte y, byte z, boolean flag) {
        int index = this.getFlagIndex(x, z);
        int bit = this.getBitOfFlag(y);
        this.generateByFlag.flags()[index] = flag ? this.generateByFlag.flags()[index] | bit : this.generateByFlag.flags()[index] & ~bit;
    }

    public boolean getFlag(byte x, byte y, byte z) {
        int index = this.getFlagIndex(x, z);
        int bit = this.getBitOfFlag(y);
        return (this.generateByFlag.flags()[index] & bit) > 0;
    }

    public int getBitOfFlag(byte y) {
        return 1 << y + 15;
    }

    public int getFlagIndex(byte x, byte z) {
        return (x + 15) * 31 + (z + 15);
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

