/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.spawn_entities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.spawn_entities.EntitySpawnConfiguration;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntitiesEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.random.PandorasBoxEntityNamer;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1472;
import net.minecraft.class_1493;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4760;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_9282;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public record SpawnEntityIDListEffect(String[][] entityIDs, int nameEntities, int equipLevel, int buffLevel, EntitySpawnConfiguration entitySpawnConfiguration) implements SpawnEntitiesEffect
{
    public static final MapCodec<SpawnEntityIDListEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(PBNBTHelper.arrayCodec(Codec.STRING, () -> new String[0]), () -> new String[0][]).fieldOf("entities").forGetter(SpawnEntityIDListEffect::entityIDs), (App)Codec.INT.fieldOf("named_entities").forGetter(SpawnEntityIDListEffect::nameEntities), (App)Codec.INT.fieldOf("equipment_level").forGetter(SpawnEntityIDListEffect::equipLevel), (App)Codec.INT.fieldOf("buff_level").forGetter(SpawnEntityIDListEffect::buffLevel), (App)EntitySpawnConfiguration.MAP_CODEC.forGetter(SpawnEntityIDListEffect::entitySpawnConfiguration)).apply((Applicative)instance, SpawnEntityIDListEffect::new));

    @Override
    public class_1297 spawnEntity(class_1937 world, PandorasBoxEntity pbEntity, class_5819 random, int number, double x, double y, double z) {
        if (world.method_8608()) {
            return null;
        }
        String[] entityTower = this.entityIDs[number];
        class_1297 previousEntity = null;
        for (String entityID : entityTower) {
            class_1297 newEntity = SpawnEntityIDListEffect.createEntity(world, pbEntity, random, entityID, x, y, z);
            if (newEntity instanceof class_1309) {
                SpawnEntityIDListEffect.randomizeEntity(random, pbEntity.method_5628(), (class_1309)newEntity, this.nameEntities, this.equipLevel, this.buffLevel);
            }
            if (previousEntity != null) {
                world.method_8649(previousEntity);
                assert (newEntity != null);
                previousEntity.method_5873(newEntity, true);
            }
            previousEntity = newEntity;
        }
        if (previousEntity != null) {
            world.method_8649(previousEntity);
        }
        return previousEntity;
    }

    public static void randomizeEntity(class_5819 random, long namingSeed, class_1309 entityLiving, int nameEntities, int equipLevel, int buffLevel) {
        if (!entityLiving.method_16914()) {
            if (nameEntities == 1) {
                entityLiving.method_5665(PandorasBoxEntityNamer.getRandomName(random));
                entityLiving.method_5880(true);
            } else if (nameEntities == 2) {
                entityLiving.method_5665(PandorasBoxEntityNamer.getRandomCasualName(random));
            } else if (nameEntities == 3) {
                entityLiving.method_5665(PandorasBoxEntityNamer.getRandomCasualName(class_5819.method_43049((long)namingSeed)));
            }
        }
        if (equipLevel > 0) {
            float itemChancePerSlot = 1.0f - 0.5f / (float)equipLevel;
            float upgradeChancePerSlot = 1.0f - 1.0f / (float)equipLevel;
            for (int i = 0; i < 5; ++i) {
                int itemLevel;
                if (!(random.method_43057() < itemChancePerSlot)) continue;
                for (itemLevel = 0; random.method_43057() < upgradeChancePerSlot && itemLevel < equipLevel; ++itemLevel) {
                }
                if (i == 0) {
                    class_1799 itemStack = PandorasBoxHelper.getRandomWeaponItemForLevel(random, itemLevel);
                    if (itemStack == null) {
                        itemStack = class_1799.field_8037;
                    }
                    entityLiving.method_5673(class_1304.field_6173, itemStack);
                    continue;
                }
                if (i == 4 && random.method_43057() < 0.2f / (float)equipLevel) {
                    entityLiving.method_5673(class_1304.field_6169, new class_1799((class_1935)(random.method_43057() < 0.1f ? class_2246.field_10009 : class_2246.field_10147)));
                    continue;
                }
                class_1304 slot = i == 1 ? class_1304.field_6172 : (i == 2 ? class_1304.field_6166 : class_1304.field_6174);
                class_1792 item = class_1308.method_5948((class_1304)slot, (int)Math.min(itemLevel, 4));
                if (item != null) {
                    entityLiving.method_5673(slot, new class_1799((class_1935)item));
                    continue;
                }
                System.err.println("Pandora's Box: Item not found for slot '" + String.valueOf(slot) + "', level '" + itemLevel + "'");
            }
        }
        if (buffLevel > 0) {
            class_1324 attackDamage;
            class_1324 movementSpeed;
            class_1324 knockbackResistance;
            class_1324 health = entityLiving.method_5996(class_5134.field_23716);
            if (health != null) {
                double healthMultiplierP = random.method_43058() * (double)buffLevel * 0.25;
                health.method_26837(new class_1322(class_2960.method_60655((String)"pandorasbox", (String)"zeus_magic_health"), healthMultiplierP, class_1322.class_1323.field_6330));
            }
            if ((knockbackResistance = entityLiving.method_5996(class_5134.field_23718)) != null) {
                double knockbackResistanceP = random.method_43058() * (double)buffLevel * 0.25;
                knockbackResistance.method_26837(new class_1322(class_2960.method_60655((String)"pandorasbox", (String)"zeus_magic_knockback_resistance"), knockbackResistanceP, class_1322.class_1323.field_6330));
            }
            if ((movementSpeed = entityLiving.method_5996(class_5134.field_23719)) != null) {
                double movementSpeedP = random.method_43058() * (double)buffLevel * 0.08;
                movementSpeed.method_26837(new class_1322(class_2960.method_60655((String)"pandorasbox", (String)"zeus_magic_speed"), movementSpeedP, class_1322.class_1323.field_6330));
            }
            if ((attackDamage = entityLiving.method_5996(class_5134.field_23721)) != null) {
                double attackDamageP = random.method_43058() * (double)buffLevel * 0.25;
                attackDamage.method_26837(new class_1322(class_2960.method_60655((String)"pandorasbox", (String)"zeus_magic_damage"), attackDamageP, class_1322.class_1323.field_6330));
            }
        }
    }

    public static class_1297 createEntity(class_1937 world, PandorasBoxEntity pbEntity, class_5819 random, String entityID, double x, double y, double z) {
        try {
            String trunkEntityID = class_2960.method_60654((String)entityID).method_12832();
            if ("pbspecial_colorful_sheep".equals(trunkEntityID)) {
                class_1472 sheep = (class_1472)class_1299.field_6115.method_5883(world, class_3730.field_16462);
                assert (sheep != null);
                if (random.method_43048(1024) == 0) {
                    sheep.method_5665((class_2561)class_2561.method_43470((String)"jeb_"));
                }
                SpawnEntityIDListEffect.moveTo((class_1297)sheep, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                sheep.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                sheep.method_6631(class_1767.method_7791((int)random.method_43048(16)));
                return sheep;
            }
            if ("pbspecial_hogfather".equals(trunkEntityID)) {
                class_1642 santa = (class_1642)class_1299.field_6051.method_5883(world, class_3730.field_16462);
                class_1799 helmet = new class_1799((class_1935)class_1802.field_8267);
                helmet.method_57379(class_9334.field_49644, (Object)new class_9282(0xFF0000));
                class_1799 chestPlate = new class_1799((class_1935)class_1802.field_8577);
                chestPlate.method_57379(class_9334.field_49644, (Object)new class_9282(0xFF0000));
                class_1799 leggings = new class_1799((class_1935)class_1802.field_8570);
                leggings.method_57379(class_9334.field_49644, (Object)new class_9282(0xFF0000));
                class_1799 boots = new class_1799((class_1935)class_1802.field_8370);
                boots.method_57379(class_9334.field_49644, (Object)new class_9282(0xFF0000));
                assert (santa != null);
                SpawnEntityIDListEffect.moveTo((class_1297)santa, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                santa.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                santa.method_5673(class_1304.field_6169, helmet);
                santa.method_5673(class_1304.field_6174, chestPlate);
                santa.method_5673(class_1304.field_6172, leggings);
                santa.method_5673(class_1304.field_6166, boots);
                santa.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8600));
                santa.method_5665((class_2561)class_2561.method_43470((String)"Hogfather"));
                return santa;
            }
            if ("pbspecial_experience".equals(trunkEntityID)) {
                return new class_1303(world, x, y, z, 10);
            }
            if ("pbspecial_wolf_tamed".equals(trunkEntityID)) {
                class_1657 owner = PBEffect.getPlayer(world, pbEntity);
                class_1493 wolf = (class_1493)class_1299.field_6055.method_5883(world, class_3730.field_16462);
                assert (wolf != null);
                SpawnEntityIDListEffect.moveTo((class_1297)wolf, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                wolf.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                if (owner != null) {
                    wolf.method_5942().method_6340();
                    wolf.method_5980(null);
                    wolf.method_6170(owner);
                    wolf.method_37908().method_8421((class_1297)wolf, (byte)7);
                }
                return wolf;
            }
            if ("pbspecial_cat_tamed".equals(trunkEntityID)) {
                class_1657 owner = PBEffect.getPlayer(world, pbEntity);
                class_1451 cat = (class_1451)class_1299.field_16281.method_5883(world, class_3730.field_16462);
                assert (cat != null);
                SpawnEntityIDListEffect.moveTo((class_1297)cat, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                cat.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                if (owner != null) {
                    cat.method_6170(owner);
                    world.method_8421((class_1297)cat, (byte)7);
                }
                return cat;
            }
            if ("pbspecial_parrot_tamed".equals(trunkEntityID)) {
                class_1657 owner = PBEffect.getPlayer(world, pbEntity);
                class_1453 parrot = (class_1453)class_1299.field_6104.method_5883(world, class_3730.field_16462);
                assert (parrot != null);
                SpawnEntityIDListEffect.moveTo((class_1297)parrot, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                parrot.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                if (owner != null) {
                    parrot.method_6170(owner);
                    world.method_8421((class_1297)parrot, (byte)7);
                }
                return parrot;
            }
            if (trunkEntityID.startsWith("pbspecial_tnt")) {
                class_1541 primedTnt = new class_1541(world, x, y, z, (class_1309)PBEffect.getPlayer(world, pbEntity));
                primedTnt.method_6967(Integer.parseInt(trunkEntityID.substring(13)));
                return primedTnt;
            }
            if (trunkEntityID.startsWith("pbspecial_invisible_tnt")) {
                class_1541 primedTnt = new class_1541(world, x, y, z, (class_1309)PBEffect.getPlayer(world, pbEntity));
                primedTnt.method_6967(Integer.parseInt(trunkEntityID.substring(23)));
                primedTnt.method_5648(true);
                return primedTnt;
            }
            if ("pbspecial_fireworks".equals(trunkEntityID)) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8639);
                stack.method_57379(class_9334.field_49616, (Object)SpawnEntityIDListEffect.createRandomFirework(random));
                return new class_1671(world, x, y, z, stack);
            }
            if ("pbspecial_angry_wolf".equals(trunkEntityID)) {
                class_1493 wolf = (class_1493)class_1299.field_6055.method_5883(world, class_3730.field_16462);
                assert (wolf != null);
                wolf.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                SpawnEntityIDListEffect.moveTo((class_1297)wolf, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                wolf.method_5980((class_1309)world.method_18459(x, y, z, 40.0, false));
                return wolf;
            }
            if ("pbspecial_charged_creeper".equals(trunkEntityID)) {
                class_1548 creeper = (class_1548)class_1299.field_6046.method_5883(world, class_3730.field_16462);
                assert (creeper != null);
                creeper.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
                SpawnEntityIDListEffect.moveTo((class_1297)creeper, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
                creeper.method_5841().method_12778(class_1548.field_7224, (Object)true);
                return creeper;
            }
            class_1299 entity = (class_1299)class_7923.field_41177.method_63535(class_2960.method_12829((String)entityID));
            class_1297 entity1 = entity.method_5883(world, class_3730.field_16462);
            assert (entity1 != null);
            SpawnEntityIDListEffect.moveTo(entity1, new class_243(x, y, z), random.method_43057() * 360.0f, 0.0f);
            class_1657 owner = PBEffect.getPlayer(world, pbEntity);
            if (owner != null && entity1.method_23318() - owner.method_23318() > (double)(entity.method_18387() * 16)) {
                entity1.method_5814(entity1.method_23317(), owner.method_23318() + (double)(entity.method_18387() * 16) - 1.0, entity1.method_23321());
            }
            if (entity1 instanceof class_5418) {
                class_5418 piglin = (class_5418)entity1;
                piglin.method_30240(true);
            }
            if (entity1 instanceof class_4760) {
                class_4760 hoglin = (class_4760)entity1;
                hoglin.method_26948(true);
            }
            if (entity1 instanceof class_1308) {
                class_1308 mob = (class_1308)entity1;
                mob.method_5943((class_5425)((class_3218)world), world.method_8404(class_2338.method_49637((double)x, (double)y, (double)z)), null, null);
            }
            return entity1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void moveTo(class_1297 entity, class_243 pos, float yRot, float xRot) {
        entity.method_33574(pos);
        entity.method_64578(yRot, xRot);
    }

    public static class_9284 createRandomFirework(class_5819 random) {
        return new class_9284(random.method_43048(15) != 0 ? 1 : 2 + random.method_43048(2), SpawnEntityIDListEffect.createRandomFireworkExplosions(random, random.method_43048(20) != 0 ? 1 : 1 + random.method_43048(2)));
    }

    public static List<class_9283> createRandomFireworkExplosions(class_5819 random, int number) {
        ArrayList<class_9283> list = new ArrayList<class_9283>();
        for (int i = 0; i < number; ++i) {
            list.add(SpawnEntityIDListEffect.createRandomFireworkExplosion(random));
        }
        return list;
    }

    public static class_9283 createRandomFireworkExplosion(class_5819 random) {
        class_9283.class_1782 fireworkShape = class_9283.class_1782.method_7813((int)(random.method_43048(10) != 0 ? 0 : random.method_43048(4) + 1));
        int size = random.method_43048(15) != 0 ? 1 : random.method_43048(2) + 2;
        IntArrayList colors = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            colors.add(i, class_1767.method_7791((int)random.method_43048(16)).method_7790());
        }
        IntList fadeColors = IntLists.emptyList();
        if (random.method_43048(25) == 0) {
            size = random.method_43048(2) + 1;
            fadeColors = new IntArrayList(size);
            for (int i = 0; i < size; ++i) {
                fadeColors.add(i, class_1767.method_7791((int)random.method_43048(16)).method_7790());
            }
        }
        return new class_9283(fireworkShape, (IntList)colors, fadeColors, random.method_43048(30) == 0, random.method_43048(20) == 0);
    }

    @Override
    @NotNull
    public MapCodec<? extends SpawnEntitiesEffect> codec() {
        return CODEC;
    }
}

