/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.worldgen;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import ivorius.pandorasbox.worldgen.AccessibleTreeFeature;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4643;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class WorldGenColorfulTree
extends class_2944
implements AccessibleTreeFeature {
    public class_2248 trunk;
    public int[] metas;
    public class_2248 soil;
    private Random random;
    private class_1937 level;
    private class_2338 origin = class_2338.field_10980;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double field_175944_d = 0.381;
    double field_175945_e = 1.0;
    double leafDensity = 1.0;
    int spread = 1;
    int maxHeight;
    int leafDistanceLimit;
    List<FoliageCoordinates> foliageCoords;

    public WorldGenColorfulTree(Codec<class_4643> configIn, int height) {
        super(configIn);
        this.maxHeight = height;
        this.leafDistanceLimit = 4;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.origin.method_10264() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.origin.method_10086(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                double d0 = this.field_175945_e * (double)f * ((double)this.random.nextFloat() + 0.328);
                double d1 = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double d2 = d0 * Math.sin(d1) + 0.5;
                double d3 = d0 * Math.cos(d1) + 0.5;
                class_2338 blockpos = this.origin.method_10081((class_2382)class_2338.method_49637((double)d2, (double)(k - 1), (double)d3));
                class_2338 blockpos1 = blockpos.method_10086(this.leafDistanceLimit);
                this.func_175936_a(blockpos, blockpos1);
                int i1 = this.origin.method_10263() - blockpos.method_10263();
                int j1 = this.origin.method_10260() - blockpos.method_10260();
                double d4 = (double)blockpos.method_10264() - Math.sqrt(i1 * i1 + j1 * j1) * this.field_175944_d;
                int k1 = (int)Math.min(d4, (double)j);
                class_2338 blockpos2 = new class_2338(this.origin.method_10263(), k1, this.origin.method_10260());
                this.func_175936_a(blockpos2, blockpos);
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.method_10264()));
            }
        }
    }

    void createLeaves(class_2338 blockPos, float f, class_2680 blockState) {
        int i = (int)((double)f + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                class_2338 blockpos1;
                class_2680 state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(f * f)) || !(state = this.level.method_8320(blockpos1 = blockPos.method_10069(j, 0, k))).method_26215() && !state.method_26164(class_3481.field_15503)) continue;
                this.method_13153((class_1945)this.level, blockpos1, blockState);
            }
        }
    }

    float layerSize(int p_76490_1_) {
        if ((float)p_76490_1_ < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)p_76490_1_;
        float f2 = class_3532.method_15355((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int p_76495_1_) {
        return p_76495_1_ >= 0 && p_76495_1_ < this.leafDistanceLimit ? (p_76495_1_ != 0 && p_76495_1_ != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void placeLeaves(class_2338 blockPos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.createLeaves(blockPos.method_10086(i), this.leafSize(i), this.trunk.method_9564());
        }
    }

    void placeBlock(class_2338 blockPos, class_2338 blockPos1, class_2248 block) {
        class_2338 blockPos2 = blockPos1.method_10069(-blockPos.method_10263(), -blockPos.method_10264(), -blockPos.method_10260());
        int i = this.getHighestAbsoluteCoordinate(blockPos2);
        float f = (float)blockPos2.method_10263() / (float)i;
        float f1 = (float)blockPos2.method_10264() / (float)i;
        float f2 = (float)blockPos2.method_10260() / (float)i;
        for (int j = 0; j <= i; ++j) {
            class_2338 blockPos3 = blockPos.method_10081((class_2382)class_2338.method_49637((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2)));
            this.method_13153((class_1945)this.level, blockPos3, block.method_9564());
        }
    }

    private int getHighestAbsoluteCoordinate(class_2338 p_175935_1_) {
        int i = class_3532.method_15382((int)p_175935_1_.method_10263());
        int j = class_3532.method_15382((int)p_175935_1_.method_10264());
        int k = class_3532.method_15382((int)p_175935_1_.method_10260());
        return k > i && k > j ? k : Math.max(j, i);
    }

    void createLeafNodes() {
        for (FoliageCoordinates foliagecoordinates : this.foliageCoords) {
            this.placeLeaves(foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void buildTrunk() {
        class_2338 blockpos = this.origin;
        class_2338 blockpos1 = this.origin.method_10086(this.height);
        class_2248 block = this.trunk;
        this.placeBlock(blockpos, blockpos1, block);
        if (this.spread == 2) {
            this.placeBlock(blockpos.method_10078(), blockpos1.method_10078(), block);
            this.placeBlock(blockpos.method_10078().method_10072(), blockpos1.method_10078().method_10072(), block);
            this.placeBlock(blockpos.method_10072(), blockpos1.method_10072(), block);
        }
    }

    void placeLeaves() {
        for (FoliageCoordinates foliageCoordinates : this.foliageCoords) {
            int i = foliageCoordinates.getHeight();
            class_2338 blockpos = new class_2338(this.origin.method_10263(), i, this.origin.method_10260());
            if (!this.leafNodeNeedsBase(i - this.origin.method_10264())) continue;
            this.placeBlock(blockpos, foliageCoordinates, this.trunk);
        }
    }

    int func_175936_a(class_2338 blockPos, class_2338 blockPos1) {
        class_2338 blockPos2 = blockPos1.method_10069(-blockPos.method_10263(), -blockPos.method_10264(), -blockPos.method_10260());
        int i = this.getHighestAbsoluteCoordinate(blockPos2);
        float f = (float)blockPos2.method_10263() / (float)i;
        float f1 = (float)blockPos2.method_10264() / (float)i;
        float f2 = (float)blockPos2.method_10260() / (float)i;
        if (i != 0) {
            for (int j = 0; j <= i; ++j) {
                blockPos.method_10081((class_2382)class_2338.method_49637((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2)));
            }
        }
        return -1;
    }

    private boolean validTreeLocation() {
        boolean isSoil;
        class_2338 down = this.origin.method_10074();
        class_2680 state = this.level.method_8320(down);
        boolean bl = isSoil = state.method_26204() == this.soil;
        if (!isSoil) {
            return false;
        }
        int i = this.func_175936_a(this.origin, this.origin.method_10086(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    @Override
    public void setMetas(int[] newMetas) {
        this.metas = newMetas;
    }

    @Override
    public void setSoil(class_2248 newSoil) {
        this.soil = newSoil;
    }

    @Override
    public boolean place(class_1937 worldIn, class_5819 rand, class_2338 position) {
        this.level = worldIn;
        this.origin = position;
        this.random = new Random(rand.method_43055());
        class_6885.class_6888 blocks = class_7923.field_41175.method_46735(class_3481.field_15481);
        this.trunk = (class_2248)blocks.method_40240(this.metas[rand.method_43048(this.metas.length)]).comp_349();
        if (this.level == null) {
            return false;
        }
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.random.nextInt(this.maxHeight);
        }
        if (!this.validTreeLocation()) {
            this.level = null;
            return false;
        }
        this.generateLeafNodeList();
        this.createLeafNodes();
        this.buildTrunk();
        this.placeLeaves();
        this.level = null;
        return true;
    }

    static class FoliageCoordinates
    extends class_2338 {
        private final int height;

        public FoliageCoordinates(class_2338 blockPos, int height) {
            super((class_2382)blockPos);
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

