/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnItems;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZChance;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnEnchantedItems(IValue number, IValue ticksPerItem, IValue enchantmentLevel, EitherArrayList<RandomizedItemStack, RandomizedItemTag> items, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn, ZValue giveNames, ZValue spawnsFromEffectCenter) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnEnchantedItems> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnEnchantedItems::number), (App)IValue.CODEC.fieldOf("ticks_per_item").forGetter(PBECSpawnEnchantedItems::ticksPerItem), (App)IValue.CODEC.fieldOf("enchantment_level").forGetter(PBECSpawnEnchantedItems::enchantmentLevel), (App)RandomizedItemStack.LIST_CODEC.fieldOf("items").forGetter(PBECSpawnEnchantedItems::items), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnEnchantedItems::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnEnchantedItems::valueSpawn), (App)ZValue.CODEC.optionalFieldOf("give_names", (Object)new ZChance(0.5)).forGetter(PBECSpawnEnchantedItems::giveNames), (App)ZValue.CODEC.fieldOf("spawns_from_effect_center").forGetter(PBECSpawnEnchantedItems::spawnsFromEffectCenter)).apply((Applicative)instance, PBECSpawnEnchantedItems::new));

    public PBECSpawnEnchantedItems(IValue number, IValue ticksPerItem, IValue enchantmentLevel, EitherArrayList<RandomizedItemStack, RandomizedItemTag> items, ZValue giveNames, ZValue spawnsFromEffectCenter) {
        this(number, ticksPerItem, enchantmentLevel, items, Optional.of(PBECSpawnItems.defaultThrow()), Optional.empty(), giveNames, spawnsFromEffectCenter);
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        class_1799[] stacks;
        int number = this.number.getValue(random);
        int enchantLevel = this.enchantmentLevel.getValue(random);
        int ticksPerItem = this.ticksPerItem.getValue(random);
        boolean giveNames = this.giveNames.getValue(random);
        for (class_1799 stack : stacks = PBECSpawnItems.getItemStacks(random, world.method_30349(), PandorasBoxHelper.assembleRandomisedStacks((class_2378<class_1792>)class_7923.field_41178, this.items), number, false, true, enchantLevel, giveNames, false)) {
            stack.method_7939(1);
        }
        return PBECSpawnItems.constructEffect(random, stacks, number * ticksPerItem + 1, this.valueThrow.orElse(null), this.valueSpawn.orElse(null), this.spawnsFromEffectCenter);
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

